/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServerUtils;
import com.sqlapp.data.db.metadata.PartitionFunctionReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.PartitionFunction;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.properties.DataTypeLengthProperties;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DoubleKeyMap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2005PartitionFunctionReader
extends PartitionFunctionReader {
    protected SqlServer2005PartitionFunctionReader(Dialect dialect) {
        super(dialect);
    }

    protected List<PartitionFunction> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final DoubleKeyMap map = CommonUtils.doubleKeyMap();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String name;
                String catalog_name = this.getString(rs, "catalog_name");
                PartitionFunction obj = (PartitionFunction)map.get((Object)catalog_name, (Object)(name = this.getString(rs, PARTITION_FUNCTION_NAME)));
                if (obj == null) {
                    obj = SqlServer2005PartitionFunctionReader.this.createPartitionFunction(rs);
                    map.put((Object)catalog_name, (Object)name, (Object)obj);
                }
                obj.getValues().add((Object)this.getString(rs, "value"));
            }
        });
        return map.toList();
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("partitionFunctions2005.sql");
    }

    protected PartitionFunction createPartitionFunction(ExResultSet rs) throws SQLException {
        String catalog_name = this.getString((ResultSet)rs, "catalog_name");
        String name = this.getString((ResultSet)rs, PARTITION_FUNCTION_NAME);
        PartitionFunction obj = new PartitionFunction(name);
        obj.setCatalogName(catalog_name);
        obj.setCreatedAt(rs.getTimestamp("create_date"));
        obj.setLastAlteredAt(rs.getTimestamp("modify_date"));
        String productDataType = this.getString((ResultSet)rs, "type_name");
        Long byteLength = this.getLong((ResultSet)rs, "max_length");
        Long maxLength = SqlServerUtils.getMaxLength(productDataType, byteLength);
        Long precision = rs.getLongValue("precision");
        Integer scale = rs.getInteger("scale");
        obj.setDataTypeName(productDataType);
        this.getDialect().setDbType(productDataType, CommonUtils.notZero((Long[])new Long[]{maxLength, precision}), scale, (DataTypeLengthProperties)obj);
        obj.setBoundaryValueOnRight(rs.getBoolean("boundary_value_on_right"));
        obj.setId("" + rs.getInt("function_id"));
        return obj;
    }
}

