/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2000CheckConstraintReader;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServerUtils;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.CheckConstraint;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2005CheckConstraintReader
extends SqlServer2000CheckConstraintReader {
    protected SqlServer2005CheckConstraintReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<CheckConstraint> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final TripleKeyMap map = CommonUtils.tripleKeyMap();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String catalog_name = this.getString(rs, "catalog_name");
                String schema_name = this.getString(rs, "schema_name");
                String table_name = this.getString(rs, "table_name");
                String constraint_name = this.getString(rs, "constraint_name");
                String columnName = this.getString(rs, "column_name");
                CheckConstraint c = (CheckConstraint)map.get((Object)catalog_name, (Object)schema_name, (Object)constraint_name);
                if (c == null) {
                    c = SqlServer2005CheckConstraintReader.this.createCheckConstraint(rs);
                    map.put((Object)catalog_name, (Object)schema_name, (Object)constraint_name, (Object)c);
                } else {
                    String definition = SqlServerUtils.replaceNames(c.getExpression(), columnName);
                    c.setExpression(definition);
                }
                Column column = new Column(columnName);
                column.setTableName(table_name);
                c.addColumns(new Column[]{column});
            }
        });
        List list = map.toList();
        return list;
    }

    @Override
    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("checkConstraints2005.sql");
    }

    @Override
    protected CheckConstraint createCheckConstraint(ExResultSet rs) throws SQLException {
        CheckConstraint c = super.createCheckConstraint(rs);
        c.setEnable(rs.getInt("is_disabled") != 1);
        this.setSpecifics(rs, "is_not_trusted", (SpecificsProperty)c);
        this.setSpecifics(rs, "is_not_for_replication", (SpecificsProperty)c);
        return c;
    }
}

