/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common;

import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiClients {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiClients.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getApiClient(Class<?> apiClass, String fileName, String defaultClientName) {
        InputStream propertiesStream = null;
        try {
            propertiesStream = apiClass.getResourceAsStream(fileName);
            if (propertiesStream != null) {
                Properties props = new Properties();
                props.load(propertiesStream);
                String name = (String)props.get("api-client.name");
                String version = (String)props.get("api-client.version");
                String string = name + "-" + version;
                return string;
            }
        }
        catch (Throwable t) {
            LOGGER.error("Exception reading {} configuration file", (Object)fileName, (Object)t);
        }
        finally {
            if (propertiesStream != null) {
                try {
                    propertiesStream.close();
                }
                catch (Throwable t) {
                    LOGGER.info("Exception closing {} configuration file", (Object)fileName, (Object)t);
                }
            }
        }
        return defaultClientName;
    }
}

