/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.http;

import com.stackify.api.common.collect.SynchronizedEvictingQueue;
import com.stackify.api.common.http.HttpClient;
import com.stackify.api.common.http.HttpException;
import com.stackify.api.common.lang.Threads;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResendQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResendQueue.class);
    private final Queue<byte[]> resendQueue;

    public HttpResendQueue(int maxSize) {
        this.resendQueue = new SynchronizedEvictingQueue<byte[]>(maxSize);
    }

    public int size() {
        return this.resendQueue.size();
    }

    public void offer(byte[] request, IOException e) {
        this.resendQueue.offer(request);
    }

    public void offer(byte[] request, HttpException e) {
        if (!e.isClientError()) {
            this.resendQueue.offer(request);
        }
    }

    public void drain(HttpClient httpClient, String path) {
        this.drain(httpClient, path, false);
    }

    public void drain(HttpClient httpClient, String path, boolean gzip) {
        if (!this.resendQueue.isEmpty()) {
            try {
                LOGGER.info("Attempting to retransmit {} requests", (Object)this.resendQueue.size());
                while (!this.resendQueue.isEmpty()) {
                    byte[] jsonBytes = this.resendQueue.peek();
                    httpClient.post(path, jsonBytes, gzip);
                    this.resendQueue.remove();
                    Threads.sleepQuietly(250L, TimeUnit.MILLISECONDS);
                }
            }
            catch (Throwable t) {
                LOGGER.info("Failure retransmitting queued requests", t);
            }
        }
    }
}

