/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log.direct;

public class LogEvent {
    private final String level;
    private final String message;
    private final Throwable exception;
    private final long timestamp;
    private final String className;
    private final String methodName;
    private final int lineNumber;

    public String getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getException() {
        return this.exception;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    private LogEvent(Builder builder) {
        this.level = builder.level;
        this.message = builder.message;
        this.exception = builder.exception;
        this.timestamp = System.currentTimeMillis();
        this.className = builder.className;
        this.methodName = builder.methodName;
        this.lineNumber = builder.lineNumber;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "LogEvent [level=" + this.level + ", message=" + this.message + ", exception=" + this.exception + ", timestamp=" + this.timestamp + ", className=" + this.className + ", methodName=" + this.methodName + ", lineNumber=" + this.lineNumber + "]";
    }

    public static class Builder {
        private String level;
        private String message;
        private Throwable exception;
        private String className;
        private String methodName;
        private int lineNumber;

        public Builder level(String level) {
            this.level = level;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder exception(Throwable exception) {
            this.exception = exception;
            return this;
        }

        public Builder className(String className) {
            this.className = className;
            return this;
        }

        public Builder methodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public Builder lineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public LogEvent build() {
            return new LogEvent(this);
        }
    }
}

