/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.http;

import com.stackify.api.common.ApiConfiguration;
import com.stackify.api.common.http.HttpException;
import com.stackify.api.common.http.HttpProxy;
import com.stackify.api.common.util.CharStreams;
import com.stackify.api.common.util.Preconditions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPOutputStream;

public class HttpClient {
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 15000;
    private final ApiConfiguration apiConfig;
    private final Proxy proxy;

    public HttpClient(ApiConfiguration apiConfig) {
        Preconditions.checkNotNull(apiConfig);
        this.apiConfig = apiConfig;
        this.proxy = HttpProxy.fromSystemProperties();
    }

    public String post(String path, byte[] jsonBytes) throws IOException, HttpException {
        return this.post(path, jsonBytes, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post(String path, byte[] jsonBytes, boolean gzip) throws IOException, HttpException {
        Preconditions.checkNotNull(path);
        Preconditions.checkArgument(!path.isEmpty());
        Preconditions.checkNotNull(jsonBytes);
        Preconditions.checkArgument(0 < jsonBytes.length);
        URLConnection connection = null;
        try {
            URL url = new URL(this.apiConfig.getApiUrl() + path);
            connection = (HttpURLConnection)url.openConnection(this.proxy);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/json");
            if (gzip) {
                connection.setRequestProperty("Content-Encoding", "gzip");
            }
            connection.setRequestProperty("X-Stackify-Key", this.apiConfig.getApiKey());
            connection.setRequestProperty("X-Stackify-PV", "V1");
            ((HttpURLConnection)connection).setRequestMethod("POST");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(15000);
            BufferedOutputStream stream = null;
            stream = gzip ? new BufferedOutputStream(new GZIPOutputStream(connection.getOutputStream())) : new BufferedOutputStream(connection.getOutputStream());
            ((OutputStream)stream).write(jsonBytes);
            ((OutputStream)stream).flush();
            ((OutputStream)stream).close();
            int statusCode = ((HttpURLConnection)connection).getResponseCode();
            if (statusCode != 200) {
                throw new HttpException(statusCode);
            }
            String string = this.readAndClose(connection.getInputStream());
            return string;
        }
        finally {
            if (connection != null) {
                try {
                    this.readAndClose(connection.getInputStream());
                }
                catch (Throwable throwable) {}
                try {
                    this.readAndClose(((HttpURLConnection)connection).getErrorStream());
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private String readAndClose(InputStream stream) throws IOException {
        String contents = null;
        if (stream != null) {
            contents = CharStreams.toString(new InputStreamReader((InputStream)new BufferedInputStream(stream), "UTF-8"));
            stream.close();
        }
        return contents;
    }
}

