/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.mask;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Masker {
    private static final Logger log = LoggerFactory.getLogger(Masker.class);
    public static final String MASK_CREDITCARD = "CREDITCARD";
    public static final String MASK_SSN = "SSN";
    public static final String MASK_IP = "IP";
    public static final String MASK_UUID = "UUID";
    public static final String MASK_NUMERIC = "NUMERIC";
    public static final String MASK_EMAIL = "EMAIL";
    public static final String[] MASKS = new String[]{"CREDITCARD", "SSN", "IP", "UUID", "NUMERIC", "EMAIL"};
    protected static final String MASK_CC_VISA_REGEX = "4[0-9]{12}(?:[0-9]{3})";
    protected static final String MASK_CC_DISCOVER_REGEX = "6(?:011|5[0-9]{2})[0-9]{12}";
    protected static final String MASK_CC_MASTERCARD_REGEX = "5[1-5][0-9]{14}";
    protected static final String MASK_CC_AMEX_REGEX = "3[47][0-9]{13}";
    protected static final String MASK_CC_DINERS_REGEX = "3(?:0[0-5]|[68][0-9])?[0-9]{11}";
    protected static final String MASK_SSN_REGEX = "[0-9]{3}-[0-9]{2}-[0-9]{4}";
    protected static final String MASK_IPV4_REGEX = "(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
    protected static final String MASK_NUMERIC_REGEX = "(\\d+)";
    protected static final String MASK_UUID_REGEX = "(?i)(\\b[A-F0-9]{8}(?:-[A-F0-9]{4}){3}-[A-F0-9]{12}\\b)";
    protected static final String MASK_EMAIL_REGEX = "((([!#$%&'*+\\-/=?^_`{|}~\\w])|([!#$%&'*+\\-/=?^_`{|}~\\w][!#$%&'*+\\-/=?^_`{|}~\\.\\w]{0,}[!#$%&'*+\\-/=?^_`{|}~\\w]))[@]\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*)";
    private static final String DEFAULT_MASK_VALUE = "*";
    private final Map<String, Pattern> maskPatterns = new ConcurrentHashMap<String, Pattern>();
    private final Object lock = new Object();

    public void clearMasks() {
        this.maskPatterns.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMask(@NonNull String mask) {
        if (mask == null) {
            throw new NullPointerException("mask");
        }
        Object object = this.lock;
        synchronized (object) {
            if (mask.equals(MASK_CREDITCARD)) {
                this.removeMaskPattern(MASK_CC_VISA_REGEX);
                this.removeMaskPattern(MASK_CC_DISCOVER_REGEX);
                this.removeMaskPattern(MASK_CC_MASTERCARD_REGEX);
                this.removeMaskPattern(MASK_CC_AMEX_REGEX);
                this.removeMaskPattern(MASK_CC_DINERS_REGEX);
                return;
            }
            if (mask.equals(MASK_SSN)) {
                this.removeMaskPattern(MASK_SSN_REGEX);
                return;
            }
            if (mask.equals(MASK_IP)) {
                this.removeMaskPattern(MASK_IPV4_REGEX);
                return;
            }
            if (mask.equals(MASK_UUID)) {
                this.removeMaskPattern(MASK_UUID_REGEX);
                return;
            }
            if (mask.equals(MASK_NUMERIC)) {
                this.removeMaskPattern(MASK_NUMERIC_REGEX);
                return;
            }
            if (mask.equals(MASK_EMAIL)) {
                this.removeMaskPattern(MASK_EMAIL_REGEX);
                return;
            }
            this.removeMaskPattern(mask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMask(@NonNull String mask) {
        if (mask == null) {
            throw new NullPointerException("mask");
        }
        Object object = this.lock;
        synchronized (object) {
            if (mask.equals(MASK_CREDITCARD)) {
                this.addMaskPattern(MASK_CC_VISA_REGEX);
                this.addMaskPattern(MASK_CC_DISCOVER_REGEX);
                this.addMaskPattern(MASK_CC_MASTERCARD_REGEX);
                this.addMaskPattern(MASK_CC_AMEX_REGEX);
                this.addMaskPattern(MASK_CC_DINERS_REGEX);
                return;
            }
            if (mask.equals(MASK_SSN)) {
                this.addMaskPattern(MASK_SSN_REGEX);
                return;
            }
            if (mask.equals(MASK_IP)) {
                this.addMaskPattern(MASK_IPV4_REGEX);
                return;
            }
            if (mask.equals(MASK_UUID)) {
                this.addMaskPattern(MASK_UUID_REGEX);
                return;
            }
            if (mask.equals(MASK_NUMERIC)) {
                this.addMaskPattern(MASK_NUMERIC_REGEX);
                return;
            }
            if (mask.equals(MASK_EMAIL)) {
                this.addMaskPattern(MASK_EMAIL_REGEX);
                return;
            }
            this.addMaskPattern(mask);
        }
    }

    private synchronized void addMaskPattern(String regex) {
        if (regex != null) {
            try {
                this.maskPatterns.put(regex, Pattern.compile(regex));
            }
            catch (PatternSyntaxException e) {
                log.error(String.format("Error Adding Mask: %s: '%s'", e.getMessage(), regex));
            }
        }
    }

    private synchronized void removeMaskPattern(String regex) {
        if (regex != null) {
            try {
                this.maskPatterns.remove(regex);
            }
            catch (PatternSyntaxException e) {
                log.error(String.format("%s: '%s'", e.getMessage(), regex));
            }
        }
    }

    public String mask(String value) {
        return this.mask(value, DEFAULT_MASK_VALUE);
    }

    public String mask(String value, String replacementValue) {
        try {
            if (this.hasMasks()) {
                if (value == null) {
                    return null;
                }
                String maskedValue = value;
                for (Map.Entry<String, Pattern> entry : this.maskPatterns.entrySet()) {
                    Matcher matcher = entry.getValue().matcher(maskedValue);
                    while (matcher.find()) {
                        String matchReplace;
                        String match = matcher.group();
                        if (replacementValue.length() == 1) {
                            char[] symbols = new char[match.length()];
                            Arrays.fill(symbols, replacementValue.toCharArray()[0]);
                            matchReplace = new String(symbols);
                        } else {
                            matchReplace = replacementValue;
                        }
                        maskedValue = maskedValue.replace(match, matchReplace);
                    }
                }
                return maskedValue;
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
        return value;
    }

    public boolean hasMasks() {
        return this.maskPatterns.size() > 0;
    }

    public Map<String, Pattern> getMaskPatterns() {
        return this.maskPatterns;
    }
}

