/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stackify.api.ErrorItem;
import com.stackify.api.LogMsg;
import com.stackify.api.LogMsgGroup;
import com.stackify.api.common.ApiConfiguration;
import com.stackify.api.common.http.HttpClient;
import com.stackify.api.common.http.HttpException;
import com.stackify.api.common.http.HttpResendQueue;
import com.stackify.api.common.mask.Masker;
import com.stackify.api.common.util.Preconditions;
import com.stackify.api.common.util.SkipJsonUtil;
import java.io.IOException;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogSender.class);
    private static final String LOG_SAVE_PATH = "/Log/Save";
    private final ApiConfiguration apiConfig;
    private final ObjectMapper objectMapper;
    private final HttpResendQueue resendQueue = new HttpResendQueue(20);
    private final Masker masker;
    private final boolean skipJson;

    public LogSender(@NonNull ApiConfiguration apiConfig, @NonNull ObjectMapper objectMapper, Masker masker, boolean skipJson) {
        if (apiConfig == null) {
            throw new NullPointerException("apiConfig");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper");
        }
        this.apiConfig = apiConfig;
        this.objectMapper = objectMapper;
        this.masker = masker;
        this.skipJson = skipJson;
    }

    public LogSender(@NonNull ApiConfiguration apiConfig, @NonNull ObjectMapper objectMapper, Masker masker) {
        this(apiConfig, objectMapper, masker, false);
        if (apiConfig == null) {
            throw new NullPointerException("apiConfig");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper");
        }
    }

    private void executeSkipJsonTag(LogMsgGroup group) {
        if (this.skipJson && group.getMsgs().size() > 0) {
            for (LogMsg logMsg : group.getMsgs()) {
                if (logMsg.getEx() != null) {
                    this.executeSkipJsonTag(logMsg.getEx().getError());
                }
                logMsg.setData(SkipJsonUtil.execute(logMsg.getData()));
                logMsg.setMsg(SkipJsonUtil.execute(logMsg.getMsg()));
            }
        }
    }

    private void executeSkipJsonTag(ErrorItem errorItem) {
        if (this.skipJson && errorItem != null) {
            errorItem.setMessage(SkipJsonUtil.execute(errorItem.getMessage()));
            if (errorItem.getData() != null) {
                for (Map.Entry<String, String> entry : errorItem.getData().entrySet()) {
                    entry.setValue(SkipJsonUtil.execute(entry.getValue()));
                }
            }
            this.executeSkipJsonTag(errorItem.getInnerError());
        }
    }

    private void executeMask(LogMsgGroup group) {
        if (this.masker != null && group.getMsgs().size() > 0) {
            for (LogMsg logMsg : group.getMsgs()) {
                if (logMsg.getEx() != null) {
                    this.executeMask(logMsg.getEx().getError());
                }
                logMsg.setData(this.masker.mask(logMsg.getData()));
                logMsg.setMsg(this.masker.mask(logMsg.getMsg()));
            }
        }
    }

    private void executeMask(ErrorItem errorItem) {
        if (errorItem != null) {
            errorItem.setMessage(this.masker.mask(errorItem.getMessage()));
            if (errorItem.getData() != null) {
                for (Map.Entry<String, String> entry : errorItem.getData().entrySet()) {
                    entry.setValue(this.masker.mask(entry.getValue()));
                }
            }
            this.executeMask(errorItem.getInnerError());
        }
    }

    public int send(LogMsgGroup group) throws IOException {
        Preconditions.checkNotNull(group);
        this.executeMask(group);
        this.executeSkipJsonTag(group);
        HttpClient httpClient = new HttpClient(this.apiConfig);
        this.resendQueue.drain(httpClient, LOG_SAVE_PATH, true);
        byte[] jsonBytes = this.objectMapper.writer().writeValueAsBytes((Object)group);
        int statusCode = 500;
        try {
            httpClient.post(LOG_SAVE_PATH, jsonBytes, true);
            statusCode = 200;
        }
        catch (IOException t) {
            LOGGER.info("Queueing logs for retransmission due to IOException");
            this.resendQueue.offer(jsonBytes, t);
            throw t;
        }
        catch (HttpException e) {
            statusCode = e.getStatusCode();
            LOGGER.info("Queueing logs for retransmission due to HttpException", (Throwable)e);
            this.resendQueue.offer(jsonBytes, e);
        }
        return statusCode;
    }
}

