/*
 * Copyright 2014 Stackify
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.stackify.api.common.util;

/**
 * Preconditions
 * @author Eric Martin
 */
public class Preconditions {

	/**
	 * Throws NullPointerException if the argument is null
	 * @param o The object to check
	 * @throws NullPointerException
	 */
	public static void checkNotNull(final Object o) {
		if (o == null) {
			throw new NullPointerException();
		}
	}
	
	/**
	 * Throws IllegalArgumentException if the expression is false
	 * @param expression The expression
	 * @throws IllegalArgumentException
	 */
	public static void checkArgument(final boolean expression) {
		if (!expression) {
			throw new IllegalArgumentException();
		}
	}
	
	/**
	 * Hidden to prevent construction
	 */
	private Preconditions() {
	}
}
