/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api;

import com.stackify.api.ApiClient;
import com.stackify.api.EnvironmentDetail;
import com.stackify.api.ErrorItem;
import com.stackify.api.WebRequestDetail;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class StackifyError {
    private final ApiClient apiClient;
    private final EnvironmentDetail environmentDetail;
    private final Date occurredEpochMillis;
    private final ErrorItem error;
    private final WebRequestDetail webRequestDetail;
    private final List<String> tags;
    private final Map<String, String> serverVariables;
    private final Map<String, String> customProperties;
    private final String customerName;
    private final String userName;

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public EnvironmentDetail getEnvironmentDetail() {
        return this.environmentDetail;
    }

    public Date getOccurredEpochMillis() {
        return this.occurredEpochMillis;
    }

    public ErrorItem getError() {
        return this.error;
    }

    public WebRequestDetail getWebRequestDetail() {
        return this.webRequestDetail;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Map<String, String> getServerVariables() {
        return this.serverVariables;
    }

    public Map<String, String> getCustomProperties() {
        return this.customProperties;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public String getUserName() {
        return this.userName;
    }

    private StackifyError(Builder builder) {
        this.apiClient = builder.apiClient;
        this.environmentDetail = builder.environmentDetail;
        this.occurredEpochMillis = builder.occurredEpochMillis;
        this.error = builder.error;
        this.webRequestDetail = builder.webRequestDetail;
        this.tags = builder.tags;
        this.serverVariables = builder.serverVariables;
        this.customProperties = builder.customProperties;
        this.customerName = builder.customerName;
        this.userName = builder.userName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private ApiClient apiClient;
        private EnvironmentDetail environmentDetail;
        private Date occurredEpochMillis;
        private ErrorItem error;
        private WebRequestDetail webRequestDetail;
        private List<String> tags;
        private Map<String, String> serverVariables;
        private Map<String, String> customProperties;
        private String customerName;
        private String userName;

        public Builder apiClient(ApiClient apiClient) {
            this.apiClient = apiClient;
            return this;
        }

        public Builder environmentDetail(EnvironmentDetail environmentDetail) {
            this.environmentDetail = environmentDetail;
            return this;
        }

        public Builder occurredEpochMillis(Date occurredEpochMillis) {
            this.occurredEpochMillis = occurredEpochMillis;
            return this;
        }

        public Builder error(ErrorItem error) {
            this.error = error;
            return this;
        }

        public Builder webRequestDetail(WebRequestDetail webRequestDetail) {
            this.webRequestDetail = webRequestDetail;
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder serverVariables(Map<String, String> serverVariables) {
            this.serverVariables = serverVariables;
            return this;
        }

        public Builder customProperties(Map<String, String> customProperties) {
            this.customProperties = customProperties;
            return this;
        }

        public Builder customerName(String customerName) {
            this.customerName = customerName;
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public StackifyError build() {
            return new StackifyError(this);
        }
    }
}

