/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.error.log4j12;

import com.stackify.api.ApiClient;
import com.stackify.api.EnvironmentDetail;
import com.stackify.api.StackifyError;
import com.stackify.api.common.ApiClients;
import com.stackify.api.common.EnvironmentDetails;
import com.stackify.api.common.error.ErrorGovernor;
import com.stackify.api.common.http.StackifyErrorSender;
import com.stackify.api.common.lang.Throwables;
import com.stackify.api.json.StackifyErrorConverter;
import com.stackify.error.log4j12.NonReentrantAppender;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class StackifyErrorAppender
extends NonReentrantAppender {
    private static final Logger LOGGER = Logger.getLogger(StackifyErrorAppender.class);
    private ErrorGovernor errorGovernor = new ErrorGovernor();
    private StackifyErrorSender errorSender;
    private ApiClient apiClient = null;
    private EnvironmentDetail environmentDetail = null;
    private String apiUrl = "https://api.stackify.com/Error/V1";
    private String apiKey = null;
    private String application = null;
    private String environment = null;
    private String converter = "com.stackify.api.json.jackson.StackifyErrorJacksonConverter";

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getConverter() {
        return this.converter;
    }

    public void setConverter(String converter) {
        this.converter = converter;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public EnvironmentDetail getEnvironmentDetail() {
        return this.environmentDetail;
    }

    public StackifyErrorSender getErrorSender() {
        return this.errorSender;
    }

    public void activateOptions() {
        super.activateOptions();
        if (this.apiKey == null || this.apiKey.isEmpty()) {
            LOGGER.error((Object)"API Key not set for the Stackify Error Appender");
            return;
        }
        this.apiClient = ApiClients.getApiClient(StackifyErrorAppender.class, (String)"/stackify-error-log4j12.properties");
        this.environmentDetail = EnvironmentDetails.getEnvironmentDetail((String)this.application, (String)this.environment);
        try {
            Class<?> converterClass = Class.forName(this.converter);
            StackifyErrorConverter converterInstance = (StackifyErrorConverter)converterClass.newInstance();
            this.errorSender = new StackifyErrorSender(converterInstance);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void subAppend(LoggingEvent event) {
        block8: {
            if (this.apiKey == null || this.apiKey.isEmpty()) {
                return;
            }
            Throwable exception = this.getThrowable(event);
            if (exception == null) {
                if (event.getLevel() == Level.ERROR || event.getLevel() == Level.FATAL) {
                    exception = new Throwable();
                } else {
                    return;
                }
            }
            try {
                int rc;
                StackifyError error;
                ArrayList<String> tags = new ArrayList<String>();
                tags.add("log4j12");
                tags.add(event.getLevel().toString().toLowerCase());
                tags.add(event.getLoggerName());
                StackifyError.Builder errorBuilder = StackifyError.newBuilder();
                errorBuilder.apiClient(this.apiClient);
                errorBuilder.environmentDetail(this.environmentDetail);
                errorBuilder.occurredEpochMillis(new Date(event.getTimeStamp()));
                errorBuilder.error(Throwables.toErrorItem((String)this.getLogMessage(event), (Throwable)exception));
                errorBuilder.tags(tags);
                Map<String, String> customProperties = this.getCustomProperties(event);
                if (!customProperties.isEmpty()) {
                    errorBuilder.customProperties(customProperties);
                }
                if (this.errorGovernor.errorShouldBeSent(error = errorBuilder.build()) && (rc = this.errorSender.send(this.apiUrl, this.apiKey, Collections.singletonList(error))) != 200 && LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("Stackify Error Service returned HTTP " + Integer.toString(rc)));
                }
            }
            catch (Throwable t) {
                if (!LOGGER.isInfoEnabled()) break block8;
                LOGGER.info((Object)"Exception posting to Stackify Error Service", t);
            }
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    private Throwable getThrowable(LoggingEvent event) {
        Throwable t;
        ThrowableInformation throwableInfo = event.getThrowableInformation();
        if (throwableInfo != null && (t = throwableInfo.getThrowable()) != null) {
            return t;
        }
        Object message = event.getMessage();
        if (message != null && message instanceof Throwable) {
            return (Throwable)message;
        }
        return null;
    }

    private Map<String, String> getCustomProperties(LoggingEvent event) {
        String ndc;
        HashMap<String, String> customProperties = new HashMap<String, String>();
        Map mdc = event.getProperties();
        if (mdc != null) {
            for (Map.Entry entryPair : mdc.entrySet()) {
                Object key = entryPair.getKey();
                Object value = entryPair.getValue();
                customProperties.put(key.toString(), value != null ? value.toString() : null);
            }
        }
        if ((ndc = event.getNDC()) != null && !ndc.isEmpty()) {
            customProperties.put("NDC", ndc);
        }
        return customProperties;
    }

    private String getLogMessage(LoggingEvent event) {
        Object message = event.getMessage();
        if (message != null && message instanceof String) {
            return (String)message;
        }
        return null;
    }
}

