/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.core.rest;

import com.stackmob.core.MethodVerb;
import java.util.Map;

public class ProcessedAPIRequest {
    private final MethodVerb verb;
    private final String url;
    private final String loggedInUser;
    private final Map<String, String> params;
    private final Map<String, String> headers;
    private final String appName;
    private final int apiVersion;
    private final String methodName;
    private final long counter;
    private final String body;

    public ProcessedAPIRequest(MethodVerb verb, String url, String loggedInUser, Map<String, String> params, Map<String, String> headers, String body, String appName, int apiVersion, String methodName, long counter) {
        this.verb = verb;
        this.url = url;
        this.appName = appName;
        this.apiVersion = apiVersion;
        this.methodName = methodName;
        this.loggedInUser = loggedInUser != null && loggedInUser.isEmpty() ? null : loggedInUser;
        this.params = params;
        this.headers = headers;
        this.counter = counter;
        this.body = body;
    }

    public ProcessedAPIRequest(MethodVerb verb, String url, String loggedInUser, Map<String, String> params, Map<String, String> headers, String appName, int apiVersion, String methodName, long counter) {
        this(verb, url, loggedInUser, params, headers, "", appName, apiVersion, methodName, counter);
    }

    public ProcessedAPIRequest(MethodVerb verb, String url, String loggedInUser, Map<String, String> params, String body, String appName, int apiVersion, String methodName, long counter) {
        this(verb, url, loggedInUser, params, null, body, appName, apiVersion, methodName, counter);
    }

    public ProcessedAPIRequest(MethodVerb verb, String url, String loggedInUser, Map<String, String> params, String appName, int apiVersion, String methodName, long counter) {
        this(verb, url, loggedInUser, params, null, "", appName, apiVersion, methodName, counter);
    }

    public MethodVerb getVerb() {
        return this.verb;
    }

    public String getUrl() {
        return this.url;
    }

    public String getLoggedInUser() {
        return this.loggedInUser;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getContentType() {
        return this.headers == null ? null : this.headers.get("content-type");
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String toString() {
        return "Request: " + this.getUrl();
    }

    @Deprecated
    public String getAppUrlSafeName() {
        return this.appName;
    }

    public String getAppName() {
        return this.appName;
    }

    public int getApiVersion() {
        return this.apiVersion;
    }

    public long getCounter() {
        return this.counter;
    }

    public String getBody() {
        return this.body;
    }
}

