/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdkapi.caching;

import com.stackmob.sdkapi.caching.exceptions.DataSizeException;
import com.stackmob.sdkapi.caching.exceptions.RateLimitedException;
import com.stackmob.sdkapi.caching.exceptions.TTLTooBigException;
import com.stackmob.sdkapi.caching.exceptions.TimeoutException;
import java.nio.charset.Charset;

public abstract class CachingService {
    public static final Charset utf8Charset = Charset.forName("UTF-8");

    public String getString(String key, Charset charset) throws TimeoutException, RateLimitedException, DataSizeException {
        byte[] rawBytes = this.getBytes(key);
        if (rawBytes != null) {
            return new String(rawBytes, charset);
        }
        return null;
    }

    public String getString(String key) throws TimeoutException, RateLimitedException, DataSizeException {
        return this.getString(key, utf8Charset);
    }

    public abstract byte[] getBytes(String var1) throws TimeoutException, RateLimitedException, DataSizeException;

    public Boolean setString(String key, String value, Charset charset, long ttlMilliseconds) throws TimeoutException, RateLimitedException, DataSizeException, TTLTooBigException {
        return this.setBytes(key, value.getBytes(charset), ttlMilliseconds);
    }

    public Boolean setString(String key, String value, long ttlMilliseconds) throws TimeoutException, RateLimitedException, DataSizeException, TTLTooBigException {
        return this.setString(key, value, utf8Charset, ttlMilliseconds);
    }

    public abstract Boolean setBytes(String var1, byte[] var2, long var3) throws TimeoutException, RateLimitedException, DataSizeException, TTLTooBigException;

    public abstract void deleteEventually(String var1) throws DataSizeException;
}

