/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.net;

import com.stackmob.sdk.callback.StackMobRedirectedCallback;
import java.util.Arrays;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.protocol.HttpContext;

public class HttpRedirectStrategy
extends DefaultRedirectStrategy {
    public static final int RedirectStatusCode = 302;
    private final StackMobRedirectedCallback redirectedCallback;

    public HttpRedirectStrategy(StackMobRedirectedCallback redirectedCallback) {
        this.redirectedCallback = redirectedCallback;
    }

    public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        HttpUriRequest redir = super.getRedirect(request, response, context);
        if (this.isRedirected(request, response, context)) {
            List<Header> newLocHeaders = Arrays.asList(redir.getHeaders("Location"));
            if (newLocHeaders.size() < 1) {
                throw new ProtocolException("302 given for redirect, but no location given");
            }
            this.redirectedCallback.redirected(request, response, (HttpRequest)redir);
        }
        return redir;
    }

    public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) {
        return response.getStatusLine().getStatusCode() == 302;
    }
}

