/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.api;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.stackmob.sdk.api.StackMobOptions;
import com.stackmob.sdk.api.StackMobQuery;
import com.stackmob.sdk.api.StackMobSession;
import com.stackmob.sdk.callback.StackMobRawCallback;
import com.stackmob.sdk.callback.StackMobRedirectedCallback;
import com.stackmob.sdk.exception.StackMobException;
import com.stackmob.sdk.net.HttpVerb;
import com.stackmob.sdk.net.HttpVerbWithPayload;
import com.stackmob.sdk.net.HttpVerbWithoutPayload;
import com.stackmob.sdk.request.StackMobRequest;
import com.stackmob.sdk.request.StackMobRequestWithPayload;
import com.stackmob.sdk.request.StackMobRequestWithoutPayload;
import com.stackmob.sdk.util.Http;
import com.stackmob.sdk.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class StackMobDatastore {
    private ExecutorService executor;
    private StackMobSession session;
    private String host;
    private StackMobRedirectedCallback redirectedCallback;

    public StackMobDatastore(ExecutorService executor, StackMobSession session, String host, StackMobRedirectedCallback redirectedCallback) {
        this.executor = executor;
        this.session = session;
        this.host = host;
        this.redirectedCallback = redirectedCallback;
    }

    public void setSession(StackMobSession session) {
        this.session = session;
    }

    public void get(String path, StackMobRawCallback callback) {
        new StackMobRequestWithoutPayload(this.executor, this.session, HttpVerbWithoutPayload.GET, StackMobOptions.none(), StackMobRequest.EmptyParams, path, callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }

    public void get(String path, StackMobOptions options, StackMobRawCallback callback) {
        this.get(path, StackMobRequest.EmptyParams, options, callback);
    }

    private void get(String path, List<Map.Entry<String, String>> arguments, List<Map.Entry<String, String>> headers, StackMobRawCallback callback) {
        new StackMobRequestWithoutPayload(this.executor, this.session, HttpVerbWithoutPayload.GET, StackMobOptions.headers(headers), arguments, path, callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }

    private void get(String path, List<Map.Entry<String, String>> arguments, StackMobOptions options, StackMobRawCallback callback) {
        new StackMobRequestWithoutPayload(this.executor, this.session, HttpVerbWithoutPayload.GET, options, arguments, path, callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }

    public void get(StackMobQuery query, StackMobRawCallback callback) {
        StackMobOptions options = StackMobOptions.headers(query.getHeaders());
        this.get("/" + query.getObjectName(), query.getArguments(), options.getHeaders(), callback);
    }

    public void get(StackMobQuery query, StackMobOptions options, StackMobRawCallback callback) {
        this.get("/" + query.getObjectName(), query.getArguments(), options.withHeaders(query.getHeaders()).getHeaders(), callback);
    }

    public void head(String path, StackMobRawCallback callback) {
        new StackMobRequestWithoutPayload(this.executor, this.session, HttpVerbWithoutPayload.HEAD, StackMobOptions.none(), StackMobRequest.EmptyParams, path, callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }

    public void head(String path, StackMobOptions options, StackMobRawCallback callback) {
        this.head(path, StackMobRequest.EmptyParams, options, callback);
    }

    private void head(String path, List<Map.Entry<String, String>> arguments, List<Map.Entry<String, String>> headers, StackMobRawCallback callback) {
        new StackMobRequestWithoutPayload(this.executor, this.session, HttpVerbWithoutPayload.HEAD, StackMobOptions.headers(headers), arguments, path, callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }

    private void head(String path, List<Map.Entry<String, String>> arguments, StackMobOptions options, StackMobRawCallback callback) {
        new StackMobRequestWithoutPayload(this.executor, this.session, HttpVerbWithoutPayload.HEAD, options, arguments, path, callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }

    public void head(StackMobQuery query, StackMobRawCallback callback) {
        StackMobOptions options = StackMobOptions.headers(query.getHeaders());
        this.head("/" + query.getObjectName(), query.getArguments(), options.getHeaders(), callback);
    }

    public void head(StackMobQuery query, StackMobOptions options, StackMobRawCallback callback) {
        this.head("/" + query.getObjectName(), query.getArguments(), options.withHeaders(query.getHeaders()).getHeaders(), callback);
    }

    public void post(String path, Object requestObject, StackMobRawCallback callback) {
        new StackMobRequestWithPayload(this.executor, this.session, HttpVerbWithPayload.POST, StackMobOptions.none(), StackMobRequest.EmptyParams, requestObject, path, callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }

    public void post(String path, Object requestObject, StackMobOptions options, StackMobRawCallback callback) {
        new StackMobRequestWithPayload(this.executor, this.session, HttpVerbWithPayload.POST, options, StackMobRequest.EmptyParams, requestObject, path, callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }

    public void post(String path, String body, StackMobRawCallback callback) {
        new StackMobRequestWithPayload(this.executor, this.session, HttpVerbWithPayload.POST, StackMobOptions.none(), StackMobRequest.EmptyParams, body, path, callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }

    public void post(String path, String body, StackMobOptions options, StackMobRawCallback callback) {
        new StackMobRequestWithPayload(this.executor, this.session, HttpVerbWithPayload.POST, options, StackMobRequest.EmptyParams, body, path, callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }

    public <T> void postBulk(String path, List<T> requestObjects, StackMobRawCallback callback) {
        new StackMobRequestWithPayload(this.executor, this.session, HttpVerbWithPayload.POST, StackMobOptions.none(), StackMobRequest.EmptyParams, requestObjects, path, callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }

    public void postRelated(String path, String primaryId, String relatedField, Object relatedObject, StackMobRawCallback callback) {
        new StackMobRequestWithPayload(this.executor, this.session, HttpVerbWithPayload.POST, StackMobOptions.none(), StackMobRequest.EmptyParams, relatedObject, String.format("%s/%s/%s", path, primaryId, relatedField), callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }

    public void postRelated(String path, String primaryId, String relatedField, String relatedObject, StackMobRawCallback callback) {
        new StackMobRequestWithPayload(this.executor, this.session, HttpVerbWithPayload.POST, StackMobOptions.none(), StackMobRequest.EmptyParams, relatedObject, String.format("%s/%s/%s", path, primaryId, relatedField), callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }

    public <T> void postRelatedBulk(String path, String primaryId, String relatedField, List<T> relatedObjects, StackMobRawCallback callback) {
        this.postRelated(path, primaryId, relatedField, relatedObjects, callback);
    }

    public void put(String path, String id, Object requestObject, StackMobRawCallback callback) {
        new StackMobRequestWithPayload(this.executor, this.session, HttpVerbWithPayload.PUT, StackMobOptions.none(), StackMobRequest.EmptyParams, requestObject, path + "/" + id, callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }

    public void put(String path, String id, String body, StackMobRawCallback callback) {
        new StackMobRequestWithPayload(this.executor, this.session, HttpVerbWithPayload.PUT, StackMobOptions.none(), StackMobRequest.EmptyParams, body, path + "/" + id, callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }

    public void putAndUpdateAtomicCounters(String path, String id, Object requestObject, List<String> counterFields, StackMobRawCallback callback) {
        JsonObject obj = new Gson().toJsonTree(requestObject).getAsJsonObject();
        for (Map.Entry field : new HashSet(obj.entrySet())) {
            if (!counterFields.contains(field.getKey())) continue;
            obj.remove((String)field.getKey());
            obj.add((String)field.getKey() + "[inc]", (JsonElement)field.getValue());
        }
        this.put(path, id, obj.toString(), callback);
    }

    public void updateAtomicCounter(String path, String id, String field, int value, StackMobRawCallback callback) {
        JsonObject body = new JsonObject();
        body.add(field + "[inc]", (JsonElement)new JsonPrimitive((Number)value));
        this.put(path, id, body.toString(), callback);
    }

    public <T> void putRelated(String path, String primaryId, String relatedField, List<T> relatedIds, StackMobRawCallback callback) {
        new StackMobRequestWithPayload(this.executor, this.session, HttpVerbWithPayload.PUT, StackMobOptions.none(), StackMobRequest.EmptyParams, relatedIds, String.format("%s/%s/%s", path, primaryId, relatedField), callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }

    public void delete(String path, StackMobRawCallback callback) {
        new StackMobRequestWithoutPayload(this.executor, this.session, HttpVerbWithoutPayload.DELETE, StackMobOptions.none(), StackMobRequest.EmptyParams, path, callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }

    public void delete(String path, String id, StackMobRawCallback callback) {
        this.delete(path + "/" + id, callback);
    }

    public <T> void deleteIdsFrom(String path, String primaryId, String field, List<T> idsToDelete, boolean cascadeDeletes, StackMobRawCallback callback) {
        StringBuilder ids = new StringBuilder();
        for (int i = 0; i < idsToDelete.size(); ++i) {
            ids.append(idsToDelete.get(i).toString());
            if (i >= idsToDelete.size() - 1) continue;
            ids.append(",");
        }
        ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
        if (cascadeDeletes) {
            headers.add(new Pair<String, String>("X-StackMob-CascadeDelete", "true"));
        }
        new StackMobRequestWithoutPayload(this.executor, this.session, HttpVerbWithoutPayload.DELETE, StackMobOptions.headers(headers), StackMobRequest.EmptyParams, String.format("%s/%s/%s/%s", path, primaryId, field, ids.toString()), callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }

    public <T> void deleteIdFrom(String path, String primaryId, String field, T idToDelete, boolean cascadeDelete, StackMobRawCallback callback) {
        ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
        if (cascadeDelete) {
            headers.add(new Pair<String, String>("X-StackMob-CascadeDelete", "true"));
        }
        new StackMobRequestWithoutPayload(this.executor, this.session, HttpVerbWithoutPayload.DELETE, StackMobOptions.headers(headers), StackMobRequest.EmptyParams, String.format("%s/%s/%s/%s", path, primaryId, field, idToDelete), callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }

    public void count(String path, StackMobRawCallback callback) {
        this.count(new StackMobQuery(path), callback);
    }

    public void count(StackMobQuery query, StackMobRawCallback callback) {
        final StackMobRawCallback userCallback = callback;
        this.get(query.isInRange(0, 0), new StackMobRawCallback(){

            @Override
            public void unsent(StackMobException e) {
                userCallback.unsent(e);
            }

            @Override
            public void temporaryPasswordResetRequired(StackMobException e) {
                userCallback.temporaryPasswordResetRequired(e);
            }

            @Override
            public void done(HttpVerb requestVerb, String requestURL, List<Map.Entry<String, String>> requestHeaders, String requestBody, Integer responseStatusCode, List<Map.Entry<String, String>> responseHeaders, byte[] responseBody) {
                if (Http.isSuccess(responseStatusCode)) {
                    long count = 1.getTotalNumberOfItemsFromContentRange(responseHeaders).intValue();
                    if (count < 0L) {
                        try {
                            count = new JsonParser().parse(new String(responseBody)).getAsJsonArray().size();
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                    }
                    responseBody = String.valueOf(count).getBytes();
                }
                userCallback.setDone(requestVerb, requestURL, requestHeaders, requestBody, responseStatusCode, responseHeaders, responseBody);
            }
        });
    }
}

