/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.stackmob.sdk.api.StackMob;
import com.stackmob.sdk.api.StackMobFile;
import com.stackmob.sdk.api.StackMobForgotPasswordEmail;
import com.stackmob.sdk.api.StackMobOptions;
import com.stackmob.sdk.api.StackMobQuery;
import com.stackmob.sdk.callback.StackMobCallback;
import com.stackmob.sdk.callback.StackMobCountCallback;
import com.stackmob.sdk.callback.StackMobExistsCallback;
import com.stackmob.sdk.callback.StackMobIntermediaryCallback;
import com.stackmob.sdk.callback.StackMobNoopCallback;
import com.stackmob.sdk.callback.StackMobQueryCallback;
import com.stackmob.sdk.callback.StackMobRawCallback;
import com.stackmob.sdk.exception.StackMobException;
import com.stackmob.sdk.model.StackMobCounter;
import com.stackmob.sdk.util.Pair;
import com.stackmob.sdk.util.SerializationMetadata;
import com.stackmob.sdk.util.TypeHints;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class StackMobModel {
    protected transient String id;
    private transient Class<? extends StackMobModel> actualClass;
    private transient String schemaName;
    private transient boolean hasData;
    private transient StackMob stackmob = StackMob.getStackMob();
    private static final Gson gson = StackMobModel.getGson();

    public static <T extends StackMobModel> void query(Class<T> theClass, StackMobQuery q, StackMobQueryCallback<T> callback) {
        StackMobModel.query(theClass, q, new StackMobOptions(), callback);
    }

    public static <T extends StackMobModel> void query(StackMob stackmob, Class<T> theClass, StackMobQuery q, StackMobQueryCallback<T> callback) {
        StackMobModel.query(stackmob, theClass, q, new StackMobOptions(), callback);
    }

    private static <T extends StackMobModel> String getSchemaName(Class<T> theClass) {
        try {
            Method getSchemaName = theClass.getDeclaredMethod("overrideSchemaName", new Class[0]);
            Object result = getSchemaName.invoke(null, new Object[0]);
            return (String)result;
        }
        catch (Exception e) {
            return theClass.getSimpleName().toLowerCase();
        }
    }

    public static <T extends StackMobModel> void query(Class<T> theClass, StackMobQuery q, StackMobOptions options, StackMobQueryCallback<T> callback) {
        StackMobModel.query(StackMob.getStackMob(), theClass, q, options, callback);
    }

    public static <T extends StackMobModel> void query(final StackMob stackmob, final Class<T> theClass, StackMobQuery q, StackMobOptions options, final StackMobQueryCallback<T> callback) {
        q.setObjectName(StackMobModel.getSchemaName(theClass));
        stackmob.getDatastore().get(q, options, (StackMobRawCallback)new StackMobCallback(){

            @Override
            public void success(String responseBody) {
                JsonArray array = new JsonParser().parse(responseBody).getAsJsonArray();
                ArrayList resultList = new ArrayList();
                for (JsonElement elt : array) {
                    try {
                        resultList.add(StackMobModel.newFromJson(stackmob, theClass, elt.toString()));
                    }
                    catch (StackMobException ignore) {}
                }
                callback.success(resultList);
            }

            @Override
            public void failure(StackMobException e) {
                callback.failure(e);
            }
        });
    }

    public static <T extends StackMobModel> void count(Class<T> theClass, StackMobQuery q, StackMobCountCallback callback) {
        StackMobModel.count(StackMob.getStackMob(), theClass, q, callback);
    }

    public static <T extends StackMobModel> void count(StackMob stackmob, Class<T> theClass, StackMobQuery q, StackMobCountCallback callback) {
        q.setObjectName(StackMobModel.getSchemaName(theClass));
        stackmob.getDatastore().count(q, (StackMobRawCallback)callback);
    }

    public static <T extends StackMobModel> T newFromJson(StackMob stackmob, Class<T> classOfT, String json) throws StackMobException {
        T newObject = StackMobModel.newInstance(classOfT);
        ((StackMobModel)newObject).stackmob = stackmob;
        ((StackMobModel)newObject).fillFromJson(json);
        return newObject;
    }

    private static <T extends StackMobModel> T newInstance(Class<T> classOfT) {
        StackMobModel newObject = (StackMobModel)new Gson().fromJson("{}", classOfT);
        newObject.init(classOfT);
        return (T)newObject;
    }

    public static <T extends StackMobModel> void saveMultiple(List<T> models, StackMobCallback callback) {
        StackMobModel.saveMultiple(StackMob.getStackMob(), models, callback);
    }

    public static <T extends StackMobModel> void saveMultiple(StackMob stackmob, List<T> models, StackMobCallback callback) {
        if (models.size() == 0) {
            throw new IllegalArgumentException("Empty list");
        }
        stackmob.getDatastore().post(((StackMobModel)models.get(0)).getSchemaName(), StackMobModel.toJsonArray(models), (StackMobRawCallback)callback);
    }

    private static <T extends StackMobModel> String toJsonArray(List<T> models) {
        JsonArray array = new JsonArray();
        for (StackMobModel model : models) {
            array.add(model.toJsonElement(0, new Selection(null), new TypeHints(), new TypeHints()));
        }
        return array.toString();
    }

    private static Gson getGson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new DateAsNumberTypeAdapter());
        gsonBuilder.registerTypeAdapter(StackMobForgotPasswordEmail.class, (Object)new StackMobForgotPasswordEmail.Deserializer());
        gsonBuilder.registerTypeAdapter(StackMobForgotPasswordEmail.class, (Object)new StackMobForgotPasswordEmail.Serializer());
        return gsonBuilder.create();
    }

    public void setStackMob(StackMob stackmob) {
        this.stackmob = stackmob;
    }

    public StackMobModel(String id, Class<? extends StackMobModel> actualClass) {
        this(actualClass);
        this.id = id;
    }

    public StackMobModel(Class<? extends StackMobModel> actualClass) {
        this.init(actualClass);
    }

    protected void init(Class<? extends StackMobModel> actualClass) {
        this.actualClass = actualClass;
        this.schemaName = StackMobModel.getSchemaName(actualClass);
        StackMobModel.ensureValidName(this.schemaName, "model");
        SerializationMetadata.ensureMetadata(actualClass);
    }

    private void ensureValidFieldName(String name) {
        if (name.equalsIgnoreCase(this.getIDFieldName())) {
            throw new IllegalStateException(String.format("Don't create a field called %s. It's your object's id and is treated specially. Use setID and getID instead.", this.getIDFieldName()));
        }
        StackMobModel.ensureValidName(name, "field");
    }

    private static void ensureValidName(String name, String thing) {
        if (name.length() > 25) {
            throw new IllegalStateException(String.format("Invalid name for a %s: %s. Must be less than 25 alphanumeric characters", thing, name));
        }
    }

    private SerializationMetadata getMetadata(String fieldName) {
        return SerializationMetadata.getSerializationMetadata(this.actualClass, fieldName);
    }

    private String getFieldName(String jsonName) {
        return SerializationMetadata.getFieldNameFromJsonName(this.actualClass, jsonName);
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    void setActualClass(Class<? extends StackMobModel> actualClass) {
        this.actualClass = actualClass;
    }

    protected String getSchemaName() {
        return this.schemaName;
    }

    public String getIDFieldName() {
        return this.schemaName + "_id";
    }

    public boolean hasData() {
        return this.hasData;
    }

    private void fillModel(Field field, JsonElement json) throws StackMobException, IllegalAccessException {
        StackMobModel relatedModel = (StackMobModel)field.get(this);
        if (relatedModel == null || !relatedModel.hasSameID(json)) {
            relatedModel = StackMobModel.newInstance(field.getType());
        }
        relatedModel.fillFromJson(json);
        field.set(this, relatedModel);
    }

    private void fillModelArray(Field field, JsonElement json) throws InstantiationException, IllegalAccessException, StackMobException {
        Class<?> actualModelClass = SerializationMetadata.getComponentClass(field);
        Collection<StackMobModel> existingModels = this.getFieldAsCollection(field);
        List<StackMobModel> newModels = StackMobModel.updateModelListFromJson(json.getAsJsonArray(), existingModels, actualModelClass);
        this.setFieldFromList(field, newModels, actualModelClass);
    }

    private void fillCounter(Field field, JsonElement json) throws IllegalAccessException {
        StackMobCounter counter = (StackMobCounter)field.get(this);
        int newValue = json.getAsJsonPrimitive().getAsInt();
        if (counter == null) {
            counter = new StackMobCounter();
            counter.set(newValue);
            field.set(this, counter);
        } else {
            counter.set(newValue);
        }
    }

    private void fillFieldFromJson(String jsonName, JsonElement json) throws StackMobException {
        try {
            if (jsonName.equals(this.getIDFieldName())) {
                this.setID(json.getAsJsonPrimitive().getAsString());
            } else {
                String fieldName = this.getFieldName(jsonName);
                if (fieldName != null) {
                    Field field = this.getField(fieldName);
                    if (this.getMetadata(fieldName) == SerializationMetadata.MODEL) {
                        this.fillModel(field, json);
                    } else if (this.getMetadata(fieldName) == SerializationMetadata.MODEL_ARRAY) {
                        this.fillModelArray(field, json);
                    } else if (this.getMetadata(fieldName) == SerializationMetadata.COUNTER) {
                        this.fillCounter(field, json);
                    } else if (this.getMetadata(fieldName) == SerializationMetadata.BINARY) {
                        StackMobFile file = (StackMobFile)field.get(this);
                        String url = json.getAsJsonPrimitive().getAsString();
                        if (file == null) {
                            StackMobFile newFile = new StackMobFile(url);
                            field.set(this, newFile);
                        } else {
                            file.setS3Url(url);
                        }
                    } else {
                        field.set(this, gson.fromJson(json, field.getType()));
                    }
                }
            }
        }
        catch (NoSuchFieldException e) {
            this.stackmob.getSession().getLogger().logDebug(String.format("Ignoring extraneous json field:\nfield: %s\ndata: %s", jsonName, json.toString()), new Object[0]);
        }
        catch (JsonSyntaxException e) {
            this.stackmob.getSession().getLogger().logWarning(String.format("Incoming data does not match data model:\nfield: %s\ndata: %s", jsonName, json.toString()), new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new StackMobException(e.getMessage());
        }
    }

    Collection<StackMobModel> getFieldAsCollection(Field field) throws IllegalAccessException {
        if (field.getType().isArray()) {
            StackMobModel[] models = (StackMobModel[])field.get(this);
            return models == null ? null : Arrays.asList(models);
        }
        return (Collection)field.get(this);
    }

    void setFieldFromList(Field field, List<? extends StackMobModel> list, Class<? extends StackMobModel> modelClass) throws IllegalAccessException, InstantiationException {
        if (field.getType().isArray()) {
            StackMobModel[] modelArray = (StackMobModel[])field.get(this);
            if (modelArray == null || modelArray.length != list.size()) {
                field.set(this, Array.newInstance(modelClass, list.size()));
                modelArray = (StackMobModel[])field.get(this);
            }
            for (int i = 0; i < list.size(); ++i) {
                modelArray[i] = list.get(i);
            }
        } else {
            Collection models = (Collection)field.get(this);
            if (models == null) {
                this.initWithNewCollection(field);
                models = (Collection)field.get(this);
            }
            try {
                models.clear();
            }
            catch (UnsupportedOperationException e) {
                this.initWithNewCollection(field);
            }
            models.addAll(list);
        }
    }

    private void initWithNewCollection(Field field) throws IllegalAccessException {
        field.set(this, gson.fromJson("[]", field.getType()));
    }

    static List<StackMobModel> updateModelListFromJson(JsonArray array, Collection<? extends StackMobModel> existingModels, Class<? extends StackMobModel> modelClass) throws IllegalAccessException, InstantiationException, StackMobException {
        ArrayList<StackMobModel> result = new ArrayList<StackMobModel>();
        for (JsonElement json : array) {
            StackMobModel model = StackMobModel.getExistingModel(existingModels, json);
            if (model == null) {
                model = StackMobModel.newInstance(modelClass);
            }
            model.fillFromJson(json);
            result.add(model);
        }
        return result;
    }

    static StackMobModel getExistingModel(Collection<? extends StackMobModel> oldList, JsonElement json) {
        if (oldList != null) {
            for (StackMobModel stackMobModel : oldList) {
                if (!stackMobModel.hasSameID(json)) continue;
                return stackMobModel;
            }
            for (StackMobModel stackMobModel : oldList) {
                if (stackMobModel.getID() != null) continue;
                stackMobModel.setID(json);
                return stackMobModel;
            }
        }
        return null;
    }

    private Field getField(String fieldName) throws NoSuchFieldException {
        Class<? extends StackMobModel> classToCheck = this.actualClass;
        while (!classToCheck.equals(StackMobModel.class)) {
            try {
                Field field = classToCheck.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                classToCheck = classToCheck.getSuperclass();
            }
        }
        throw new NoSuchFieldException(fieldName);
    }

    public void fillFromJson(String jsonString) throws StackMobException {
        this.fillFromJson(new JsonParser().parse(jsonString));
    }

    void fillFromJson(JsonElement json) throws StackMobException {
        this.fillFromJson(json, null);
    }

    void fillFromJson(JsonElement json, List<String> selection) throws StackMobException {
        if (json.isJsonPrimitive()) {
            this.setID(json.getAsJsonPrimitive().getAsString());
        } else {
            for (Map.Entry jsonField : json.getAsJsonObject().entrySet()) {
                if (selection != null && !selection.contains(jsonField.getKey()) && this.getMetadata((String)jsonField.getKey()) != SerializationMetadata.BINARY) continue;
                this.fillFieldFromJson((String)jsonField.getKey(), (JsonElement)jsonField.getValue());
            }
            this.hasData = true;
        }
    }

    boolean hasSameID(JsonElement json) {
        if (this.getID() == null) {
            return false;
        }
        if (json.isJsonPrimitive()) {
            return this.getID().equals(json.getAsJsonPrimitive().getAsString());
        }
        JsonElement idFromJson = json.getAsJsonObject().get(this.getIDFieldName());
        return idFromJson != null && this.getID().equals(idFromJson.getAsString());
    }

    void setID(JsonElement json) {
        if (json.isJsonPrimitive()) {
            this.setID(json.getAsJsonPrimitive().getAsString());
        } else {
            this.setID(json.getAsJsonObject().get(this.getIDFieldName()).getAsString());
        }
    }

    private List<String> getFieldNames(JsonObject json) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry entry : json.entrySet()) {
            list.add((String)entry.getKey());
        }
        return list;
    }

    private void replaceModelJson(JsonObject json, String fieldName, Selection selection, TypeHints relationHints, TypeHints typeHints, int depth) {
        json.remove(fieldName);
        try {
            Field relationField = this.getField(fieldName);
            StackMobModel relatedModel = (StackMobModel)relationField.get(this);
            relationHints.add(fieldName, relatedModel.getSchemaName());
            relationHints.push(fieldName);
            typeHints.push(fieldName);
            JsonElement relatedJson = relatedModel.toJsonElement(depth - 1, selection.subSelection(fieldName), relationHints, typeHints);
            relationHints.pop();
            typeHints.pop();
            if (relatedJson != null) {
                json.add(fieldName, relatedJson);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }

    private void replaceModelArrayJson(JsonObject json, String fieldName, Selection selection, TypeHints relationHints, TypeHints typeHints, int depth) {
        json.remove(fieldName);
        try {
            Field relationField = this.getField(fieldName);
            JsonArray array = new JsonArray();
            List<StackMobModel> relatedModels = relationField.getType().isArray() ? Arrays.asList((StackMobModel[])relationField.get(this)) : (List<StackMobModel>)relationField.get(this);
            boolean first = true;
            for (StackMobModel relatedModel : relatedModels) {
                JsonElement relatedJson;
                if (first) {
                    relationHints.add(fieldName, relatedModel.getSchemaName());
                    relationHints.push(fieldName);
                    typeHints.push(fieldName);
                    first = false;
                }
                if ((relatedJson = relatedModel.toJsonElement(depth - 1, selection.subSelection(fieldName), relationHints, typeHints)) == null) continue;
                array.add(relatedJson);
            }
            if (!first) {
                relationHints.pop();
                typeHints.pop();
            }
            json.add(fieldName, (JsonElement)array);
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }

    protected JsonElement toJsonElement(int depth, Selection selection, TypeHints relationHints, TypeHints typeHints) {
        if (this.getID() == null) {
            this.setID(UUID.randomUUID().toString().replace("-", ""));
        }
        if (depth < 0) {
            return new JsonPrimitive(this.getID());
        }
        JsonObject json = gson.toJsonTree((Object)this).getAsJsonObject();
        JsonObject outgoing = new JsonObject();
        for (String fieldName : this.getFieldNames(json)) {
            String newFieldName;
            block27: {
                if (!selection.isSelected(fieldName)) continue;
                newFieldName = fieldName;
                this.ensureValidFieldName(fieldName);
                JsonElement value = json.get(fieldName);
                if (this.getMetadata(fieldName) == SerializationMetadata.MODEL) {
                    this.replaceModelJson(json, fieldName, selection, relationHints, typeHints, depth);
                } else if (this.getMetadata(fieldName) == SerializationMetadata.MODEL_ARRAY) {
                    this.replaceModelArrayJson(json, fieldName, selection, relationHints, typeHints, depth);
                } else if (this.getMetadata(fieldName) == SerializationMetadata.OBJECT) {
                    if (value.isJsonObject()) {
                        throw new IllegalStateException("Field " + fieldName + " is a subobject which is not supported at this time");
                    }
                } else if (this.getMetadata(fieldName) == SerializationMetadata.COUNTER) {
                    json.remove(fieldName);
                    try {
                        StackMobCounter counter = (StackMobCounter)this.getField(fieldName).get(this);
                        switch (counter.getMode()) {
                            case INCREMENT: {
                                newFieldName = newFieldName + "[inc]";
                                json.add(fieldName, (JsonElement)new JsonPrimitive((Number)counter.getIncrement()));
                                break;
                            }
                            case SET: {
                                json.add(fieldName, (JsonElement)new JsonPrimitive((Number)counter.get()));
                            }
                        }
                        counter.reset();
                    }
                    catch (Exception ignore) {}
                } else if (this.getMetadata(fieldName) == SerializationMetadata.BINARY) {
                    typeHints.add(fieldName, SerializationMetadata.BINARY.name().toLowerCase());
                    json.remove(fieldName);
                    try {
                        StackMobFile file = (StackMobFile)this.getField(fieldName).get(this);
                        if (file.getBinaryString() != null) {
                            json.add(fieldName, (JsonElement)new JsonPrimitive(file.getBinaryString()));
                            break block27;
                        }
                        newFieldName = null;
                    }
                    catch (Exception e) {
                        this.stackmob.getSession().getLogger().logWarning("Got exception while serializing binary file " + e, new Object[0]);
                    }
                } else if (this.getMetadata(fieldName) == SerializationMetadata.GEOPOINT) {
                    typeHints.add(fieldName, SerializationMetadata.GEOPOINT.name().toLowerCase());
                } else if (this.getMetadata(fieldName) == SerializationMetadata.FORGOT_PASSWORD) {
                    typeHints.add(fieldName, SerializationMetadata.FORGOT_PASSWORD.name().toLowerCase().replace("_", ""));
                }
            }
            if (newFieldName == null) continue;
            outgoing.add(newFieldName.toLowerCase(), json.get(fieldName));
        }
        if (this.id != null) {
            outgoing.addProperty(this.getIDFieldName(), this.id);
        }
        return outgoing;
    }

    public String toJson() {
        return this.toJson(StackMobOptions.none());
    }

    public String toJson(StackMobOptions options) {
        return this.toJson(options, new TypeHints(), new TypeHints());
    }

    String toJson(StackMobOptions options, TypeHints relationHints, TypeHints typeHints) {
        return this.toJsonElement(options.getExpandDepth(), new Selection(options.getSelection()), relationHints, typeHints).toString();
    }

    public void fetch(StackMobCallback callback) {
        this.fetch(StackMobOptions.none(), callback);
    }

    public void fetch(StackMobOptions options, StackMobCallback callback) {
        this.stackmob.getDatastore().get(this.getSchemaName() + "/" + this.id, options, (StackMobRawCallback)new StackMobIntermediaryCallback(callback){

            @Override
            public void success(String responseBody) {
                boolean fillSucceeded = false;
                try {
                    StackMobModel.this.fillFromJson(new JsonParser().parse(responseBody));
                    fillSucceeded = true;
                }
                catch (StackMobException e) {
                    this.failure(e);
                }
                if (fillSucceeded) {
                    super.success(responseBody);
                }
            }
        });
    }

    public void save() {
        this.save(new StackMobNoopCallback());
    }

    public void save(StackMobOptions options) {
        this.save(options, new StackMobNoopCallback());
    }

    public void save(StackMobCallback callback) {
        this.save(StackMobOptions.none(), callback);
    }

    public void save(StackMobOptions options, StackMobCallback callback) {
        TypeHints relationHints = new TypeHints();
        TypeHints typeHints = new TypeHints();
        String json = this.toJson(options, relationHints, typeHints);
        ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
        headers.add(new Pair<String, String>("X-StackMob-Relations", relationHints.toHeaderString()));
        headers.add(new Pair<String, String>("X-StackMob-FieldTypes", typeHints.toHeaderString()));
        this.stackmob.getDatastore().post(this.getSchemaName(), json, options.withHeaders(headers), (StackMobRawCallback)new StackMobIntermediaryCallback(callback){

            @Override
            public void success(String responseBody) {
                boolean fillSucceeded = false;
                try {
                    StackMobModel.this.fillFromJson(new JsonParser().parse(responseBody), Arrays.asList("lastmoddate", "createddate"));
                    fillSucceeded = true;
                }
                catch (StackMobException e) {
                    this.failure(e);
                }
                if (fillSucceeded) {
                    super.success(responseBody);
                }
            }
        });
    }

    public void destroy() {
        this.destroy(new StackMobNoopCallback());
    }

    public void destroy(StackMobCallback callback) {
        this.stackmob.getDatastore().delete(this.getSchemaName(), this.id, callback);
    }

    public void exists(StackMobExistsCallback callback) {
        this.stackmob.getDatastore().head(this.getSchemaName() + "/" + this.id, (StackMobRawCallback)callback);
    }

    private <T extends StackMobModel> List<String> getIdsFromModels(List<T> models) {
        ArrayList<String> ids = new ArrayList<String>();
        for (StackMobModel model : models) {
            ids.add(model.id);
        }
        return ids;
    }

    public <T extends StackMobModel> void append(String field, List<T> objs, StackMobCallback callback) {
        try {
            Collection existingCollection = (Collection)this.getField(field).get(this);
            for (StackMobModel obj : objs) {
                existingCollection.add(obj);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Type of input objects does not match the type of the field");
        }
        this.stackmob.getDatastore().putRelated(this.schemaName, this.id, field.toLowerCase(), this.getIdsFromModels(objs), callback);
    }

    public <T extends StackMobModel> void appendAndSave(String field, List<T> objs, StackMobCallback callback) {
        try {
            Collection existingCollection = (Collection)this.getField(field).get(this);
            for (StackMobModel obj : objs) {
                existingCollection.add(obj);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Type of input objects does not match the type of the field");
        }
        this.stackmob.getDatastore().postRelated(this.schemaName, this.id, field.toLowerCase(), StackMobModel.toJsonArray(objs), (StackMobRawCallback)callback);
    }

    public <T extends StackMobModel> void remove(String field, List<T> objs, StackMobCallback callback) {
        try {
            Collection existingCollection = (Collection)this.getField(field).get(this);
            for (StackMobModel obj : objs) {
                existingCollection.remove(obj);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Type of input objects does not match the type of the field");
        }
        this.stackmob.getDatastore().deleteIdsFrom(this.schemaName, this.id, field.toLowerCase(), this.getIdsFromModels(objs), false, callback);
    }

    public <T extends StackMobModel> void removeAndDelete(String field, List<T> objs, StackMobCallback callback) {
        try {
            Collection existingCollection = (Collection)this.getField(field).get(this);
            for (StackMobModel obj : objs) {
                existingCollection.remove(obj);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Type of input objects does not match the type of the field");
        }
        this.stackmob.getDatastore().deleteIdsFrom(this.schemaName, this.id, field.toLowerCase(), this.getIdsFromModels(objs), true, callback);
    }

    private static class Selection {
        private List<String> fields;

        public Selection(List<String> fields) {
            this.fields = fields;
        }

        public boolean isSelected(String field) {
            return this.fields == null || this.fields.contains(field);
        }

        public Selection subSelection(String field) {
            if (this.fields == null) {
                return new Selection(null);
            }
            String prefix = field + ".";
            ArrayList<String> newSelection = new ArrayList<String>();
            for (String selection : this.fields) {
                if (!selection.startsWith(prefix)) continue;
                newSelection.add(selection.substring(prefix.length()));
            }
            return new Selection(newSelection);
        }
    }

    private static class DateAsNumberTypeAdapter
    extends TypeAdapter<Date> {
        private DateAsNumberTypeAdapter() {
        }

        public void write(JsonWriter jsonWriter, Date date) throws IOException {
            if (date == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.value(date.getTime());
        }

        public Date read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return new Date(jsonReader.nextLong());
        }
    }
}

