/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class Account {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unified_custom_fields")
    private JsonNullable<? extends Map<String, Object>> unifiedCustomFields;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("owner_id")
    private JsonNullable<String> ownerId;

    /**
     * Provider's unique identifier of the owner
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_owner_id")
    private JsonNullable<String> remoteOwnerId;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("description")
    private JsonNullable<String> description;

    /**
     * Values of the industries
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("industries")
    private JsonNullable<? extends List<String>> industries;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("annual_revenue")
    private JsonNullable<String> annualRevenue;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("website")
    private JsonNullable<String> website;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("addresses")
    private JsonNullable<? extends List<AccountAddress>> addresses;

    /**
     * List of account phone numbers
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("phone_numbers")
    private JsonNullable<? extends List<String>> phoneNumbers;

    /**
     * Timestamp when the account was created
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * Timestamp when the account was last updated
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    @JsonCreator
    public Account(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("unified_custom_fields") JsonNullable<? extends Map<String, Object>> unifiedCustomFields,
            @JsonProperty("owner_id") JsonNullable<String> ownerId,
            @JsonProperty("remote_owner_id") JsonNullable<String> remoteOwnerId,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("description") JsonNullable<String> description,
            @JsonProperty("industries") JsonNullable<? extends List<String>> industries,
            @JsonProperty("annual_revenue") JsonNullable<String> annualRevenue,
            @JsonProperty("website") JsonNullable<String> website,
            @JsonProperty("addresses") JsonNullable<? extends List<AccountAddress>> addresses,
            @JsonProperty("phone_numbers") JsonNullable<? extends List<String>> phoneNumbers,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        Utils.checkNotNull(ownerId, "ownerId");
        Utils.checkNotNull(remoteOwnerId, "remoteOwnerId");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(industries, "industries");
        Utils.checkNotNull(annualRevenue, "annualRevenue");
        Utils.checkNotNull(website, "website");
        Utils.checkNotNull(addresses, "addresses");
        Utils.checkNotNull(phoneNumbers, "phoneNumbers");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.remoteId = remoteId;
        this.unifiedCustomFields = unifiedCustomFields;
        this.ownerId = ownerId;
        this.remoteOwnerId = remoteOwnerId;
        this.name = name;
        this.description = description;
        this.industries = industries;
        this.annualRevenue = annualRevenue;
        this.website = website;
        this.addresses = addresses;
        this.phoneNumbers = phoneNumbers;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }
    
    public Account() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> unifiedCustomFields() {
        return (JsonNullable<Map<String, Object>>) unifiedCustomFields;
    }

    @JsonIgnore
    public JsonNullable<String> ownerId() {
        return ownerId;
    }

    /**
     * Provider's unique identifier of the owner
     */
    @JsonIgnore
    public JsonNullable<String> remoteOwnerId() {
        return remoteOwnerId;
    }

    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    @JsonIgnore
    public JsonNullable<String> description() {
        return description;
    }

    /**
     * Values of the industries
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> industries() {
        return (JsonNullable<List<String>>) industries;
    }

    @JsonIgnore
    public JsonNullable<String> annualRevenue() {
        return annualRevenue;
    }

    @JsonIgnore
    public JsonNullable<String> website() {
        return website;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<AccountAddress>> addresses() {
        return (JsonNullable<List<AccountAddress>>) addresses;
    }

    /**
     * List of account phone numbers
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> phoneNumbers() {
        return (JsonNullable<List<String>>) phoneNumbers;
    }

    /**
     * Timestamp when the account was created
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * Timestamp when the account was last updated
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * Unique identifier
     */
    public Account withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public Account withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Account withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Account withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public Account withUnifiedCustomFields(Map<String, Object> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public Account withUnifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = unifiedCustomFields;
        return this;
    }

    public Account withOwnerId(String ownerId) {
        Utils.checkNotNull(ownerId, "ownerId");
        this.ownerId = JsonNullable.of(ownerId);
        return this;
    }

    public Account withOwnerId(JsonNullable<String> ownerId) {
        Utils.checkNotNull(ownerId, "ownerId");
        this.ownerId = ownerId;
        return this;
    }

    /**
     * Provider's unique identifier of the owner
     */
    public Account withRemoteOwnerId(String remoteOwnerId) {
        Utils.checkNotNull(remoteOwnerId, "remoteOwnerId");
        this.remoteOwnerId = JsonNullable.of(remoteOwnerId);
        return this;
    }

    /**
     * Provider's unique identifier of the owner
     */
    public Account withRemoteOwnerId(JsonNullable<String> remoteOwnerId) {
        Utils.checkNotNull(remoteOwnerId, "remoteOwnerId");
        this.remoteOwnerId = remoteOwnerId;
        return this;
    }

    public Account withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    public Account withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public Account withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = JsonNullable.of(description);
        return this;
    }

    public Account withDescription(JsonNullable<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    /**
     * Values of the industries
     */
    public Account withIndustries(List<String> industries) {
        Utils.checkNotNull(industries, "industries");
        this.industries = JsonNullable.of(industries);
        return this;
    }

    /**
     * Values of the industries
     */
    public Account withIndustries(JsonNullable<? extends List<String>> industries) {
        Utils.checkNotNull(industries, "industries");
        this.industries = industries;
        return this;
    }

    public Account withAnnualRevenue(String annualRevenue) {
        Utils.checkNotNull(annualRevenue, "annualRevenue");
        this.annualRevenue = JsonNullable.of(annualRevenue);
        return this;
    }

    public Account withAnnualRevenue(JsonNullable<String> annualRevenue) {
        Utils.checkNotNull(annualRevenue, "annualRevenue");
        this.annualRevenue = annualRevenue;
        return this;
    }

    public Account withWebsite(String website) {
        Utils.checkNotNull(website, "website");
        this.website = JsonNullable.of(website);
        return this;
    }

    public Account withWebsite(JsonNullable<String> website) {
        Utils.checkNotNull(website, "website");
        this.website = website;
        return this;
    }

    public Account withAddresses(List<AccountAddress> addresses) {
        Utils.checkNotNull(addresses, "addresses");
        this.addresses = JsonNullable.of(addresses);
        return this;
    }

    public Account withAddresses(JsonNullable<? extends List<AccountAddress>> addresses) {
        Utils.checkNotNull(addresses, "addresses");
        this.addresses = addresses;
        return this;
    }

    /**
     * List of account phone numbers
     */
    public Account withPhoneNumbers(List<String> phoneNumbers) {
        Utils.checkNotNull(phoneNumbers, "phoneNumbers");
        this.phoneNumbers = JsonNullable.of(phoneNumbers);
        return this;
    }

    /**
     * List of account phone numbers
     */
    public Account withPhoneNumbers(JsonNullable<? extends List<String>> phoneNumbers) {
        Utils.checkNotNull(phoneNumbers, "phoneNumbers");
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    /**
     * Timestamp when the account was created
     */
    public Account withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * Timestamp when the account was created
     */
    public Account withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * Timestamp when the account was last updated
     */
    public Account withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * Timestamp when the account was last updated
     */
    public Account withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Account other = (Account) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.remoteId, other.remoteId) &&
            Objects.deepEquals(this.unifiedCustomFields, other.unifiedCustomFields) &&
            Objects.deepEquals(this.ownerId, other.ownerId) &&
            Objects.deepEquals(this.remoteOwnerId, other.remoteOwnerId) &&
            Objects.deepEquals(this.name, other.name) &&
            Objects.deepEquals(this.description, other.description) &&
            Objects.deepEquals(this.industries, other.industries) &&
            Objects.deepEquals(this.annualRevenue, other.annualRevenue) &&
            Objects.deepEquals(this.website, other.website) &&
            Objects.deepEquals(this.addresses, other.addresses) &&
            Objects.deepEquals(this.phoneNumbers, other.phoneNumbers) &&
            Objects.deepEquals(this.createdAt, other.createdAt) &&
            Objects.deepEquals(this.updatedAt, other.updatedAt);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            remoteId,
            unifiedCustomFields,
            ownerId,
            remoteOwnerId,
            name,
            description,
            industries,
            annualRevenue,
            website,
            addresses,
            phoneNumbers,
            createdAt,
            updatedAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Account.class,
                "id", id,
                "remoteId", remoteId,
                "unifiedCustomFields", unifiedCustomFields,
                "ownerId", ownerId,
                "remoteOwnerId", remoteOwnerId,
                "name", name,
                "description", description,
                "industries", industries,
                "annualRevenue", annualRevenue,
                "website", website,
                "addresses", addresses,
                "phoneNumbers", phoneNumbers,
                "createdAt", createdAt,
                "updatedAt", updatedAt);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> unifiedCustomFields = JsonNullable.undefined();
 
        private JsonNullable<String> ownerId = JsonNullable.undefined();
 
        private JsonNullable<String> remoteOwnerId = JsonNullable.undefined();
 
        private JsonNullable<String> name = JsonNullable.undefined();
 
        private JsonNullable<String> description = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> industries = JsonNullable.undefined();
 
        private JsonNullable<String> annualRevenue = JsonNullable.undefined();
 
        private JsonNullable<String> website = JsonNullable.undefined();
 
        private JsonNullable<? extends List<AccountAddress>> addresses = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> phoneNumbers = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(Map<String, Object> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = unifiedCustomFields;
            return this;
        }

        public Builder ownerId(String ownerId) {
            Utils.checkNotNull(ownerId, "ownerId");
            this.ownerId = JsonNullable.of(ownerId);
            return this;
        }

        public Builder ownerId(JsonNullable<String> ownerId) {
            Utils.checkNotNull(ownerId, "ownerId");
            this.ownerId = ownerId;
            return this;
        }

        /**
         * Provider's unique identifier of the owner
         */
        public Builder remoteOwnerId(String remoteOwnerId) {
            Utils.checkNotNull(remoteOwnerId, "remoteOwnerId");
            this.remoteOwnerId = JsonNullable.of(remoteOwnerId);
            return this;
        }

        /**
         * Provider's unique identifier of the owner
         */
        public Builder remoteOwnerId(JsonNullable<String> remoteOwnerId) {
            Utils.checkNotNull(remoteOwnerId, "remoteOwnerId");
            this.remoteOwnerId = remoteOwnerId;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = JsonNullable.of(description);
            return this;
        }

        public Builder description(JsonNullable<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }

        /**
         * Values of the industries
         */
        public Builder industries(List<String> industries) {
            Utils.checkNotNull(industries, "industries");
            this.industries = JsonNullable.of(industries);
            return this;
        }

        /**
         * Values of the industries
         */
        public Builder industries(JsonNullable<? extends List<String>> industries) {
            Utils.checkNotNull(industries, "industries");
            this.industries = industries;
            return this;
        }

        public Builder annualRevenue(String annualRevenue) {
            Utils.checkNotNull(annualRevenue, "annualRevenue");
            this.annualRevenue = JsonNullable.of(annualRevenue);
            return this;
        }

        public Builder annualRevenue(JsonNullable<String> annualRevenue) {
            Utils.checkNotNull(annualRevenue, "annualRevenue");
            this.annualRevenue = annualRevenue;
            return this;
        }

        public Builder website(String website) {
            Utils.checkNotNull(website, "website");
            this.website = JsonNullable.of(website);
            return this;
        }

        public Builder website(JsonNullable<String> website) {
            Utils.checkNotNull(website, "website");
            this.website = website;
            return this;
        }

        public Builder addresses(List<AccountAddress> addresses) {
            Utils.checkNotNull(addresses, "addresses");
            this.addresses = JsonNullable.of(addresses);
            return this;
        }

        public Builder addresses(JsonNullable<? extends List<AccountAddress>> addresses) {
            Utils.checkNotNull(addresses, "addresses");
            this.addresses = addresses;
            return this;
        }

        /**
         * List of account phone numbers
         */
        public Builder phoneNumbers(List<String> phoneNumbers) {
            Utils.checkNotNull(phoneNumbers, "phoneNumbers");
            this.phoneNumbers = JsonNullable.of(phoneNumbers);
            return this;
        }

        /**
         * List of account phone numbers
         */
        public Builder phoneNumbers(JsonNullable<? extends List<String>> phoneNumbers) {
            Utils.checkNotNull(phoneNumbers, "phoneNumbers");
            this.phoneNumbers = phoneNumbers;
            return this;
        }

        /**
         * Timestamp when the account was created
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * Timestamp when the account was created
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        /**
         * Timestamp when the account was last updated
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * Timestamp when the account was last updated
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }
        
        public Account build() {
            return new Account(
                id,
                remoteId,
                unifiedCustomFields,
                ownerId,
                remoteOwnerId,
                name,
                description,
                industries,
                annualRevenue,
                website,
                addresses,
                phoneNumbers,
                createdAt,
                updatedAt);
        }
    }
}

