/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.stackone.stackone_client_java.models.components.Method;
import com.stackone.stackone_client_java.utils.LazySingletonValue;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class ProxyRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="url")
    private JsonNullable<String> url;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="method")
    private JsonNullable<? extends Method> method;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="path")
    private JsonNullable<String> path;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="headers")
    private JsonNullable<? extends Map<String, Object>> headers;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="body")
    private JsonNullable<? extends Map<String, Object>> body;

    @JsonCreator
    public ProxyRequestBody(@JsonProperty(value="url") JsonNullable<String> url, @JsonProperty(value="method") JsonNullable<? extends Method> method, @JsonProperty(value="path") JsonNullable<String> path, @JsonProperty(value="headers") JsonNullable<? extends Map<String, Object>> headers, @JsonProperty(value="body") JsonNullable<? extends Map<String, Object>> body) {
        Utils.checkNotNull(url, "url");
        Utils.checkNotNull(method, "method");
        Utils.checkNotNull(path, "path");
        Utils.checkNotNull(headers, "headers");
        Utils.checkNotNull(body, "body");
        this.url = url;
        this.method = method;
        this.path = path;
        this.headers = headers;
        this.body = body;
    }

    public ProxyRequestBody() {
        this((JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends Method>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends Map<String, Object>>)JsonNullable.undefined(), (JsonNullable<? extends Map<String, Object>>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> url() {
        return this.url;
    }

    @JsonIgnore
    public JsonNullable<Method> method() {
        return this.method;
    }

    @JsonIgnore
    public JsonNullable<String> path() {
        return this.path;
    }

    @JsonIgnore
    public JsonNullable<Map<String, Object>> headers() {
        return this.headers;
    }

    @JsonIgnore
    public JsonNullable<Map<String, Object>> body() {
        return this.body;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public ProxyRequestBody withUrl(String url) {
        Utils.checkNotNull(url, "url");
        this.url = JsonNullable.of((Object)url);
        return this;
    }

    public ProxyRequestBody withUrl(JsonNullable<String> url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }

    public ProxyRequestBody withMethod(Method method) {
        Utils.checkNotNull(method, "method");
        this.method = JsonNullable.of((Object)method);
        return this;
    }

    public ProxyRequestBody withMethod(JsonNullable<? extends Method> method) {
        Utils.checkNotNull(method, "method");
        this.method = method;
        return this;
    }

    public ProxyRequestBody withPath(String path) {
        Utils.checkNotNull(path, "path");
        this.path = JsonNullable.of((Object)path);
        return this;
    }

    public ProxyRequestBody withPath(JsonNullable<String> path) {
        Utils.checkNotNull(path, "path");
        this.path = path;
        return this;
    }

    public ProxyRequestBody withHeaders(Map<String, Object> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = JsonNullable.of(headers);
        return this;
    }

    public ProxyRequestBody withHeaders(JsonNullable<? extends Map<String, Object>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public ProxyRequestBody withBody(Map<String, Object> body) {
        Utils.checkNotNull(body, "body");
        this.body = JsonNullable.of(body);
        return this;
    }

    public ProxyRequestBody withBody(JsonNullable<? extends Map<String, Object>> body) {
        Utils.checkNotNull(body, "body");
        this.body = body;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyRequestBody other = (ProxyRequestBody)o;
        return Objects.deepEquals(this.url, other.url) && Objects.deepEquals(this.method, other.method) && Objects.deepEquals(this.path, other.path) && Objects.deepEquals(this.headers, other.headers) && Objects.deepEquals(this.body, other.body);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.method, this.path, this.headers, this.body);
    }

    public String toString() {
        return Utils.toString(ProxyRequestBody.class, "url", this.url, "method", this.method, "path", this.path, "headers", this.headers, "body", this.body);
    }

    public static final class Builder {
        private JsonNullable<String> url = JsonNullable.undefined();
        private JsonNullable<? extends Method> method;
        private JsonNullable<String> path = JsonNullable.undefined();
        private JsonNullable<? extends Map<String, Object>> headers = JsonNullable.undefined();
        private JsonNullable<? extends Map<String, Object>> body = JsonNullable.undefined();
        private static final LazySingletonValue<JsonNullable<? extends Method>> _SINGLETON_VALUE_Method = new LazySingletonValue<JsonNullable<? extends Method>>("method", "\"get\"", new TypeReference<JsonNullable<? extends Method>>(){});

        private Builder() {
        }

        public Builder url(String url) {
            Utils.checkNotNull(url, "url");
            this.url = JsonNullable.of((Object)url);
            return this;
        }

        public Builder url(JsonNullable<String> url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }

        public Builder method(Method method) {
            Utils.checkNotNull(method, "method");
            this.method = JsonNullable.of((Object)method);
            return this;
        }

        public Builder method(JsonNullable<? extends Method> method) {
            Utils.checkNotNull(method, "method");
            this.method = method;
            return this;
        }

        public Builder path(String path) {
            Utils.checkNotNull(path, "path");
            this.path = JsonNullable.of((Object)path);
            return this;
        }

        public Builder path(JsonNullable<String> path) {
            Utils.checkNotNull(path, "path");
            this.path = path;
            return this;
        }

        public Builder headers(Map<String, Object> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = JsonNullable.of(headers);
            return this;
        }

        public Builder headers(JsonNullable<? extends Map<String, Object>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public Builder body(Map<String, Object> body) {
            Utils.checkNotNull(body, "body");
            this.body = JsonNullable.of(body);
            return this;
        }

        public Builder body(JsonNullable<? extends Map<String, Object>> body) {
            Utils.checkNotNull(body, "body");
            this.body = body;
            return this;
        }

        public ProxyRequestBody build() {
            if (this.method == null) {
                this.method = _SINGLETON_VALUE_Method.value();
            }
            return new ProxyRequestBody(this.url, this.method, this.path, this.headers, this.body);
        }
    }
}

