/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class CampaignStatusValue {
    public static final CampaignStatusValue DRAFT = new CampaignStatusValue("draft");
    public static final CampaignStatusValue ARCHIVED = new CampaignStatusValue("archived");
    public static final CampaignStatusValue LIVE = new CampaignStatusValue("live");
    private static final Map<String, CampaignStatusValue> values = CampaignStatusValue.createValuesMap();
    private static final Map<String, CampaignStatusValueEnum> enums = CampaignStatusValue.createEnumsMap();
    private final String value;

    private CampaignStatusValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CampaignStatusValue of(String value) {
        Class<CampaignStatusValue> clazz = CampaignStatusValue.class;
        synchronized (CampaignStatusValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new CampaignStatusValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<CampaignStatusValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CampaignStatusValue other = (CampaignStatusValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "CampaignStatusValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CampaignStatusValue[] values() {
        Class<CampaignStatusValue> clazz = CampaignStatusValue.class;
        synchronized (CampaignStatusValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new CampaignStatusValue[0]);
        }
    }

    private static final Map<String, CampaignStatusValue> createValuesMap() {
        LinkedHashMap<String, CampaignStatusValue> map = new LinkedHashMap<String, CampaignStatusValue>();
        map.put("draft", DRAFT);
        map.put("archived", ARCHIVED);
        map.put("live", LIVE);
        return map;
    }

    private static final Map<String, CampaignStatusValueEnum> createEnumsMap() {
        HashMap<String, CampaignStatusValueEnum> map = new HashMap<String, CampaignStatusValueEnum>();
        map.put("draft", CampaignStatusValueEnum.DRAFT);
        map.put("archived", CampaignStatusValueEnum.ARCHIVED);
        map.put("live", CampaignStatusValueEnum.LIVE);
        return map;
    }

    public static enum CampaignStatusValueEnum {
        DRAFT("draft"),
        ARCHIVED("archived"),
        LIVE("live");

        private final String value;

        private CampaignStatusValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<CampaignStatusValue> {
        protected _Deserializer() {
            super(CampaignStatusValue.class);
        }

        public CampaignStatusValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return CampaignStatusValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<CampaignStatusValue> {
        protected _Serializer() {
            super(CampaignStatusValue.class);
        }

        public void serialize(CampaignStatusValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

