/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;
/**
 * AnswerType - Type of the answer
 */

public class AnswerType {

    /**
     * The type of the answer.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends AnswerValue> value;

    /**
     * The source value of the answer type.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends AnswerSourceValue> sourceValue;

    @JsonCreator
    public AnswerType(
            @JsonProperty("value") JsonNullable<? extends AnswerValue> value,
            @JsonProperty("source_value") JsonNullable<? extends AnswerSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public AnswerType() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The type of the answer.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AnswerValue> value() {
        return (JsonNullable<AnswerValue>) value;
    }

    /**
     * The source value of the answer type.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AnswerSourceValue> sourceValue() {
        return (JsonNullable<AnswerSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * The type of the answer.
     */
    public AnswerType withValue(AnswerValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The type of the answer.
     */
    public AnswerType withValue(JsonNullable<? extends AnswerValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the answer type.
     */
    public AnswerType withSourceValue(AnswerSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the answer type.
     */
    public AnswerType withSourceValue(JsonNullable<? extends AnswerSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AnswerType other = (AnswerType) o;
        return 
            Objects.deepEquals(this.value, other.value) &&
            Objects.deepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AnswerType.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends AnswerValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends AnswerSourceValue> sourceValue = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The type of the answer.
         */
        public Builder value(AnswerValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The type of the answer.
         */
        public Builder value(JsonNullable<? extends AnswerValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        /**
         * The source value of the answer type.
         */
        public Builder sourceValue(AnswerSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the answer type.
         */
        public Builder sourceValue(JsonNullable<? extends AnswerSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public AnswerType build() {
            return new AnswerType(
                value,
                sourceValue);
        }
    }
}

