/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;


/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * JobPostingValue - The status of the job postings.
 */
@JsonDeserialize(using = JobPostingValue._Deserializer.class)
@JsonSerialize(using = JobPostingValue._Serializer.class)
public class JobPostingValue {

    public static final JobPostingValue LIVE = new JobPostingValue("live");
    public static final JobPostingValue DRAFT = new JobPostingValue("draft");
    public static final JobPostingValue PENDING = new JobPostingValue("pending");
    public static final JobPostingValue INTERNAL = new JobPostingValue("internal");
    public static final JobPostingValue REJECTED = new JobPostingValue("rejected");
    public static final JobPostingValue CLOSED = new JobPostingValue("closed");
    public static final JobPostingValue ARCHIVED = new JobPostingValue("archived");
    public static final JobPostingValue UNMAPPED_VALUE = new JobPostingValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, JobPostingValue> values = createValuesMap();
    private static final Map<String, JobPostingValueEnum> enums = createEnumsMap();

    private final String value;

    private JobPostingValue(String value) {
        this.value = value;
    }

    /**
     * Returns a JobPostingValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as JobPostingValue
     */ 
    public static JobPostingValue of(String value) {
        synchronized (JobPostingValue.class) {
            return values.computeIfAbsent(value, v -> new JobPostingValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<JobPostingValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        JobPostingValue other = (JobPostingValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "JobPostingValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static JobPostingValue[] values() {
        synchronized (JobPostingValue.class) {
            return values.values().toArray(new JobPostingValue[] {});
        }
    }

    private static final Map<String, JobPostingValue> createValuesMap() {
        Map<String, JobPostingValue> map = new LinkedHashMap<>();
        map.put("live", LIVE);
        map.put("draft", DRAFT);
        map.put("pending", PENDING);
        map.put("internal", INTERNAL);
        map.put("rejected", REJECTED);
        map.put("closed", CLOSED);
        map.put("archived", ARCHIVED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, JobPostingValueEnum> createEnumsMap() {
        Map<String, JobPostingValueEnum> map = new HashMap<>();
        map.put("live", JobPostingValueEnum.LIVE);
        map.put("draft", JobPostingValueEnum.DRAFT);
        map.put("pending", JobPostingValueEnum.PENDING);
        map.put("internal", JobPostingValueEnum.INTERNAL);
        map.put("rejected", JobPostingValueEnum.REJECTED);
        map.put("closed", JobPostingValueEnum.CLOSED);
        map.put("archived", JobPostingValueEnum.ARCHIVED);
        map.put("unmapped_value", JobPostingValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<JobPostingValue> {

        protected _Serializer() {
            super(JobPostingValue.class);
        }

        @Override
        public void serialize(JobPostingValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<JobPostingValue> {

        protected _Deserializer() {
            super(JobPostingValue.class);
        }

        @Override
        public JobPostingValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return JobPostingValue.of(v);
        }
    }
    
    public enum JobPostingValueEnum {

        LIVE("live"),
        DRAFT("draft"),
        PENDING("pending"),
        INTERNAL("internal"),
        REJECTED("rejected"),
        CLOSED("closed"),
        ARCHIVED("archived"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private JobPostingValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}
