/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class LinkedAccount {

    @JsonProperty("id")
    private String id;

    @JsonProperty("provider")
    private String provider;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("provider_name")
    private JsonNullable<String> providerName;

    @JsonProperty("status")
    private Status status;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status_reasons")
    private JsonNullable<? extends List<StatusReason>> statusReasons;

    @JsonProperty("origin_owner_id")
    private String originOwnerId;

    @JsonProperty("origin_owner_name")
    private String originOwnerName;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("origin_username")
    private JsonNullable<String> originUsername;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("credentials")
    private JsonNullable<? extends Credentials> credentials;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("setup_information")
    private JsonNullable<? extends SetupInformation> setupInformation;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("label")
    private JsonNullable<String> label;

    @JsonProperty("created_at")
    private OffsetDateTime createdAt;

    @JsonProperty("updated_at")
    private OffsetDateTime updatedAt;

    @JsonCreator
    public LinkedAccount(
            @JsonProperty("id") String id,
            @JsonProperty("provider") String provider,
            @JsonProperty("provider_name") JsonNullable<String> providerName,
            @JsonProperty("status") Status status,
            @JsonProperty("status_reasons") JsonNullable<? extends List<StatusReason>> statusReasons,
            @JsonProperty("origin_owner_id") String originOwnerId,
            @JsonProperty("origin_owner_name") String originOwnerName,
            @JsonProperty("origin_username") JsonNullable<String> originUsername,
            @JsonProperty("credentials") JsonNullable<? extends Credentials> credentials,
            @JsonProperty("setup_information") JsonNullable<? extends SetupInformation> setupInformation,
            @JsonProperty("label") JsonNullable<String> label,
            @JsonProperty("created_at") OffsetDateTime createdAt,
            @JsonProperty("updated_at") OffsetDateTime updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(provider, "provider");
        Utils.checkNotNull(providerName, "providerName");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(statusReasons, "statusReasons");
        Utils.checkNotNull(originOwnerId, "originOwnerId");
        Utils.checkNotNull(originOwnerName, "originOwnerName");
        Utils.checkNotNull(originUsername, "originUsername");
        Utils.checkNotNull(credentials, "credentials");
        Utils.checkNotNull(setupInformation, "setupInformation");
        Utils.checkNotNull(label, "label");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.provider = provider;
        this.providerName = providerName;
        this.status = status;
        this.statusReasons = statusReasons;
        this.originOwnerId = originOwnerId;
        this.originOwnerName = originOwnerName;
        this.originUsername = originUsername;
        this.credentials = credentials;
        this.setupInformation = setupInformation;
        this.label = label;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }
    
    public LinkedAccount(
            String id,
            String provider,
            Status status,
            String originOwnerId,
            String originOwnerName,
            OffsetDateTime createdAt,
            OffsetDateTime updatedAt) {
        this(id, provider, JsonNullable.undefined(), status, JsonNullable.undefined(), originOwnerId, originOwnerName, JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), createdAt, updatedAt);
    }

    @JsonIgnore
    public String id() {
        return id;
    }

    @JsonIgnore
    public String provider() {
        return provider;
    }

    @JsonIgnore
    public JsonNullable<String> providerName() {
        return providerName;
    }

    @JsonIgnore
    public Status status() {
        return status;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<StatusReason>> statusReasons() {
        return (JsonNullable<List<StatusReason>>) statusReasons;
    }

    @JsonIgnore
    public String originOwnerId() {
        return originOwnerId;
    }

    @JsonIgnore
    public String originOwnerName() {
        return originOwnerName;
    }

    @JsonIgnore
    public JsonNullable<String> originUsername() {
        return originUsername;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Credentials> credentials() {
        return (JsonNullable<Credentials>) credentials;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<SetupInformation> setupInformation() {
        return (JsonNullable<SetupInformation>) setupInformation;
    }

    @JsonIgnore
    public JsonNullable<String> label() {
        return label;
    }

    @JsonIgnore
    public OffsetDateTime createdAt() {
        return createdAt;
    }

    @JsonIgnore
    public OffsetDateTime updatedAt() {
        return updatedAt;
    }

    public final static Builder builder() {
        return new Builder();
    }

    public LinkedAccount withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public LinkedAccount withProvider(String provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = provider;
        return this;
    }

    public LinkedAccount withProviderName(String providerName) {
        Utils.checkNotNull(providerName, "providerName");
        this.providerName = JsonNullable.of(providerName);
        return this;
    }

    public LinkedAccount withProviderName(JsonNullable<String> providerName) {
        Utils.checkNotNull(providerName, "providerName");
        this.providerName = providerName;
        return this;
    }

    public LinkedAccount withStatus(Status status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public LinkedAccount withStatusReasons(List<StatusReason> statusReasons) {
        Utils.checkNotNull(statusReasons, "statusReasons");
        this.statusReasons = JsonNullable.of(statusReasons);
        return this;
    }

    public LinkedAccount withStatusReasons(JsonNullable<? extends List<StatusReason>> statusReasons) {
        Utils.checkNotNull(statusReasons, "statusReasons");
        this.statusReasons = statusReasons;
        return this;
    }

    public LinkedAccount withOriginOwnerId(String originOwnerId) {
        Utils.checkNotNull(originOwnerId, "originOwnerId");
        this.originOwnerId = originOwnerId;
        return this;
    }

    public LinkedAccount withOriginOwnerName(String originOwnerName) {
        Utils.checkNotNull(originOwnerName, "originOwnerName");
        this.originOwnerName = originOwnerName;
        return this;
    }

    public LinkedAccount withOriginUsername(String originUsername) {
        Utils.checkNotNull(originUsername, "originUsername");
        this.originUsername = JsonNullable.of(originUsername);
        return this;
    }

    public LinkedAccount withOriginUsername(JsonNullable<String> originUsername) {
        Utils.checkNotNull(originUsername, "originUsername");
        this.originUsername = originUsername;
        return this;
    }

    public LinkedAccount withCredentials(Credentials credentials) {
        Utils.checkNotNull(credentials, "credentials");
        this.credentials = JsonNullable.of(credentials);
        return this;
    }

    public LinkedAccount withCredentials(JsonNullable<? extends Credentials> credentials) {
        Utils.checkNotNull(credentials, "credentials");
        this.credentials = credentials;
        return this;
    }

    public LinkedAccount withSetupInformation(SetupInformation setupInformation) {
        Utils.checkNotNull(setupInformation, "setupInformation");
        this.setupInformation = JsonNullable.of(setupInformation);
        return this;
    }

    public LinkedAccount withSetupInformation(JsonNullable<? extends SetupInformation> setupInformation) {
        Utils.checkNotNull(setupInformation, "setupInformation");
        this.setupInformation = setupInformation;
        return this;
    }

    public LinkedAccount withLabel(String label) {
        Utils.checkNotNull(label, "label");
        this.label = JsonNullable.of(label);
        return this;
    }

    public LinkedAccount withLabel(JsonNullable<String> label) {
        Utils.checkNotNull(label, "label");
        this.label = label;
        return this;
    }

    public LinkedAccount withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public LinkedAccount withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LinkedAccount other = (LinkedAccount) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.provider, other.provider) &&
            Objects.deepEquals(this.providerName, other.providerName) &&
            Objects.deepEquals(this.status, other.status) &&
            Objects.deepEquals(this.statusReasons, other.statusReasons) &&
            Objects.deepEquals(this.originOwnerId, other.originOwnerId) &&
            Objects.deepEquals(this.originOwnerName, other.originOwnerName) &&
            Objects.deepEquals(this.originUsername, other.originUsername) &&
            Objects.deepEquals(this.credentials, other.credentials) &&
            Objects.deepEquals(this.setupInformation, other.setupInformation) &&
            Objects.deepEquals(this.label, other.label) &&
            Objects.deepEquals(this.createdAt, other.createdAt) &&
            Objects.deepEquals(this.updatedAt, other.updatedAt);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            provider,
            providerName,
            status,
            statusReasons,
            originOwnerId,
            originOwnerName,
            originUsername,
            credentials,
            setupInformation,
            label,
            createdAt,
            updatedAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LinkedAccount.class,
                "id", id,
                "provider", provider,
                "providerName", providerName,
                "status", status,
                "statusReasons", statusReasons,
                "originOwnerId", originOwnerId,
                "originOwnerName", originOwnerName,
                "originUsername", originUsername,
                "credentials", credentials,
                "setupInformation", setupInformation,
                "label", label,
                "createdAt", createdAt,
                "updatedAt", updatedAt);
    }
    
    public final static class Builder {
 
        private String id;
 
        private String provider;
 
        private JsonNullable<String> providerName = JsonNullable.undefined();
 
        private Status status;
 
        private JsonNullable<? extends List<StatusReason>> statusReasons = JsonNullable.undefined();
 
        private String originOwnerId;
 
        private String originOwnerName;
 
        private JsonNullable<String> originUsername = JsonNullable.undefined();
 
        private JsonNullable<? extends Credentials> credentials = JsonNullable.undefined();
 
        private JsonNullable<? extends SetupInformation> setupInformation = JsonNullable.undefined();
 
        private JsonNullable<String> label = JsonNullable.undefined();
 
        private OffsetDateTime createdAt;
 
        private OffsetDateTime updatedAt;  
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder provider(String provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = provider;
            return this;
        }

        public Builder providerName(String providerName) {
            Utils.checkNotNull(providerName, "providerName");
            this.providerName = JsonNullable.of(providerName);
            return this;
        }

        public Builder providerName(JsonNullable<String> providerName) {
            Utils.checkNotNull(providerName, "providerName");
            this.providerName = providerName;
            return this;
        }

        public Builder status(Status status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder statusReasons(List<StatusReason> statusReasons) {
            Utils.checkNotNull(statusReasons, "statusReasons");
            this.statusReasons = JsonNullable.of(statusReasons);
            return this;
        }

        public Builder statusReasons(JsonNullable<? extends List<StatusReason>> statusReasons) {
            Utils.checkNotNull(statusReasons, "statusReasons");
            this.statusReasons = statusReasons;
            return this;
        }

        public Builder originOwnerId(String originOwnerId) {
            Utils.checkNotNull(originOwnerId, "originOwnerId");
            this.originOwnerId = originOwnerId;
            return this;
        }

        public Builder originOwnerName(String originOwnerName) {
            Utils.checkNotNull(originOwnerName, "originOwnerName");
            this.originOwnerName = originOwnerName;
            return this;
        }

        public Builder originUsername(String originUsername) {
            Utils.checkNotNull(originUsername, "originUsername");
            this.originUsername = JsonNullable.of(originUsername);
            return this;
        }

        public Builder originUsername(JsonNullable<String> originUsername) {
            Utils.checkNotNull(originUsername, "originUsername");
            this.originUsername = originUsername;
            return this;
        }

        public Builder credentials(Credentials credentials) {
            Utils.checkNotNull(credentials, "credentials");
            this.credentials = JsonNullable.of(credentials);
            return this;
        }

        public Builder credentials(JsonNullable<? extends Credentials> credentials) {
            Utils.checkNotNull(credentials, "credentials");
            this.credentials = credentials;
            return this;
        }

        public Builder setupInformation(SetupInformation setupInformation) {
            Utils.checkNotNull(setupInformation, "setupInformation");
            this.setupInformation = JsonNullable.of(setupInformation);
            return this;
        }

        public Builder setupInformation(JsonNullable<? extends SetupInformation> setupInformation) {
            Utils.checkNotNull(setupInformation, "setupInformation");
            this.setupInformation = setupInformation;
            return this;
        }

        public Builder label(String label) {
            Utils.checkNotNull(label, "label");
            this.label = JsonNullable.of(label);
            return this;
        }

        public Builder label(JsonNullable<String> label) {
            Utils.checkNotNull(label, "label");
            this.label = label;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }
        
        public LinkedAccount build() {
            return new LinkedAccount(
                id,
                provider,
                providerName,
                status,
                statusReasons,
                originOwnerId,
                originOwnerName,
                originUsername,
                credentials,
                setupInformation,
                label,
                createdAt,
                updatedAt);
        }
    }
}

