/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;
/**
 * LocalizationModelLanguage - The language associated with the localization details
 */

public class LocalizationModelLanguage {

    /**
     * The Locale Code of the language
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends LocalizationModelValue> value;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends LocalizationModelSourceValue> sourceValue;

    @JsonCreator
    public LocalizationModelLanguage(
            @JsonProperty("value") JsonNullable<? extends LocalizationModelValue> value,
            @JsonProperty("source_value") JsonNullable<? extends LocalizationModelSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public LocalizationModelLanguage() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The Locale Code of the language
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<LocalizationModelValue> value() {
        return (JsonNullable<LocalizationModelValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<LocalizationModelSourceValue> sourceValue() {
        return (JsonNullable<LocalizationModelSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * The Locale Code of the language
     */
    public LocalizationModelLanguage withValue(LocalizationModelValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The Locale Code of the language
     */
    public LocalizationModelLanguage withValue(JsonNullable<? extends LocalizationModelValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public LocalizationModelLanguage withSourceValue(LocalizationModelSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public LocalizationModelLanguage withSourceValue(JsonNullable<? extends LocalizationModelSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LocalizationModelLanguage other = (LocalizationModelLanguage) o;
        return 
            Objects.deepEquals(this.value, other.value) &&
            Objects.deepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LocalizationModelLanguage.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends LocalizationModelValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends LocalizationModelSourceValue> sourceValue = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The Locale Code of the language
         */
        public Builder value(LocalizationModelValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The Locale Code of the language
         */
        public Builder value(JsonNullable<? extends LocalizationModelValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(LocalizationModelSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends LocalizationModelSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public LocalizationModelLanguage build() {
            return new LocalizationModelLanguage(
                value,
                sourceValue);
        }
    }
}

