/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class TimeEntries {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unified_custom_fields")
    private JsonNullable<? extends Map<String, Object>> unifiedCustomFields;

    /**
     * The employee ID associated with this time entry
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("employee_id")
    private JsonNullable<String> employeeId;

    /**
     * Provider's unique identifier of the employee associated with this time entry
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_employee_id")
    private JsonNullable<String> remoteEmployeeId;

    /**
     * The start time of the time entry
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("start_time")
    private JsonNullable<OffsetDateTime> startTime;

    /**
     * The end time of the time entry
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("end_time")
    private JsonNullable<OffsetDateTime> endTime;

    /**
     * The hours worked in the time entry
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("hours_worked")
    private JsonNullable<Double> hoursWorked;

    /**
     * The duration of the break taken during time entry in hours
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("break_duration")
    private JsonNullable<Double> breakDuration;

    /**
     * The status of the time entry
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status")
    private JsonNullable<? extends TimeEntriesStatus> status;

    /**
     * The labor type associated with this time entry
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("labor_type")
    private JsonNullable<? extends LaborType> laborType;

    /**
     * The location of the time entry
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("location")
    private JsonNullable<? extends Location> location;

    /**
     * The created_at date
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * The updated_at date
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    @JsonCreator
    public TimeEntries(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("unified_custom_fields") JsonNullable<? extends Map<String, Object>> unifiedCustomFields,
            @JsonProperty("employee_id") JsonNullable<String> employeeId,
            @JsonProperty("remote_employee_id") JsonNullable<String> remoteEmployeeId,
            @JsonProperty("start_time") JsonNullable<OffsetDateTime> startTime,
            @JsonProperty("end_time") JsonNullable<OffsetDateTime> endTime,
            @JsonProperty("hours_worked") JsonNullable<Double> hoursWorked,
            @JsonProperty("break_duration") JsonNullable<Double> breakDuration,
            @JsonProperty("status") JsonNullable<? extends TimeEntriesStatus> status,
            @JsonProperty("labor_type") JsonNullable<? extends LaborType> laborType,
            @JsonProperty("location") JsonNullable<? extends Location> location,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        Utils.checkNotNull(employeeId, "employeeId");
        Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
        Utils.checkNotNull(startTime, "startTime");
        Utils.checkNotNull(endTime, "endTime");
        Utils.checkNotNull(hoursWorked, "hoursWorked");
        Utils.checkNotNull(breakDuration, "breakDuration");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(laborType, "laborType");
        Utils.checkNotNull(location, "location");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.remoteId = remoteId;
        this.unifiedCustomFields = unifiedCustomFields;
        this.employeeId = employeeId;
        this.remoteEmployeeId = remoteEmployeeId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.hoursWorked = hoursWorked;
        this.breakDuration = breakDuration;
        this.status = status;
        this.laborType = laborType;
        this.location = location;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }
    
    public TimeEntries() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> unifiedCustomFields() {
        return (JsonNullable<Map<String, Object>>) unifiedCustomFields;
    }

    /**
     * The employee ID associated with this time entry
     */
    @JsonIgnore
    public JsonNullable<String> employeeId() {
        return employeeId;
    }

    /**
     * Provider's unique identifier of the employee associated with this time entry
     */
    @JsonIgnore
    public JsonNullable<String> remoteEmployeeId() {
        return remoteEmployeeId;
    }

    /**
     * The start time of the time entry
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> startTime() {
        return startTime;
    }

    /**
     * The end time of the time entry
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> endTime() {
        return endTime;
    }

    /**
     * The hours worked in the time entry
     */
    @JsonIgnore
    public JsonNullable<Double> hoursWorked() {
        return hoursWorked;
    }

    /**
     * The duration of the break taken during time entry in hours
     */
    @JsonIgnore
    public JsonNullable<Double> breakDuration() {
        return breakDuration;
    }

    /**
     * The status of the time entry
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TimeEntriesStatus> status() {
        return (JsonNullable<TimeEntriesStatus>) status;
    }

    /**
     * The labor type associated with this time entry
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<LaborType> laborType() {
        return (JsonNullable<LaborType>) laborType;
    }

    /**
     * The location of the time entry
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Location> location() {
        return (JsonNullable<Location>) location;
    }

    /**
     * The created_at date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * The updated_at date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * Unique identifier
     */
    public TimeEntries withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public TimeEntries withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public TimeEntries withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public TimeEntries withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public TimeEntries withUnifiedCustomFields(Map<String, Object> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public TimeEntries withUnifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = unifiedCustomFields;
        return this;
    }

    /**
     * The employee ID associated with this time entry
     */
    public TimeEntries withEmployeeId(String employeeId) {
        Utils.checkNotNull(employeeId, "employeeId");
        this.employeeId = JsonNullable.of(employeeId);
        return this;
    }

    /**
     * The employee ID associated with this time entry
     */
    public TimeEntries withEmployeeId(JsonNullable<String> employeeId) {
        Utils.checkNotNull(employeeId, "employeeId");
        this.employeeId = employeeId;
        return this;
    }

    /**
     * Provider's unique identifier of the employee associated with this time entry
     */
    public TimeEntries withRemoteEmployeeId(String remoteEmployeeId) {
        Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
        this.remoteEmployeeId = JsonNullable.of(remoteEmployeeId);
        return this;
    }

    /**
     * Provider's unique identifier of the employee associated with this time entry
     */
    public TimeEntries withRemoteEmployeeId(JsonNullable<String> remoteEmployeeId) {
        Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
        this.remoteEmployeeId = remoteEmployeeId;
        return this;
    }

    /**
     * The start time of the time entry
     */
    public TimeEntries withStartTime(OffsetDateTime startTime) {
        Utils.checkNotNull(startTime, "startTime");
        this.startTime = JsonNullable.of(startTime);
        return this;
    }

    /**
     * The start time of the time entry
     */
    public TimeEntries withStartTime(JsonNullable<OffsetDateTime> startTime) {
        Utils.checkNotNull(startTime, "startTime");
        this.startTime = startTime;
        return this;
    }

    /**
     * The end time of the time entry
     */
    public TimeEntries withEndTime(OffsetDateTime endTime) {
        Utils.checkNotNull(endTime, "endTime");
        this.endTime = JsonNullable.of(endTime);
        return this;
    }

    /**
     * The end time of the time entry
     */
    public TimeEntries withEndTime(JsonNullable<OffsetDateTime> endTime) {
        Utils.checkNotNull(endTime, "endTime");
        this.endTime = endTime;
        return this;
    }

    /**
     * The hours worked in the time entry
     */
    public TimeEntries withHoursWorked(double hoursWorked) {
        Utils.checkNotNull(hoursWorked, "hoursWorked");
        this.hoursWorked = JsonNullable.of(hoursWorked);
        return this;
    }

    /**
     * The hours worked in the time entry
     */
    public TimeEntries withHoursWorked(JsonNullable<Double> hoursWorked) {
        Utils.checkNotNull(hoursWorked, "hoursWorked");
        this.hoursWorked = hoursWorked;
        return this;
    }

    /**
     * The duration of the break taken during time entry in hours
     */
    public TimeEntries withBreakDuration(double breakDuration) {
        Utils.checkNotNull(breakDuration, "breakDuration");
        this.breakDuration = JsonNullable.of(breakDuration);
        return this;
    }

    /**
     * The duration of the break taken during time entry in hours
     */
    public TimeEntries withBreakDuration(JsonNullable<Double> breakDuration) {
        Utils.checkNotNull(breakDuration, "breakDuration");
        this.breakDuration = breakDuration;
        return this;
    }

    /**
     * The status of the time entry
     */
    public TimeEntries withStatus(TimeEntriesStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = JsonNullable.of(status);
        return this;
    }

    /**
     * The status of the time entry
     */
    public TimeEntries withStatus(JsonNullable<? extends TimeEntriesStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * The labor type associated with this time entry
     */
    public TimeEntries withLaborType(LaborType laborType) {
        Utils.checkNotNull(laborType, "laborType");
        this.laborType = JsonNullable.of(laborType);
        return this;
    }

    /**
     * The labor type associated with this time entry
     */
    public TimeEntries withLaborType(JsonNullable<? extends LaborType> laborType) {
        Utils.checkNotNull(laborType, "laborType");
        this.laborType = laborType;
        return this;
    }

    /**
     * The location of the time entry
     */
    public TimeEntries withLocation(Location location) {
        Utils.checkNotNull(location, "location");
        this.location = JsonNullable.of(location);
        return this;
    }

    /**
     * The location of the time entry
     */
    public TimeEntries withLocation(JsonNullable<? extends Location> location) {
        Utils.checkNotNull(location, "location");
        this.location = location;
        return this;
    }

    /**
     * The created_at date
     */
    public TimeEntries withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The created_at date
     */
    public TimeEntries withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * The updated_at date
     */
    public TimeEntries withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * The updated_at date
     */
    public TimeEntries withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TimeEntries other = (TimeEntries) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.remoteId, other.remoteId) &&
            Objects.deepEquals(this.unifiedCustomFields, other.unifiedCustomFields) &&
            Objects.deepEquals(this.employeeId, other.employeeId) &&
            Objects.deepEquals(this.remoteEmployeeId, other.remoteEmployeeId) &&
            Objects.deepEquals(this.startTime, other.startTime) &&
            Objects.deepEquals(this.endTime, other.endTime) &&
            Objects.deepEquals(this.hoursWorked, other.hoursWorked) &&
            Objects.deepEquals(this.breakDuration, other.breakDuration) &&
            Objects.deepEquals(this.status, other.status) &&
            Objects.deepEquals(this.laborType, other.laborType) &&
            Objects.deepEquals(this.location, other.location) &&
            Objects.deepEquals(this.createdAt, other.createdAt) &&
            Objects.deepEquals(this.updatedAt, other.updatedAt);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            remoteId,
            unifiedCustomFields,
            employeeId,
            remoteEmployeeId,
            startTime,
            endTime,
            hoursWorked,
            breakDuration,
            status,
            laborType,
            location,
            createdAt,
            updatedAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TimeEntries.class,
                "id", id,
                "remoteId", remoteId,
                "unifiedCustomFields", unifiedCustomFields,
                "employeeId", employeeId,
                "remoteEmployeeId", remoteEmployeeId,
                "startTime", startTime,
                "endTime", endTime,
                "hoursWorked", hoursWorked,
                "breakDuration", breakDuration,
                "status", status,
                "laborType", laborType,
                "location", location,
                "createdAt", createdAt,
                "updatedAt", updatedAt);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> unifiedCustomFields = JsonNullable.undefined();
 
        private JsonNullable<String> employeeId = JsonNullable.undefined();
 
        private JsonNullable<String> remoteEmployeeId = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> startTime = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> endTime = JsonNullable.undefined();
 
        private JsonNullable<Double> hoursWorked = JsonNullable.undefined();
 
        private JsonNullable<Double> breakDuration = JsonNullable.undefined();
 
        private JsonNullable<? extends TimeEntriesStatus> status = JsonNullable.undefined();
 
        private JsonNullable<? extends LaborType> laborType = JsonNullable.undefined();
 
        private JsonNullable<? extends Location> location = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(Map<String, Object> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = unifiedCustomFields;
            return this;
        }

        /**
         * The employee ID associated with this time entry
         */
        public Builder employeeId(String employeeId) {
            Utils.checkNotNull(employeeId, "employeeId");
            this.employeeId = JsonNullable.of(employeeId);
            return this;
        }

        /**
         * The employee ID associated with this time entry
         */
        public Builder employeeId(JsonNullable<String> employeeId) {
            Utils.checkNotNull(employeeId, "employeeId");
            this.employeeId = employeeId;
            return this;
        }

        /**
         * Provider's unique identifier of the employee associated with this time entry
         */
        public Builder remoteEmployeeId(String remoteEmployeeId) {
            Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
            this.remoteEmployeeId = JsonNullable.of(remoteEmployeeId);
            return this;
        }

        /**
         * Provider's unique identifier of the employee associated with this time entry
         */
        public Builder remoteEmployeeId(JsonNullable<String> remoteEmployeeId) {
            Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
            this.remoteEmployeeId = remoteEmployeeId;
            return this;
        }

        /**
         * The start time of the time entry
         */
        public Builder startTime(OffsetDateTime startTime) {
            Utils.checkNotNull(startTime, "startTime");
            this.startTime = JsonNullable.of(startTime);
            return this;
        }

        /**
         * The start time of the time entry
         */
        public Builder startTime(JsonNullable<OffsetDateTime> startTime) {
            Utils.checkNotNull(startTime, "startTime");
            this.startTime = startTime;
            return this;
        }

        /**
         * The end time of the time entry
         */
        public Builder endTime(OffsetDateTime endTime) {
            Utils.checkNotNull(endTime, "endTime");
            this.endTime = JsonNullable.of(endTime);
            return this;
        }

        /**
         * The end time of the time entry
         */
        public Builder endTime(JsonNullable<OffsetDateTime> endTime) {
            Utils.checkNotNull(endTime, "endTime");
            this.endTime = endTime;
            return this;
        }

        /**
         * The hours worked in the time entry
         */
        public Builder hoursWorked(double hoursWorked) {
            Utils.checkNotNull(hoursWorked, "hoursWorked");
            this.hoursWorked = JsonNullable.of(hoursWorked);
            return this;
        }

        /**
         * The hours worked in the time entry
         */
        public Builder hoursWorked(JsonNullable<Double> hoursWorked) {
            Utils.checkNotNull(hoursWorked, "hoursWorked");
            this.hoursWorked = hoursWorked;
            return this;
        }

        /**
         * The duration of the break taken during time entry in hours
         */
        public Builder breakDuration(double breakDuration) {
            Utils.checkNotNull(breakDuration, "breakDuration");
            this.breakDuration = JsonNullable.of(breakDuration);
            return this;
        }

        /**
         * The duration of the break taken during time entry in hours
         */
        public Builder breakDuration(JsonNullable<Double> breakDuration) {
            Utils.checkNotNull(breakDuration, "breakDuration");
            this.breakDuration = breakDuration;
            return this;
        }

        /**
         * The status of the time entry
         */
        public Builder status(TimeEntriesStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = JsonNullable.of(status);
            return this;
        }

        /**
         * The status of the time entry
         */
        public Builder status(JsonNullable<? extends TimeEntriesStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        /**
         * The labor type associated with this time entry
         */
        public Builder laborType(LaborType laborType) {
            Utils.checkNotNull(laborType, "laborType");
            this.laborType = JsonNullable.of(laborType);
            return this;
        }

        /**
         * The labor type associated with this time entry
         */
        public Builder laborType(JsonNullable<? extends LaborType> laborType) {
            Utils.checkNotNull(laborType, "laborType");
            this.laborType = laborType;
            return this;
        }

        /**
         * The location of the time entry
         */
        public Builder location(Location location) {
            Utils.checkNotNull(location, "location");
            this.location = JsonNullable.of(location);
            return this;
        }

        /**
         * The location of the time entry
         */
        public Builder location(JsonNullable<? extends Location> location) {
            Utils.checkNotNull(location, "location");
            this.location = location;
            return this;
        }

        /**
         * The created_at date
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The created_at date
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        /**
         * The updated_at date
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * The updated_at date
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }
        
        public TimeEntries build() {
            return new TimeEntries(
                id,
                remoteId,
                unifiedCustomFields,
                employeeId,
                remoteEmployeeId,
                startTime,
                endTime,
                hoursWorked,
                breakDuration,
                status,
                laborType,
                location,
                createdAt,
                updatedAt);
        }
    }
}

