/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * BaseCurrency
 * 
 * <p>Default currency for the company
 */
public class BaseCurrency {
    /**
     * Default currency for the company
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends AccountingCompanyValue> value;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends AccountingCompanySourceValue> sourceValue;

    @JsonCreator
    public BaseCurrency(
            @JsonProperty("value") JsonNullable<? extends AccountingCompanyValue> value,
            @JsonProperty("source_value") JsonNullable<? extends AccountingCompanySourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public BaseCurrency() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Default currency for the company
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AccountingCompanyValue> value() {
        return (JsonNullable<AccountingCompanyValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AccountingCompanySourceValue> sourceValue() {
        return (JsonNullable<AccountingCompanySourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Default currency for the company
     */
    public BaseCurrency withValue(AccountingCompanyValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * Default currency for the company
     */
    public BaseCurrency withValue(JsonNullable<? extends AccountingCompanyValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public BaseCurrency withSourceValue(AccountingCompanySourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public BaseCurrency withSourceValue(JsonNullable<? extends AccountingCompanySourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseCurrency other = (BaseCurrency) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(BaseCurrency.class,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends AccountingCompanyValue> value = JsonNullable.undefined();

        private JsonNullable<? extends AccountingCompanySourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Default currency for the company
         */
        public Builder value(AccountingCompanyValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * Default currency for the company
         */
        public Builder value(JsonNullable<? extends AccountingCompanyValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        public Builder sourceValue(AccountingCompanySourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends AccountingCompanySourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public BaseCurrency build() {

            return new BaseCurrency(
                value, sourceValue);
        }

    }
}
