/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * CurrencyCode
 * 
 * <p>Currency code for the journal and all lines
 */
public class CurrencyCode {
    /**
     * Default currency for the company
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends AccountingJournalCreateRequestDtoValue> value;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends AccountingJournalCreateRequestDtoSourceValue> sourceValue;

    @JsonCreator
    public CurrencyCode(
            @JsonProperty("value") JsonNullable<? extends AccountingJournalCreateRequestDtoValue> value,
            @JsonProperty("source_value") JsonNullable<? extends AccountingJournalCreateRequestDtoSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public CurrencyCode() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Default currency for the company
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AccountingJournalCreateRequestDtoValue> value() {
        return (JsonNullable<AccountingJournalCreateRequestDtoValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AccountingJournalCreateRequestDtoSourceValue> sourceValue() {
        return (JsonNullable<AccountingJournalCreateRequestDtoSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Default currency for the company
     */
    public CurrencyCode withValue(AccountingJournalCreateRequestDtoValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * Default currency for the company
     */
    public CurrencyCode withValue(JsonNullable<? extends AccountingJournalCreateRequestDtoValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public CurrencyCode withSourceValue(AccountingJournalCreateRequestDtoSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public CurrencyCode withSourceValue(JsonNullable<? extends AccountingJournalCreateRequestDtoSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CurrencyCode other = (CurrencyCode) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CurrencyCode.class,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends AccountingJournalCreateRequestDtoValue> value = JsonNullable.undefined();

        private JsonNullable<? extends AccountingJournalCreateRequestDtoSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Default currency for the company
         */
        public Builder value(AccountingJournalCreateRequestDtoValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * Default currency for the company
         */
        public Builder value(JsonNullable<? extends AccountingJournalCreateRequestDtoValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        public Builder sourceValue(AccountingJournalCreateRequestDtoSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends AccountingJournalCreateRequestDtoSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public CurrencyCode build() {

            return new CurrencyCode(
                value, sourceValue);
        }

    }
}
