/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.CrmListContactsRequest;
import com.stackone.stackone_client_java.models.operations.CrmListContactsResponse;
import com.stackone.stackone_client_java.operations.CrmListContacts;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class CrmListContactsRequestBuilder {
    private CrmListContactsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public CrmListContactsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CrmListContactsRequestBuilder request(CrmListContactsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public CrmListContactsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public CrmListContactsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CrmListContactsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        CrmListContacts.Sync operation = new CrmListContacts.Sync(this.sdkConfiguration, options);
        return (CrmListContactsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<CrmListContactsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        CrmListContacts.Sync operation = new CrmListContacts.Sync(this.sdkConfiguration, options);
        Paginator<CrmListContactsRequest, String> iterator = new Paginator<CrmListContactsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), CrmListContactsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<CrmListContactsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

