/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;


public class AtsDocumentApiModel {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * The name of the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * The path where the file is stored
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("path")
    private JsonNullable<String> path;

    /**
     * The category of the the document
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("category")
    private JsonNullable<? extends AtsDocumentApiModelCategory> category;

    /**
     * The content of the file. Deprecated, use `url` and `file_format` one level up instead
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("contents")
    @Deprecated
    private JsonNullable<? extends List<Content>> contents;

    /**
     * The categoryId of the documents
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("category_id")
    private JsonNullable<String> categoryId;

    /**
     * The creation date of the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * The update date of the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    /**
     * URL where the file content is located
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_url")
    private JsonNullable<String> remoteUrl;

    /**
     * The file format of the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("file_format")
    private JsonNullable<? extends AtsDocumentApiModelFileFormat> fileFormat;

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unified_custom_fields")
    private JsonNullable<? extends Map<String, Object>> unifiedCustomFields;

    /**
     * The content type of the document
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    @Deprecated
    private JsonNullable<? extends AtsDocumentApiModelType> type;

    @JsonCreator
    public AtsDocumentApiModel(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("path") JsonNullable<String> path,
            @JsonProperty("category") JsonNullable<? extends AtsDocumentApiModelCategory> category,
            @JsonProperty("contents") JsonNullable<? extends List<Content>> contents,
            @JsonProperty("category_id") JsonNullable<String> categoryId,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt,
            @JsonProperty("remote_url") JsonNullable<String> remoteUrl,
            @JsonProperty("file_format") JsonNullable<? extends AtsDocumentApiModelFileFormat> fileFormat,
            @JsonProperty("unified_custom_fields") JsonNullable<? extends Map<String, Object>> unifiedCustomFields,
            @JsonProperty("type") JsonNullable<? extends AtsDocumentApiModelType> type) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(path, "path");
        Utils.checkNotNull(category, "category");
        Utils.checkNotNull(contents, "contents");
        Utils.checkNotNull(categoryId, "categoryId");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(remoteUrl, "remoteUrl");
        Utils.checkNotNull(fileFormat, "fileFormat");
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        Utils.checkNotNull(type, "type");
        this.id = id;
        this.remoteId = remoteId;
        this.name = name;
        this.path = path;
        this.category = category;
        this.contents = contents;
        this.categoryId = categoryId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.remoteUrl = remoteUrl;
        this.fileFormat = fileFormat;
        this.unifiedCustomFields = unifiedCustomFields;
        this.type = type;
    }
    
    public AtsDocumentApiModel() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * The name of the file
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * The path where the file is stored
     */
    @JsonIgnore
    public JsonNullable<String> path() {
        return path;
    }

    /**
     * The category of the the document
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AtsDocumentApiModelCategory> category() {
        return (JsonNullable<AtsDocumentApiModelCategory>) category;
    }

    /**
     * The content of the file. Deprecated, use `url` and `file_format` one level up instead
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<Content>> contents() {
        return (JsonNullable<List<Content>>) contents;
    }

    /**
     * The categoryId of the documents
     */
    @JsonIgnore
    public JsonNullable<String> categoryId() {
        return categoryId;
    }

    /**
     * The creation date of the file
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * The update date of the file
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    /**
     * URL where the file content is located
     */
    @JsonIgnore
    public JsonNullable<String> remoteUrl() {
        return remoteUrl;
    }

    /**
     * The file format of the file
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AtsDocumentApiModelFileFormat> fileFormat() {
        return (JsonNullable<AtsDocumentApiModelFileFormat>) fileFormat;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> unifiedCustomFields() {
        return (JsonNullable<Map<String, Object>>) unifiedCustomFields;
    }

    /**
     * The content type of the document
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AtsDocumentApiModelType> type() {
        return (JsonNullable<AtsDocumentApiModelType>) type;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public AtsDocumentApiModel withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public AtsDocumentApiModel withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public AtsDocumentApiModel withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public AtsDocumentApiModel withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * The name of the file
     */
    public AtsDocumentApiModel withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * The name of the file
     */
    public AtsDocumentApiModel withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * The path where the file is stored
     */
    public AtsDocumentApiModel withPath(String path) {
        Utils.checkNotNull(path, "path");
        this.path = JsonNullable.of(path);
        return this;
    }

    /**
     * The path where the file is stored
     */
    public AtsDocumentApiModel withPath(JsonNullable<String> path) {
        Utils.checkNotNull(path, "path");
        this.path = path;
        return this;
    }

    /**
     * The category of the the document
     */
    public AtsDocumentApiModel withCategory(AtsDocumentApiModelCategory category) {
        Utils.checkNotNull(category, "category");
        this.category = JsonNullable.of(category);
        return this;
    }

    /**
     * The category of the the document
     */
    public AtsDocumentApiModel withCategory(JsonNullable<? extends AtsDocumentApiModelCategory> category) {
        Utils.checkNotNull(category, "category");
        this.category = category;
        return this;
    }

    /**
     * The content of the file. Deprecated, use `url` and `file_format` one level up instead
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public AtsDocumentApiModel withContents(List<Content> contents) {
        Utils.checkNotNull(contents, "contents");
        this.contents = JsonNullable.of(contents);
        return this;
    }

    /**
     * The content of the file. Deprecated, use `url` and `file_format` one level up instead
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public AtsDocumentApiModel withContents(JsonNullable<? extends List<Content>> contents) {
        Utils.checkNotNull(contents, "contents");
        this.contents = contents;
        return this;
    }

    /**
     * The categoryId of the documents
     */
    public AtsDocumentApiModel withCategoryId(String categoryId) {
        Utils.checkNotNull(categoryId, "categoryId");
        this.categoryId = JsonNullable.of(categoryId);
        return this;
    }

    /**
     * The categoryId of the documents
     */
    public AtsDocumentApiModel withCategoryId(JsonNullable<String> categoryId) {
        Utils.checkNotNull(categoryId, "categoryId");
        this.categoryId = categoryId;
        return this;
    }

    /**
     * The creation date of the file
     */
    public AtsDocumentApiModel withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The creation date of the file
     */
    public AtsDocumentApiModel withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * The update date of the file
     */
    public AtsDocumentApiModel withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * The update date of the file
     */
    public AtsDocumentApiModel withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    /**
     * URL where the file content is located
     */
    public AtsDocumentApiModel withRemoteUrl(String remoteUrl) {
        Utils.checkNotNull(remoteUrl, "remoteUrl");
        this.remoteUrl = JsonNullable.of(remoteUrl);
        return this;
    }

    /**
     * URL where the file content is located
     */
    public AtsDocumentApiModel withRemoteUrl(JsonNullable<String> remoteUrl) {
        Utils.checkNotNull(remoteUrl, "remoteUrl");
        this.remoteUrl = remoteUrl;
        return this;
    }

    /**
     * The file format of the file
     */
    public AtsDocumentApiModel withFileFormat(AtsDocumentApiModelFileFormat fileFormat) {
        Utils.checkNotNull(fileFormat, "fileFormat");
        this.fileFormat = JsonNullable.of(fileFormat);
        return this;
    }

    /**
     * The file format of the file
     */
    public AtsDocumentApiModel withFileFormat(JsonNullable<? extends AtsDocumentApiModelFileFormat> fileFormat) {
        Utils.checkNotNull(fileFormat, "fileFormat");
        this.fileFormat = fileFormat;
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public AtsDocumentApiModel withUnifiedCustomFields(Map<String, Object> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public AtsDocumentApiModel withUnifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = unifiedCustomFields;
        return this;
    }

    /**
     * The content type of the document
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public AtsDocumentApiModel withType(AtsDocumentApiModelType type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of(type);
        return this;
    }

    /**
     * The content type of the document
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public AtsDocumentApiModel withType(JsonNullable<? extends AtsDocumentApiModelType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AtsDocumentApiModel other = (AtsDocumentApiModel) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.path, other.path) &&
            Utils.enhancedDeepEquals(this.category, other.category) &&
            Utils.enhancedDeepEquals(this.contents, other.contents) &&
            Utils.enhancedDeepEquals(this.categoryId, other.categoryId) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt) &&
            Utils.enhancedDeepEquals(this.remoteUrl, other.remoteUrl) &&
            Utils.enhancedDeepEquals(this.fileFormat, other.fileFormat) &&
            Utils.enhancedDeepEquals(this.unifiedCustomFields, other.unifiedCustomFields) &&
            Utils.enhancedDeepEquals(this.type, other.type);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, name,
            path, category, contents,
            categoryId, createdAt, updatedAt,
            remoteUrl, fileFormat, unifiedCustomFields,
            type);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AtsDocumentApiModel.class,
                "id", id,
                "remoteId", remoteId,
                "name", name,
                "path", path,
                "category", category,
                "contents", contents,
                "categoryId", categoryId,
                "createdAt", createdAt,
                "updatedAt", updatedAt,
                "remoteUrl", remoteUrl,
                "fileFormat", fileFormat,
                "unifiedCustomFields", unifiedCustomFields,
                "type", type);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<String> name = JsonNullable.undefined();

        private JsonNullable<String> path = JsonNullable.undefined();

        private JsonNullable<? extends AtsDocumentApiModelCategory> category = JsonNullable.undefined();

        @Deprecated
        private JsonNullable<? extends List<Content>> contents = JsonNullable.undefined();

        private JsonNullable<String> categoryId = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();

        private JsonNullable<String> remoteUrl = JsonNullable.undefined();

        private JsonNullable<? extends AtsDocumentApiModelFileFormat> fileFormat = JsonNullable.undefined();

        private JsonNullable<? extends Map<String, Object>> unifiedCustomFields = JsonNullable.undefined();

        @Deprecated
        private JsonNullable<? extends AtsDocumentApiModelType> type = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * The name of the file
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * The name of the file
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }


        /**
         * The path where the file is stored
         */
        public Builder path(String path) {
            Utils.checkNotNull(path, "path");
            this.path = JsonNullable.of(path);
            return this;
        }

        /**
         * The path where the file is stored
         */
        public Builder path(JsonNullable<String> path) {
            Utils.checkNotNull(path, "path");
            this.path = path;
            return this;
        }


        /**
         * The category of the the document
         */
        public Builder category(AtsDocumentApiModelCategory category) {
            Utils.checkNotNull(category, "category");
            this.category = JsonNullable.of(category);
            return this;
        }

        /**
         * The category of the the document
         */
        public Builder category(JsonNullable<? extends AtsDocumentApiModelCategory> category) {
            Utils.checkNotNull(category, "category");
            this.category = category;
            return this;
        }


        /**
         * The content of the file. Deprecated, use `url` and `file_format` one level up instead
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder contents(List<Content> contents) {
            Utils.checkNotNull(contents, "contents");
            this.contents = JsonNullable.of(contents);
            return this;
        }

        /**
         * The content of the file. Deprecated, use `url` and `file_format` one level up instead
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder contents(JsonNullable<? extends List<Content>> contents) {
            Utils.checkNotNull(contents, "contents");
            this.contents = contents;
            return this;
        }


        /**
         * The categoryId of the documents
         */
        public Builder categoryId(String categoryId) {
            Utils.checkNotNull(categoryId, "categoryId");
            this.categoryId = JsonNullable.of(categoryId);
            return this;
        }

        /**
         * The categoryId of the documents
         */
        public Builder categoryId(JsonNullable<String> categoryId) {
            Utils.checkNotNull(categoryId, "categoryId");
            this.categoryId = categoryId;
            return this;
        }


        /**
         * The creation date of the file
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The creation date of the file
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }


        /**
         * The update date of the file
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * The update date of the file
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }


        /**
         * URL where the file content is located
         */
        public Builder remoteUrl(String remoteUrl) {
            Utils.checkNotNull(remoteUrl, "remoteUrl");
            this.remoteUrl = JsonNullable.of(remoteUrl);
            return this;
        }

        /**
         * URL where the file content is located
         */
        public Builder remoteUrl(JsonNullable<String> remoteUrl) {
            Utils.checkNotNull(remoteUrl, "remoteUrl");
            this.remoteUrl = remoteUrl;
            return this;
        }


        /**
         * The file format of the file
         */
        public Builder fileFormat(AtsDocumentApiModelFileFormat fileFormat) {
            Utils.checkNotNull(fileFormat, "fileFormat");
            this.fileFormat = JsonNullable.of(fileFormat);
            return this;
        }

        /**
         * The file format of the file
         */
        public Builder fileFormat(JsonNullable<? extends AtsDocumentApiModelFileFormat> fileFormat) {
            Utils.checkNotNull(fileFormat, "fileFormat");
            this.fileFormat = fileFormat;
            return this;
        }


        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(Map<String, Object> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = unifiedCustomFields;
            return this;
        }


        /**
         * The content type of the document
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder type(AtsDocumentApiModelType type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of(type);
            return this;
        }

        /**
         * The content type of the document
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder type(JsonNullable<? extends AtsDocumentApiModelType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }

        public AtsDocumentApiModel build() {

            return new AtsDocumentApiModel(
                id, remoteId, name,
                path, category, contents,
                categoryId, createdAt, updatedAt,
                remoteUrl, fileFormat, unifiedCustomFields,
                type);
        }

    }
}
