/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.LmsListAssignmentsRequest;
import com.stackone.stackone_client_java.models.operations.LmsListAssignmentsResponse;
import com.stackone.stackone_client_java.operations.LmsListAssignments;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class LmsListAssignmentsRequestBuilder {
    private LmsListAssignmentsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public LmsListAssignmentsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public LmsListAssignmentsRequestBuilder request(LmsListAssignmentsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public LmsListAssignmentsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public LmsListAssignmentsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public LmsListAssignmentsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        LmsListAssignments.Sync operation = new LmsListAssignments.Sync(this.sdkConfiguration, options);
        return (LmsListAssignmentsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<LmsListAssignmentsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        LmsListAssignments.Sync operation = new LmsListAssignments.Sync(this.sdkConfiguration, options);
        Paginator<LmsListAssignmentsRequest, String> iterator = new Paginator<LmsListAssignmentsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), LmsListAssignmentsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<LmsListAssignmentsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

