/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.models.components.PatchAccountExternalDto;
import com.stackone.stackone_client_java.models.operations.StackoneDeleteAccountRequest;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountMetaInfoRequest;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountRequest;
import com.stackone.stackone_client_java.models.operations.StackoneListLinkedAccountsRequest;
import com.stackone.stackone_client_java.models.operations.StackoneUpdateAccountRequest;
import com.stackone.stackone_client_java.models.operations.async.StackoneDeleteAccountRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneDeleteAccountResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneGetAccountMetaInfoRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneGetAccountMetaInfoResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneGetAccountRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneGetAccountResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneListLinkedAccountsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneListLinkedAccountsResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneUpdateAccountRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneUpdateAccountResponse;
import com.stackone.stackone_client_java.operations.StackoneDeleteAccount;
import com.stackone.stackone_client_java.operations.StackoneGetAccount;
import com.stackone.stackone_client_java.operations.StackoneGetAccountMetaInfo;
import com.stackone.stackone_client_java.operations.StackoneListLinkedAccounts;
import com.stackone.stackone_client_java.operations.StackoneUpdateAccount;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

/**
 * Chart of accounts.
 */
public class AsyncAccounts {
    private final SDKConfiguration sdkConfiguration;
    private final Accounts syncSDK;

    AsyncAccounts(Accounts syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    /**
     * Switches to the sync SDK.
     * 
     * @return The sync SDK
     */
    public Accounts sync() {
        return syncSDK;
    }


    /**
     * List Accounts
     * 
     * @return The async call builder
     */
    public StackoneListLinkedAccountsRequestBuilder listLinkedAccounts() {
        return new StackoneListLinkedAccountsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Accounts
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;StackoneListLinkedAccountsResponse&gt; - The async response
     */
    public CompletableFuture<StackoneListLinkedAccountsResponse> listLinkedAccounts(StackoneListLinkedAccountsRequest request) {
        return listLinkedAccounts(request, Optional.empty());
    }

    /**
     * List Accounts
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;StackoneListLinkedAccountsResponse&gt; - The async response
     */
    public CompletableFuture<StackoneListLinkedAccountsResponse> listLinkedAccounts(StackoneListLinkedAccountsRequest request, Optional<Options> options) {
        AsyncRequestOperation<StackoneListLinkedAccountsRequest, StackoneListLinkedAccountsResponse> operation
              = new StackoneListLinkedAccounts.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Account
     * 
     * @return The async call builder
     */
    public StackoneGetAccountRequestBuilder getAccount() {
        return new StackoneGetAccountRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Account
     * 
     * @param id 
     * @return CompletableFuture&lt;StackoneGetAccountResponse&gt; - The async response
     */
    public CompletableFuture<StackoneGetAccountResponse> getAccount(String id) {
        return getAccount(id, Optional.empty());
    }

    /**
     * Get Account
     * 
     * @param id 
     * @param options additional options
     * @return CompletableFuture&lt;StackoneGetAccountResponse&gt; - The async response
     */
    public CompletableFuture<StackoneGetAccountResponse> getAccount(String id, Optional<Options> options) {
        StackoneGetAccountRequest request =
            StackoneGetAccountRequest
                .builder()
                .id(id)
                .build();
        AsyncRequestOperation<StackoneGetAccountRequest, StackoneGetAccountResponse> operation
              = new StackoneGetAccount.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Delete Account
     * 
     * @return The async call builder
     */
    public StackoneDeleteAccountRequestBuilder deleteAccount() {
        return new StackoneDeleteAccountRequestBuilder(sdkConfiguration);
    }

    /**
     * Delete Account
     * 
     * @param id 
     * @return CompletableFuture&lt;StackoneDeleteAccountResponse&gt; - The async response
     */
    public CompletableFuture<StackoneDeleteAccountResponse> deleteAccount(String id) {
        return deleteAccount(id, Optional.empty());
    }

    /**
     * Delete Account
     * 
     * @param id 
     * @param options additional options
     * @return CompletableFuture&lt;StackoneDeleteAccountResponse&gt; - The async response
     */
    public CompletableFuture<StackoneDeleteAccountResponse> deleteAccount(String id, Optional<Options> options) {
        StackoneDeleteAccountRequest request =
            StackoneDeleteAccountRequest
                .builder()
                .id(id)
                .build();
        AsyncRequestOperation<StackoneDeleteAccountRequest, StackoneDeleteAccountResponse> operation
              = new StackoneDeleteAccount.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Update Account
     * 
     * @return The async call builder
     */
    public StackoneUpdateAccountRequestBuilder updateAccount() {
        return new StackoneUpdateAccountRequestBuilder(sdkConfiguration);
    }

    /**
     * Update Account
     * 
     * @param id 
     * @param patchAccountExternalDto 
     * @return CompletableFuture&lt;StackoneUpdateAccountResponse&gt; - The async response
     */
    public CompletableFuture<StackoneUpdateAccountResponse> updateAccount(String id, PatchAccountExternalDto patchAccountExternalDto) {
        return updateAccount(id, patchAccountExternalDto, Optional.empty());
    }

    /**
     * Update Account
     * 
     * @param id 
     * @param patchAccountExternalDto 
     * @param options additional options
     * @return CompletableFuture&lt;StackoneUpdateAccountResponse&gt; - The async response
     */
    public CompletableFuture<StackoneUpdateAccountResponse> updateAccount(
            String id, PatchAccountExternalDto patchAccountExternalDto,
            Optional<Options> options) {
        StackoneUpdateAccountRequest request =
            StackoneUpdateAccountRequest
                .builder()
                .id(id)
                .patchAccountExternalDto(patchAccountExternalDto)
                .build();
        AsyncRequestOperation<StackoneUpdateAccountRequest, StackoneUpdateAccountResponse> operation
              = new StackoneUpdateAccount.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Account Meta Information
     * 
     * @return The async call builder
     */
    public StackoneGetAccountMetaInfoRequestBuilder getAccountMetaInfo() {
        return new StackoneGetAccountMetaInfoRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Account Meta Information
     * 
     * @param id 
     * @return CompletableFuture&lt;StackoneGetAccountMetaInfoResponse&gt; - The async response
     */
    public CompletableFuture<StackoneGetAccountMetaInfoResponse> getAccountMetaInfo(String id) {
        return getAccountMetaInfo(id, Optional.empty());
    }

    /**
     * Get Account Meta Information
     * 
     * @param id 
     * @param options additional options
     * @return CompletableFuture&lt;StackoneGetAccountMetaInfoResponse&gt; - The async response
     */
    public CompletableFuture<StackoneGetAccountMetaInfoResponse> getAccountMetaInfo(String id, Optional<Options> options) {
        StackoneGetAccountMetaInfoRequest request =
            StackoneGetAccountMetaInfoRequest
                .builder()
                .id(id)
                .build();
        AsyncRequestOperation<StackoneGetAccountMetaInfoRequest, StackoneGetAccountMetaInfoResponse> operation
              = new StackoneGetAccountMetaInfo.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

}
