/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.models.components.TicketingTicketCreateRequestDto;
import com.stackone.stackone_client_java.models.components.TicketingTicketUpdateRequestDto;
import com.stackone.stackone_client_java.models.operations.TicketingCreateTicketRequest;
import com.stackone.stackone_client_java.models.operations.TicketingDownloadTicketingAttachmentRequest;
import com.stackone.stackone_client_java.models.operations.TicketingGetAttachmentRequest;
import com.stackone.stackone_client_java.models.operations.TicketingGetCommentRequest;
import com.stackone.stackone_client_java.models.operations.TicketingGetProjectComponentRequest;
import com.stackone.stackone_client_java.models.operations.TicketingGetProjectRequest;
import com.stackone.stackone_client_java.models.operations.TicketingGetTicketRequest;
import com.stackone.stackone_client_java.models.operations.TicketingGetTicketTypeRequest;
import com.stackone.stackone_client_java.models.operations.TicketingGetUserRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListAttachmentsRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListCommentsRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListProjectComponentsRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListProjectTicketTypesRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListProjectsRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListTicketStatusesRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListTicketTypesRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListTicketsRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListUsersRequest;
import com.stackone.stackone_client_java.models.operations.TicketingUpdateTicketRequest;
import com.stackone.stackone_client_java.models.operations.async.TicketingCreateTicketRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.TicketingCreateTicketResponse;
import com.stackone.stackone_client_java.models.operations.async.TicketingDownloadTicketingAttachmentRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.TicketingDownloadTicketingAttachmentResponse;
import com.stackone.stackone_client_java.models.operations.async.TicketingGetAttachmentRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.TicketingGetAttachmentResponse;
import com.stackone.stackone_client_java.models.operations.async.TicketingGetCommentRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.TicketingGetCommentResponse;
import com.stackone.stackone_client_java.models.operations.async.TicketingGetProjectComponentRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.TicketingGetProjectComponentResponse;
import com.stackone.stackone_client_java.models.operations.async.TicketingGetProjectRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.TicketingGetProjectResponse;
import com.stackone.stackone_client_java.models.operations.async.TicketingGetTicketRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.TicketingGetTicketResponse;
import com.stackone.stackone_client_java.models.operations.async.TicketingGetTicketTypeRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.TicketingGetTicketTypeResponse;
import com.stackone.stackone_client_java.models.operations.async.TicketingGetUserRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.TicketingGetUserResponse;
import com.stackone.stackone_client_java.models.operations.async.TicketingListAttachmentsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.TicketingListAttachmentsResponse;
import com.stackone.stackone_client_java.models.operations.async.TicketingListCommentsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.TicketingListCommentsResponse;
import com.stackone.stackone_client_java.models.operations.async.TicketingListProjectComponentsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.TicketingListProjectComponentsResponse;
import com.stackone.stackone_client_java.models.operations.async.TicketingListProjectTicketTypesRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.TicketingListProjectTicketTypesResponse;
import com.stackone.stackone_client_java.models.operations.async.TicketingListProjectsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.TicketingListProjectsResponse;
import com.stackone.stackone_client_java.models.operations.async.TicketingListTicketStatusesRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.TicketingListTicketStatusesResponse;
import com.stackone.stackone_client_java.models.operations.async.TicketingListTicketTypesRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.TicketingListTicketTypesResponse;
import com.stackone.stackone_client_java.models.operations.async.TicketingListTicketsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.TicketingListTicketsResponse;
import com.stackone.stackone_client_java.models.operations.async.TicketingListUsersRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.TicketingListUsersResponse;
import com.stackone.stackone_client_java.models.operations.async.TicketingUpdateTicketRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.TicketingUpdateTicketResponse;
import com.stackone.stackone_client_java.operations.TicketingCreateTicket;
import com.stackone.stackone_client_java.operations.TicketingDownloadTicketingAttachment;
import com.stackone.stackone_client_java.operations.TicketingGetAttachment;
import com.stackone.stackone_client_java.operations.TicketingGetComment;
import com.stackone.stackone_client_java.operations.TicketingGetProject;
import com.stackone.stackone_client_java.operations.TicketingGetProjectComponent;
import com.stackone.stackone_client_java.operations.TicketingGetTicket;
import com.stackone.stackone_client_java.operations.TicketingGetTicketType;
import com.stackone.stackone_client_java.operations.TicketingGetUser;
import com.stackone.stackone_client_java.operations.TicketingListAttachments;
import com.stackone.stackone_client_java.operations.TicketingListComments;
import com.stackone.stackone_client_java.operations.TicketingListProjectComponents;
import com.stackone.stackone_client_java.operations.TicketingListProjectTicketTypes;
import com.stackone.stackone_client_java.operations.TicketingListProjects;
import com.stackone.stackone_client_java.operations.TicketingListTicketStatuses;
import com.stackone.stackone_client_java.operations.TicketingListTicketTypes;
import com.stackone.stackone_client_java.operations.TicketingListTickets;
import com.stackone.stackone_client_java.operations.TicketingListUsers;
import com.stackone.stackone_client_java.operations.TicketingUpdateTicket;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;


public class AsyncTicketing {
    private final SDKConfiguration sdkConfiguration;
    private final Ticketing syncSDK;

    AsyncTicketing(Ticketing syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    /**
     * Switches to the sync SDK.
     * 
     * @return The sync SDK
     */
    public Ticketing sync() {
        return syncSDK;
    }


    /**
     * List Tickets
     * 
     * <p>Retrieve a paginated list of tickets.
     * 
     * @return The async call builder
     */
    public TicketingListTicketsRequestBuilder listTickets() {
        return new TicketingListTicketsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Tickets
     * 
     * <p>Retrieve a paginated list of tickets.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;TicketingListTicketsResponse&gt; - The async response
     */
    public CompletableFuture<TicketingListTicketsResponse> listTickets(TicketingListTicketsRequest request) {
        return listTickets(request, Optional.empty());
    }

    /**
     * List Tickets
     * 
     * <p>Retrieve a paginated list of tickets.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;TicketingListTicketsResponse&gt; - The async response
     */
    public CompletableFuture<TicketingListTicketsResponse> listTickets(TicketingListTicketsRequest request, Optional<Options> options) {
        AsyncRequestOperation<TicketingListTicketsRequest, TicketingListTicketsResponse> operation
              = new TicketingListTickets.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Create Ticket
     * 
     * <p>Create a new ticket record.
     * 
     * @return The async call builder
     */
    public TicketingCreateTicketRequestBuilder createTicket() {
        return new TicketingCreateTicketRequestBuilder(sdkConfiguration);
    }

    /**
     * Create Ticket
     * 
     * <p>Create a new ticket record.
     * 
     * @param xAccountId The account identifier
     * @param ticketingTicketCreateRequestDto 
     * @return CompletableFuture&lt;TicketingCreateTicketResponse&gt; - The async response
     */
    public CompletableFuture<TicketingCreateTicketResponse> createTicket(String xAccountId, TicketingTicketCreateRequestDto ticketingTicketCreateRequestDto) {
        return createTicket(xAccountId, ticketingTicketCreateRequestDto, Optional.empty());
    }

    /**
     * Create Ticket
     * 
     * <p>Create a new ticket record.
     * 
     * @param xAccountId The account identifier
     * @param ticketingTicketCreateRequestDto 
     * @param options additional options
     * @return CompletableFuture&lt;TicketingCreateTicketResponse&gt; - The async response
     */
    public CompletableFuture<TicketingCreateTicketResponse> createTicket(
            String xAccountId, TicketingTicketCreateRequestDto ticketingTicketCreateRequestDto,
            Optional<Options> options) {
        TicketingCreateTicketRequest request =
            TicketingCreateTicketRequest
                .builder()
                .xAccountId(xAccountId)
                .ticketingTicketCreateRequestDto(ticketingTicketCreateRequestDto)
                .build();
        AsyncRequestOperation<TicketingCreateTicketRequest, TicketingCreateTicketResponse> operation
              = new TicketingCreateTicket.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Ticket
     * 
     * <p>Retrieve a single ticket by its identifier.
     * 
     * @return The async call builder
     */
    public TicketingGetTicketRequestBuilder getTicket() {
        return new TicketingGetTicketRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Ticket
     * 
     * <p>Retrieve a single ticket by its identifier.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;TicketingGetTicketResponse&gt; - The async response
     */
    public CompletableFuture<TicketingGetTicketResponse> getTicket(TicketingGetTicketRequest request) {
        return getTicket(request, Optional.empty());
    }

    /**
     * Get Ticket
     * 
     * <p>Retrieve a single ticket by its identifier.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;TicketingGetTicketResponse&gt; - The async response
     */
    public CompletableFuture<TicketingGetTicketResponse> getTicket(TicketingGetTicketRequest request, Optional<Options> options) {
        AsyncRequestOperation<TicketingGetTicketRequest, TicketingGetTicketResponse> operation
              = new TicketingGetTicket.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Update Ticket
     * 
     * <p>Update an existing ticket record by its identifier.
     * 
     * @return The async call builder
     */
    public TicketingUpdateTicketRequestBuilder updateTicket() {
        return new TicketingUpdateTicketRequestBuilder(sdkConfiguration);
    }

    /**
     * Update Ticket
     * 
     * <p>Update an existing ticket record by its identifier.
     * 
     * @param xAccountId The account identifier
     * @param id 
     * @param ticketingTicketUpdateRequestDto 
     * @return CompletableFuture&lt;TicketingUpdateTicketResponse&gt; - The async response
     */
    public CompletableFuture<TicketingUpdateTicketResponse> updateTicket(
            String xAccountId, String id,
            TicketingTicketUpdateRequestDto ticketingTicketUpdateRequestDto) {
        return updateTicket(
                xAccountId, id, ticketingTicketUpdateRequestDto,
                Optional.empty());
    }

    /**
     * Update Ticket
     * 
     * <p>Update an existing ticket record by its identifier.
     * 
     * @param xAccountId The account identifier
     * @param id 
     * @param ticketingTicketUpdateRequestDto 
     * @param options additional options
     * @return CompletableFuture&lt;TicketingUpdateTicketResponse&gt; - The async response
     */
    public CompletableFuture<TicketingUpdateTicketResponse> updateTicket(
            String xAccountId, String id,
            TicketingTicketUpdateRequestDto ticketingTicketUpdateRequestDto, Optional<Options> options) {
        TicketingUpdateTicketRequest request =
            TicketingUpdateTicketRequest
                .builder()
                .xAccountId(xAccountId)
                .id(id)
                .ticketingTicketUpdateRequestDto(ticketingTicketUpdateRequestDto)
                .build();
        AsyncRequestOperation<TicketingUpdateTicketRequest, TicketingUpdateTicketResponse> operation
              = new TicketingUpdateTicket.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Users
     * 
     * <p>Retrieve a paginated list of users.
     * 
     * @return The async call builder
     */
    public TicketingListUsersRequestBuilder listUsers() {
        return new TicketingListUsersRequestBuilder(sdkConfiguration);
    }

    /**
     * List Users
     * 
     * <p>Retrieve a paginated list of users.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;TicketingListUsersResponse&gt; - The async response
     */
    public CompletableFuture<TicketingListUsersResponse> listUsers(TicketingListUsersRequest request) {
        return listUsers(request, Optional.empty());
    }

    /**
     * List Users
     * 
     * <p>Retrieve a paginated list of users.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;TicketingListUsersResponse&gt; - The async response
     */
    public CompletableFuture<TicketingListUsersResponse> listUsers(TicketingListUsersRequest request, Optional<Options> options) {
        AsyncRequestOperation<TicketingListUsersRequest, TicketingListUsersResponse> operation
              = new TicketingListUsers.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get User
     * 
     * <p>Retrieve a single user by their identifier.
     * 
     * @return The async call builder
     */
    public TicketingGetUserRequestBuilder getUser() {
        return new TicketingGetUserRequestBuilder(sdkConfiguration);
    }

    /**
     * Get User
     * 
     * <p>Retrieve a single user by their identifier.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;TicketingGetUserResponse&gt; - The async response
     */
    public CompletableFuture<TicketingGetUserResponse> getUser(TicketingGetUserRequest request) {
        return getUser(request, Optional.empty());
    }

    /**
     * Get User
     * 
     * <p>Retrieve a single user by their identifier.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;TicketingGetUserResponse&gt; - The async response
     */
    public CompletableFuture<TicketingGetUserResponse> getUser(TicketingGetUserRequest request, Optional<Options> options) {
        AsyncRequestOperation<TicketingGetUserRequest, TicketingGetUserResponse> operation
              = new TicketingGetUser.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Comments
     * 
     * <p>Retrieve a paginated list of comments for a ticket.
     * 
     * @return The async call builder
     */
    public TicketingListCommentsRequestBuilder listComments() {
        return new TicketingListCommentsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Comments
     * 
     * <p>Retrieve a paginated list of comments for a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;TicketingListCommentsResponse&gt; - The async response
     */
    public CompletableFuture<TicketingListCommentsResponse> listComments(TicketingListCommentsRequest request) {
        return listComments(request, Optional.empty());
    }

    /**
     * List Comments
     * 
     * <p>Retrieve a paginated list of comments for a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;TicketingListCommentsResponse&gt; - The async response
     */
    public CompletableFuture<TicketingListCommentsResponse> listComments(TicketingListCommentsRequest request, Optional<Options> options) {
        AsyncRequestOperation<TicketingListCommentsRequest, TicketingListCommentsResponse> operation
              = new TicketingListComments.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Comment
     * 
     * <p>Retrieve a single comment by its identifier for a ticket.
     * 
     * @return The async call builder
     */
    public TicketingGetCommentRequestBuilder getComment() {
        return new TicketingGetCommentRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Comment
     * 
     * <p>Retrieve a single comment by its identifier for a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;TicketingGetCommentResponse&gt; - The async response
     */
    public CompletableFuture<TicketingGetCommentResponse> getComment(TicketingGetCommentRequest request) {
        return getComment(request, Optional.empty());
    }

    /**
     * Get Comment
     * 
     * <p>Retrieve a single comment by its identifier for a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;TicketingGetCommentResponse&gt; - The async response
     */
    public CompletableFuture<TicketingGetCommentResponse> getComment(TicketingGetCommentRequest request, Optional<Options> options) {
        AsyncRequestOperation<TicketingGetCommentRequest, TicketingGetCommentResponse> operation
              = new TicketingGetComment.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Download Attachment
     * 
     * <p>Download the attachment file from a ticket.
     * 
     * @return The async call builder
     */
    public TicketingDownloadTicketingAttachmentRequestBuilder downloadTicketingAttachment() {
        return new TicketingDownloadTicketingAttachmentRequestBuilder(sdkConfiguration);
    }

    /**
     * Download Attachment
     * 
     * <p>Download the attachment file from a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;TicketingDownloadTicketingAttachmentResponse&gt; - The async response
     */
    public CompletableFuture<TicketingDownloadTicketingAttachmentResponse> downloadTicketingAttachment(TicketingDownloadTicketingAttachmentRequest request) {
        return downloadTicketingAttachment(request, Optional.empty());
    }

    /**
     * Download Attachment
     * 
     * <p>Download the attachment file from a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;TicketingDownloadTicketingAttachmentResponse&gt; - The async response
     */
    public CompletableFuture<TicketingDownloadTicketingAttachmentResponse> downloadTicketingAttachment(TicketingDownloadTicketingAttachmentRequest request, Optional<Options> options) {
        AsyncRequestOperation<TicketingDownloadTicketingAttachmentRequest, TicketingDownloadTicketingAttachmentResponse> operation
              = new TicketingDownloadTicketingAttachment.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Attachments
     * 
     * <p>Retrieve a paginated list of attachment details for a ticket.
     * 
     * @return The async call builder
     */
    public TicketingListAttachmentsRequestBuilder listAttachments() {
        return new TicketingListAttachmentsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Attachments
     * 
     * <p>Retrieve a paginated list of attachment details for a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;TicketingListAttachmentsResponse&gt; - The async response
     */
    public CompletableFuture<TicketingListAttachmentsResponse> listAttachments(TicketingListAttachmentsRequest request) {
        return listAttachments(request, Optional.empty());
    }

    /**
     * List Attachments
     * 
     * <p>Retrieve a paginated list of attachment details for a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;TicketingListAttachmentsResponse&gt; - The async response
     */
    public CompletableFuture<TicketingListAttachmentsResponse> listAttachments(TicketingListAttachmentsRequest request, Optional<Options> options) {
        AsyncRequestOperation<TicketingListAttachmentsRequest, TicketingListAttachmentsResponse> operation
              = new TicketingListAttachments.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Attachment
     * 
     * <p>Retrieve the details of a single attachment for a ticket.
     * 
     * @return The async call builder
     */
    public TicketingGetAttachmentRequestBuilder getAttachment() {
        return new TicketingGetAttachmentRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Attachment
     * 
     * <p>Retrieve the details of a single attachment for a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;TicketingGetAttachmentResponse&gt; - The async response
     */
    public CompletableFuture<TicketingGetAttachmentResponse> getAttachment(TicketingGetAttachmentRequest request) {
        return getAttachment(request, Optional.empty());
    }

    /**
     * Get Attachment
     * 
     * <p>Retrieve the details of a single attachment for a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;TicketingGetAttachmentResponse&gt; - The async response
     */
    public CompletableFuture<TicketingGetAttachmentResponse> getAttachment(TicketingGetAttachmentRequest request, Optional<Options> options) {
        AsyncRequestOperation<TicketingGetAttachmentRequest, TicketingGetAttachmentResponse> operation
              = new TicketingGetAttachment.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Ticket Types
     * 
     * <p>Retrieve a paginated list of all ticket types.
     * 
     * @return The async call builder
     */
    public TicketingListTicketTypesRequestBuilder listTicketTypes() {
        return new TicketingListTicketTypesRequestBuilder(sdkConfiguration);
    }

    /**
     * List Ticket Types
     * 
     * <p>Retrieve a paginated list of all ticket types.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;TicketingListTicketTypesResponse&gt; - The async response
     */
    public CompletableFuture<TicketingListTicketTypesResponse> listTicketTypes(TicketingListTicketTypesRequest request) {
        return listTicketTypes(request, Optional.empty());
    }

    /**
     * List Ticket Types
     * 
     * <p>Retrieve a paginated list of all ticket types.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;TicketingListTicketTypesResponse&gt; - The async response
     */
    public CompletableFuture<TicketingListTicketTypesResponse> listTicketTypes(TicketingListTicketTypesRequest request, Optional<Options> options) {
        AsyncRequestOperation<TicketingListTicketTypesRequest, TicketingListTicketTypesResponse> operation
              = new TicketingListTicketTypes.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Ticket Type
     * 
     * <p>Retrieve a single ticket type by its identifier.
     * 
     * @return The async call builder
     */
    public TicketingGetTicketTypeRequestBuilder getTicketType() {
        return new TicketingGetTicketTypeRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Ticket Type
     * 
     * <p>Retrieve a single ticket type by its identifier.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;TicketingGetTicketTypeResponse&gt; - The async response
     */
    public CompletableFuture<TicketingGetTicketTypeResponse> getTicketType(TicketingGetTicketTypeRequest request) {
        return getTicketType(request, Optional.empty());
    }

    /**
     * Get Ticket Type
     * 
     * <p>Retrieve a single ticket type by its identifier.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;TicketingGetTicketTypeResponse&gt; - The async response
     */
    public CompletableFuture<TicketingGetTicketTypeResponse> getTicketType(TicketingGetTicketTypeRequest request, Optional<Options> options) {
        AsyncRequestOperation<TicketingGetTicketTypeRequest, TicketingGetTicketTypeResponse> operation
              = new TicketingGetTicketType.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Projects
     * 
     * <p>Retrieve a paginated list of projects.
     * 
     * @return The async call builder
     */
    public TicketingListProjectsRequestBuilder listProjects() {
        return new TicketingListProjectsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Projects
     * 
     * <p>Retrieve a paginated list of projects.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;TicketingListProjectsResponse&gt; - The async response
     */
    public CompletableFuture<TicketingListProjectsResponse> listProjects(TicketingListProjectsRequest request) {
        return listProjects(request, Optional.empty());
    }

    /**
     * List Projects
     * 
     * <p>Retrieve a paginated list of projects.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;TicketingListProjectsResponse&gt; - The async response
     */
    public CompletableFuture<TicketingListProjectsResponse> listProjects(TicketingListProjectsRequest request, Optional<Options> options) {
        AsyncRequestOperation<TicketingListProjectsRequest, TicketingListProjectsResponse> operation
              = new TicketingListProjects.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Project
     * 
     * <p>Retrieve a single project by its identifier.
     * 
     * @return The async call builder
     */
    public TicketingGetProjectRequestBuilder getProject() {
        return new TicketingGetProjectRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Project
     * 
     * <p>Retrieve a single project by its identifier.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;TicketingGetProjectResponse&gt; - The async response
     */
    public CompletableFuture<TicketingGetProjectResponse> getProject(TicketingGetProjectRequest request) {
        return getProject(request, Optional.empty());
    }

    /**
     * Get Project
     * 
     * <p>Retrieve a single project by its identifier.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;TicketingGetProjectResponse&gt; - The async response
     */
    public CompletableFuture<TicketingGetProjectResponse> getProject(TicketingGetProjectRequest request, Optional<Options> options) {
        AsyncRequestOperation<TicketingGetProjectRequest, TicketingGetProjectResponse> operation
              = new TicketingGetProject.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Project Components
     * 
     * <p>Retrieve a paginated list of project components.
     * 
     * @return The async call builder
     */
    public TicketingListProjectComponentsRequestBuilder listProjectComponents() {
        return new TicketingListProjectComponentsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Project Components
     * 
     * <p>Retrieve a paginated list of project components.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;TicketingListProjectComponentsResponse&gt; - The async response
     */
    public CompletableFuture<TicketingListProjectComponentsResponse> listProjectComponents(TicketingListProjectComponentsRequest request) {
        return listProjectComponents(request, Optional.empty());
    }

    /**
     * List Project Components
     * 
     * <p>Retrieve a paginated list of project components.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;TicketingListProjectComponentsResponse&gt; - The async response
     */
    public CompletableFuture<TicketingListProjectComponentsResponse> listProjectComponents(TicketingListProjectComponentsRequest request, Optional<Options> options) {
        AsyncRequestOperation<TicketingListProjectComponentsRequest, TicketingListProjectComponentsResponse> operation
              = new TicketingListProjectComponents.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Project Component
     * 
     * <p>Retrieve a single project component by its identifier.
     * 
     * @return The async call builder
     */
    public TicketingGetProjectComponentRequestBuilder getProjectComponent() {
        return new TicketingGetProjectComponentRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Project Component
     * 
     * <p>Retrieve a single project component by its identifier.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;TicketingGetProjectComponentResponse&gt; - The async response
     */
    public CompletableFuture<TicketingGetProjectComponentResponse> getProjectComponent(TicketingGetProjectComponentRequest request) {
        return getProjectComponent(request, Optional.empty());
    }

    /**
     * Get Project Component
     * 
     * <p>Retrieve a single project component by its identifier.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;TicketingGetProjectComponentResponse&gt; - The async response
     */
    public CompletableFuture<TicketingGetProjectComponentResponse> getProjectComponent(TicketingGetProjectComponentRequest request, Optional<Options> options) {
        AsyncRequestOperation<TicketingGetProjectComponentRequest, TicketingGetProjectComponentResponse> operation
              = new TicketingGetProjectComponent.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Project Ticket Types
     * 
     * <p>Retrieve a paginated list of ticket types for a project.
     * 
     * @return The async call builder
     */
    public TicketingListProjectTicketTypesRequestBuilder listProjectTicketTypes() {
        return new TicketingListProjectTicketTypesRequestBuilder(sdkConfiguration);
    }

    /**
     * List Project Ticket Types
     * 
     * <p>Retrieve a paginated list of ticket types for a project.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;TicketingListProjectTicketTypesResponse&gt; - The async response
     */
    public CompletableFuture<TicketingListProjectTicketTypesResponse> listProjectTicketTypes(TicketingListProjectTicketTypesRequest request) {
        return listProjectTicketTypes(request, Optional.empty());
    }

    /**
     * List Project Ticket Types
     * 
     * <p>Retrieve a paginated list of ticket types for a project.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;TicketingListProjectTicketTypesResponse&gt; - The async response
     */
    public CompletableFuture<TicketingListProjectTicketTypesResponse> listProjectTicketTypes(TicketingListProjectTicketTypesRequest request, Optional<Options> options) {
        AsyncRequestOperation<TicketingListProjectTicketTypesRequest, TicketingListProjectTicketTypesResponse> operation
              = new TicketingListProjectTicketTypes.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Ticket Statuses
     * 
     * <p>Retrieve a paginated list of statuses for a ticket.
     * 
     * @return The async call builder
     */
    public TicketingListTicketStatusesRequestBuilder listTicketStatuses() {
        return new TicketingListTicketStatusesRequestBuilder(sdkConfiguration);
    }

    /**
     * List Ticket Statuses
     * 
     * <p>Retrieve a paginated list of statuses for a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;TicketingListTicketStatusesResponse&gt; - The async response
     */
    public CompletableFuture<TicketingListTicketStatusesResponse> listTicketStatuses(TicketingListTicketStatusesRequest request) {
        return listTicketStatuses(request, Optional.empty());
    }

    /**
     * List Ticket Statuses
     * 
     * <p>Retrieve a paginated list of statuses for a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;TicketingListTicketStatusesResponse&gt; - The async response
     */
    public CompletableFuture<TicketingListTicketStatusesResponse> listTicketStatuses(TicketingListTicketStatusesRequest request, Optional<Options> options) {
        AsyncRequestOperation<TicketingListTicketStatusesRequest, TicketingListTicketStatusesResponse> operation
              = new TicketingListTicketStatuses.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

}
