/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.ScreeningCreateOrderRequestDto;
import com.stackone.stackone_client_java.models.operations.ScreeningCreateScreeningOrderRequest;
import com.stackone.stackone_client_java.models.operations.async.ScreeningCreateScreeningOrderResponse;
import com.stackone.stackone_client_java.operations.ScreeningCreateScreeningOrder;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class ScreeningCreateScreeningOrderRequestBuilder {
    private String xAccountId;
    private ScreeningCreateOrderRequestDto screeningCreateOrderRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public ScreeningCreateScreeningOrderRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public ScreeningCreateScreeningOrderRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public ScreeningCreateScreeningOrderRequestBuilder screeningCreateOrderRequestDto(ScreeningCreateOrderRequestDto screeningCreateOrderRequestDto) {
        Utils.checkNotNull(screeningCreateOrderRequestDto, "screeningCreateOrderRequestDto");
        this.screeningCreateOrderRequestDto = screeningCreateOrderRequestDto;
        return this;
    }

    public ScreeningCreateScreeningOrderRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public ScreeningCreateScreeningOrderRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private ScreeningCreateScreeningOrderRequest buildRequest() {
        ScreeningCreateScreeningOrderRequest request = new ScreeningCreateScreeningOrderRequest(this.xAccountId, this.screeningCreateOrderRequestDto);
        return request;
    }

    public CompletableFuture<ScreeningCreateScreeningOrderResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        ScreeningCreateScreeningOrder.Async operation = new ScreeningCreateScreeningOrder.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler());
        ScreeningCreateScreeningOrderRequest request = this.buildRequest();
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

