/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;


public class TimeOffBalances {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * The employee id associated with this balance
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("employee_id")
    private JsonNullable<String> employeeId;

    /**
     * Provider's unique identifier of the employee associated with this balance
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_employee_id")
    private JsonNullable<String> remoteEmployeeId;

    /**
     * The time off policy id associated with this balance
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("policy_id")
    private JsonNullable<String> policyId;

    /**
     * Provider's unique identifier of the time off policy id associated with this balance
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_policy_id")
    private JsonNullable<String> remotePolicyId;

    /**
     * The time off policy associated with this balance
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("policy")
    private JsonNullable<? extends TimeOffBalancesPolicy> policy;

    /**
     * The current numeric balance for the associated employee and time off policy
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("current_balance")
    private JsonNullable<Double> currentBalance;

    /**
     * The initial numeric balance for the associated employee and time off policy as of the balance start
     * date
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("initial_balance")
    private JsonNullable<Double> initialBalance;

    /**
     * The duration unit of the current balance
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("balance_unit")
    private JsonNullable<? extends BalanceUnit> balanceUnit;

    /**
     * The date of when the initial balance quantity was set
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("balance_start_date")
    private JsonNullable<OffsetDateTime> balanceStartDate;

    /**
     * The date of when the current balance expires
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("balance_expiry_date")
    private JsonNullable<OffsetDateTime> balanceExpiryDate;

    /**
     * The updated_at date of this time off balance
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    @JsonCreator
    public TimeOffBalances(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("employee_id") JsonNullable<String> employeeId,
            @JsonProperty("remote_employee_id") JsonNullable<String> remoteEmployeeId,
            @JsonProperty("policy_id") JsonNullable<String> policyId,
            @JsonProperty("remote_policy_id") JsonNullable<String> remotePolicyId,
            @JsonProperty("policy") JsonNullable<? extends TimeOffBalancesPolicy> policy,
            @JsonProperty("current_balance") JsonNullable<Double> currentBalance,
            @JsonProperty("initial_balance") JsonNullable<Double> initialBalance,
            @JsonProperty("balance_unit") JsonNullable<? extends BalanceUnit> balanceUnit,
            @JsonProperty("balance_start_date") JsonNullable<OffsetDateTime> balanceStartDate,
            @JsonProperty("balance_expiry_date") JsonNullable<OffsetDateTime> balanceExpiryDate,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(employeeId, "employeeId");
        Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
        Utils.checkNotNull(policyId, "policyId");
        Utils.checkNotNull(remotePolicyId, "remotePolicyId");
        Utils.checkNotNull(policy, "policy");
        Utils.checkNotNull(currentBalance, "currentBalance");
        Utils.checkNotNull(initialBalance, "initialBalance");
        Utils.checkNotNull(balanceUnit, "balanceUnit");
        Utils.checkNotNull(balanceStartDate, "balanceStartDate");
        Utils.checkNotNull(balanceExpiryDate, "balanceExpiryDate");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.remoteId = remoteId;
        this.employeeId = employeeId;
        this.remoteEmployeeId = remoteEmployeeId;
        this.policyId = policyId;
        this.remotePolicyId = remotePolicyId;
        this.policy = policy;
        this.currentBalance = currentBalance;
        this.initialBalance = initialBalance;
        this.balanceUnit = balanceUnit;
        this.balanceStartDate = balanceStartDate;
        this.balanceExpiryDate = balanceExpiryDate;
        this.updatedAt = updatedAt;
    }
    
    public TimeOffBalances() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * The employee id associated with this balance
     */
    @JsonIgnore
    public JsonNullable<String> employeeId() {
        return employeeId;
    }

    /**
     * Provider's unique identifier of the employee associated with this balance
     */
    @JsonIgnore
    public JsonNullable<String> remoteEmployeeId() {
        return remoteEmployeeId;
    }

    /**
     * The time off policy id associated with this balance
     */
    @JsonIgnore
    public JsonNullable<String> policyId() {
        return policyId;
    }

    /**
     * Provider's unique identifier of the time off policy id associated with this balance
     */
    @JsonIgnore
    public JsonNullable<String> remotePolicyId() {
        return remotePolicyId;
    }

    /**
     * The time off policy associated with this balance
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TimeOffBalancesPolicy> policy() {
        return (JsonNullable<TimeOffBalancesPolicy>) policy;
    }

    /**
     * The current numeric balance for the associated employee and time off policy
     */
    @JsonIgnore
    public JsonNullable<Double> currentBalance() {
        return currentBalance;
    }

    /**
     * The initial numeric balance for the associated employee and time off policy as of the balance start
     * date
     */
    @JsonIgnore
    public JsonNullable<Double> initialBalance() {
        return initialBalance;
    }

    /**
     * The duration unit of the current balance
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<BalanceUnit> balanceUnit() {
        return (JsonNullable<BalanceUnit>) balanceUnit;
    }

    /**
     * The date of when the initial balance quantity was set
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> balanceStartDate() {
        return balanceStartDate;
    }

    /**
     * The date of when the current balance expires
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> balanceExpiryDate() {
        return balanceExpiryDate;
    }

    /**
     * The updated_at date of this time off balance
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public TimeOffBalances withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public TimeOffBalances withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public TimeOffBalances withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public TimeOffBalances withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * The employee id associated with this balance
     */
    public TimeOffBalances withEmployeeId(String employeeId) {
        Utils.checkNotNull(employeeId, "employeeId");
        this.employeeId = JsonNullable.of(employeeId);
        return this;
    }

    /**
     * The employee id associated with this balance
     */
    public TimeOffBalances withEmployeeId(JsonNullable<String> employeeId) {
        Utils.checkNotNull(employeeId, "employeeId");
        this.employeeId = employeeId;
        return this;
    }

    /**
     * Provider's unique identifier of the employee associated with this balance
     */
    public TimeOffBalances withRemoteEmployeeId(String remoteEmployeeId) {
        Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
        this.remoteEmployeeId = JsonNullable.of(remoteEmployeeId);
        return this;
    }

    /**
     * Provider's unique identifier of the employee associated with this balance
     */
    public TimeOffBalances withRemoteEmployeeId(JsonNullable<String> remoteEmployeeId) {
        Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
        this.remoteEmployeeId = remoteEmployeeId;
        return this;
    }

    /**
     * The time off policy id associated with this balance
     */
    public TimeOffBalances withPolicyId(String policyId) {
        Utils.checkNotNull(policyId, "policyId");
        this.policyId = JsonNullable.of(policyId);
        return this;
    }

    /**
     * The time off policy id associated with this balance
     */
    public TimeOffBalances withPolicyId(JsonNullable<String> policyId) {
        Utils.checkNotNull(policyId, "policyId");
        this.policyId = policyId;
        return this;
    }

    /**
     * Provider's unique identifier of the time off policy id associated with this balance
     */
    public TimeOffBalances withRemotePolicyId(String remotePolicyId) {
        Utils.checkNotNull(remotePolicyId, "remotePolicyId");
        this.remotePolicyId = JsonNullable.of(remotePolicyId);
        return this;
    }

    /**
     * Provider's unique identifier of the time off policy id associated with this balance
     */
    public TimeOffBalances withRemotePolicyId(JsonNullable<String> remotePolicyId) {
        Utils.checkNotNull(remotePolicyId, "remotePolicyId");
        this.remotePolicyId = remotePolicyId;
        return this;
    }

    /**
     * The time off policy associated with this balance
     */
    public TimeOffBalances withPolicy(TimeOffBalancesPolicy policy) {
        Utils.checkNotNull(policy, "policy");
        this.policy = JsonNullable.of(policy);
        return this;
    }

    /**
     * The time off policy associated with this balance
     */
    public TimeOffBalances withPolicy(JsonNullable<? extends TimeOffBalancesPolicy> policy) {
        Utils.checkNotNull(policy, "policy");
        this.policy = policy;
        return this;
    }

    /**
     * The current numeric balance for the associated employee and time off policy
     */
    public TimeOffBalances withCurrentBalance(double currentBalance) {
        Utils.checkNotNull(currentBalance, "currentBalance");
        this.currentBalance = JsonNullable.of(currentBalance);
        return this;
    }

    /**
     * The current numeric balance for the associated employee and time off policy
     */
    public TimeOffBalances withCurrentBalance(JsonNullable<Double> currentBalance) {
        Utils.checkNotNull(currentBalance, "currentBalance");
        this.currentBalance = currentBalance;
        return this;
    }

    /**
     * The initial numeric balance for the associated employee and time off policy as of the balance start
     * date
     */
    public TimeOffBalances withInitialBalance(double initialBalance) {
        Utils.checkNotNull(initialBalance, "initialBalance");
        this.initialBalance = JsonNullable.of(initialBalance);
        return this;
    }

    /**
     * The initial numeric balance for the associated employee and time off policy as of the balance start
     * date
     */
    public TimeOffBalances withInitialBalance(JsonNullable<Double> initialBalance) {
        Utils.checkNotNull(initialBalance, "initialBalance");
        this.initialBalance = initialBalance;
        return this;
    }

    /**
     * The duration unit of the current balance
     */
    public TimeOffBalances withBalanceUnit(BalanceUnit balanceUnit) {
        Utils.checkNotNull(balanceUnit, "balanceUnit");
        this.balanceUnit = JsonNullable.of(balanceUnit);
        return this;
    }

    /**
     * The duration unit of the current balance
     */
    public TimeOffBalances withBalanceUnit(JsonNullable<? extends BalanceUnit> balanceUnit) {
        Utils.checkNotNull(balanceUnit, "balanceUnit");
        this.balanceUnit = balanceUnit;
        return this;
    }

    /**
     * The date of when the initial balance quantity was set
     */
    public TimeOffBalances withBalanceStartDate(OffsetDateTime balanceStartDate) {
        Utils.checkNotNull(balanceStartDate, "balanceStartDate");
        this.balanceStartDate = JsonNullable.of(balanceStartDate);
        return this;
    }

    /**
     * The date of when the initial balance quantity was set
     */
    public TimeOffBalances withBalanceStartDate(JsonNullable<OffsetDateTime> balanceStartDate) {
        Utils.checkNotNull(balanceStartDate, "balanceStartDate");
        this.balanceStartDate = balanceStartDate;
        return this;
    }

    /**
     * The date of when the current balance expires
     */
    public TimeOffBalances withBalanceExpiryDate(OffsetDateTime balanceExpiryDate) {
        Utils.checkNotNull(balanceExpiryDate, "balanceExpiryDate");
        this.balanceExpiryDate = JsonNullable.of(balanceExpiryDate);
        return this;
    }

    /**
     * The date of when the current balance expires
     */
    public TimeOffBalances withBalanceExpiryDate(JsonNullable<OffsetDateTime> balanceExpiryDate) {
        Utils.checkNotNull(balanceExpiryDate, "balanceExpiryDate");
        this.balanceExpiryDate = balanceExpiryDate;
        return this;
    }

    /**
     * The updated_at date of this time off balance
     */
    public TimeOffBalances withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * The updated_at date of this time off balance
     */
    public TimeOffBalances withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TimeOffBalances other = (TimeOffBalances) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.employeeId, other.employeeId) &&
            Utils.enhancedDeepEquals(this.remoteEmployeeId, other.remoteEmployeeId) &&
            Utils.enhancedDeepEquals(this.policyId, other.policyId) &&
            Utils.enhancedDeepEquals(this.remotePolicyId, other.remotePolicyId) &&
            Utils.enhancedDeepEquals(this.policy, other.policy) &&
            Utils.enhancedDeepEquals(this.currentBalance, other.currentBalance) &&
            Utils.enhancedDeepEquals(this.initialBalance, other.initialBalance) &&
            Utils.enhancedDeepEquals(this.balanceUnit, other.balanceUnit) &&
            Utils.enhancedDeepEquals(this.balanceStartDate, other.balanceStartDate) &&
            Utils.enhancedDeepEquals(this.balanceExpiryDate, other.balanceExpiryDate) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, employeeId,
            remoteEmployeeId, policyId, remotePolicyId,
            policy, currentBalance, initialBalance,
            balanceUnit, balanceStartDate, balanceExpiryDate,
            updatedAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TimeOffBalances.class,
                "id", id,
                "remoteId", remoteId,
                "employeeId", employeeId,
                "remoteEmployeeId", remoteEmployeeId,
                "policyId", policyId,
                "remotePolicyId", remotePolicyId,
                "policy", policy,
                "currentBalance", currentBalance,
                "initialBalance", initialBalance,
                "balanceUnit", balanceUnit,
                "balanceStartDate", balanceStartDate,
                "balanceExpiryDate", balanceExpiryDate,
                "updatedAt", updatedAt);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<String> employeeId = JsonNullable.undefined();

        private JsonNullable<String> remoteEmployeeId = JsonNullable.undefined();

        private JsonNullable<String> policyId = JsonNullable.undefined();

        private JsonNullable<String> remotePolicyId = JsonNullable.undefined();

        private JsonNullable<? extends TimeOffBalancesPolicy> policy = JsonNullable.undefined();

        private JsonNullable<Double> currentBalance = JsonNullable.undefined();

        private JsonNullable<Double> initialBalance = JsonNullable.undefined();

        private JsonNullable<? extends BalanceUnit> balanceUnit = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> balanceStartDate = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> balanceExpiryDate = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * The employee id associated with this balance
         */
        public Builder employeeId(String employeeId) {
            Utils.checkNotNull(employeeId, "employeeId");
            this.employeeId = JsonNullable.of(employeeId);
            return this;
        }

        /**
         * The employee id associated with this balance
         */
        public Builder employeeId(JsonNullable<String> employeeId) {
            Utils.checkNotNull(employeeId, "employeeId");
            this.employeeId = employeeId;
            return this;
        }


        /**
         * Provider's unique identifier of the employee associated with this balance
         */
        public Builder remoteEmployeeId(String remoteEmployeeId) {
            Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
            this.remoteEmployeeId = JsonNullable.of(remoteEmployeeId);
            return this;
        }

        /**
         * Provider's unique identifier of the employee associated with this balance
         */
        public Builder remoteEmployeeId(JsonNullable<String> remoteEmployeeId) {
            Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
            this.remoteEmployeeId = remoteEmployeeId;
            return this;
        }


        /**
         * The time off policy id associated with this balance
         */
        public Builder policyId(String policyId) {
            Utils.checkNotNull(policyId, "policyId");
            this.policyId = JsonNullable.of(policyId);
            return this;
        }

        /**
         * The time off policy id associated with this balance
         */
        public Builder policyId(JsonNullable<String> policyId) {
            Utils.checkNotNull(policyId, "policyId");
            this.policyId = policyId;
            return this;
        }


        /**
         * Provider's unique identifier of the time off policy id associated with this balance
         */
        public Builder remotePolicyId(String remotePolicyId) {
            Utils.checkNotNull(remotePolicyId, "remotePolicyId");
            this.remotePolicyId = JsonNullable.of(remotePolicyId);
            return this;
        }

        /**
         * Provider's unique identifier of the time off policy id associated with this balance
         */
        public Builder remotePolicyId(JsonNullable<String> remotePolicyId) {
            Utils.checkNotNull(remotePolicyId, "remotePolicyId");
            this.remotePolicyId = remotePolicyId;
            return this;
        }


        /**
         * The time off policy associated with this balance
         */
        public Builder policy(TimeOffBalancesPolicy policy) {
            Utils.checkNotNull(policy, "policy");
            this.policy = JsonNullable.of(policy);
            return this;
        }

        /**
         * The time off policy associated with this balance
         */
        public Builder policy(JsonNullable<? extends TimeOffBalancesPolicy> policy) {
            Utils.checkNotNull(policy, "policy");
            this.policy = policy;
            return this;
        }


        /**
         * The current numeric balance for the associated employee and time off policy
         */
        public Builder currentBalance(double currentBalance) {
            Utils.checkNotNull(currentBalance, "currentBalance");
            this.currentBalance = JsonNullable.of(currentBalance);
            return this;
        }

        /**
         * The current numeric balance for the associated employee and time off policy
         */
        public Builder currentBalance(JsonNullable<Double> currentBalance) {
            Utils.checkNotNull(currentBalance, "currentBalance");
            this.currentBalance = currentBalance;
            return this;
        }


        /**
         * The initial numeric balance for the associated employee and time off policy as of the balance start
         * date
         */
        public Builder initialBalance(double initialBalance) {
            Utils.checkNotNull(initialBalance, "initialBalance");
            this.initialBalance = JsonNullable.of(initialBalance);
            return this;
        }

        /**
         * The initial numeric balance for the associated employee and time off policy as of the balance start
         * date
         */
        public Builder initialBalance(JsonNullable<Double> initialBalance) {
            Utils.checkNotNull(initialBalance, "initialBalance");
            this.initialBalance = initialBalance;
            return this;
        }


        /**
         * The duration unit of the current balance
         */
        public Builder balanceUnit(BalanceUnit balanceUnit) {
            Utils.checkNotNull(balanceUnit, "balanceUnit");
            this.balanceUnit = JsonNullable.of(balanceUnit);
            return this;
        }

        /**
         * The duration unit of the current balance
         */
        public Builder balanceUnit(JsonNullable<? extends BalanceUnit> balanceUnit) {
            Utils.checkNotNull(balanceUnit, "balanceUnit");
            this.balanceUnit = balanceUnit;
            return this;
        }


        /**
         * The date of when the initial balance quantity was set
         */
        public Builder balanceStartDate(OffsetDateTime balanceStartDate) {
            Utils.checkNotNull(balanceStartDate, "balanceStartDate");
            this.balanceStartDate = JsonNullable.of(balanceStartDate);
            return this;
        }

        /**
         * The date of when the initial balance quantity was set
         */
        public Builder balanceStartDate(JsonNullable<OffsetDateTime> balanceStartDate) {
            Utils.checkNotNull(balanceStartDate, "balanceStartDate");
            this.balanceStartDate = balanceStartDate;
            return this;
        }


        /**
         * The date of when the current balance expires
         */
        public Builder balanceExpiryDate(OffsetDateTime balanceExpiryDate) {
            Utils.checkNotNull(balanceExpiryDate, "balanceExpiryDate");
            this.balanceExpiryDate = JsonNullable.of(balanceExpiryDate);
            return this;
        }

        /**
         * The date of when the current balance expires
         */
        public Builder balanceExpiryDate(JsonNullable<OffsetDateTime> balanceExpiryDate) {
            Utils.checkNotNull(balanceExpiryDate, "balanceExpiryDate");
            this.balanceExpiryDate = balanceExpiryDate;
            return this;
        }


        /**
         * The updated_at date of this time off balance
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * The updated_at date of this time off balance
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public TimeOffBalances build() {

            return new TimeOffBalances(
                id, remoteId, employeeId,
                remoteEmployeeId, policyId, remotePolicyId,
                policy, currentBalance, initialBalance,
                balanceUnit, balanceStartDate, balanceExpiryDate,
                updatedAt);
        }

    }
}
