/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * DocumentsListFoldersQueryParamFilter
 * 
 * <p>Documents Folders Filter
 */
public class DocumentsListFoldersQueryParamFilter {
    /**
     * Use a string with a date to only select results updated after that given date
     */
    @SpeakeasyMetadata("queryParam:name=updated_after")
    private JsonNullable<OffsetDateTime> updatedAfter;

    /**
     * Use to only include Folders within the specified Drive
     */
    @SpeakeasyMetadata("queryParam:name=drive_id")
    private JsonNullable<String> driveId;

    /**
     * Use to only include Folders within the specified Folder. Required when requesting nested items
     */
    @SpeakeasyMetadata("queryParam:name=folder_id")
    private JsonNullable<String> folderId;

    @JsonCreator
    public DocumentsListFoldersQueryParamFilter(
            JsonNullable<OffsetDateTime> updatedAfter,
            JsonNullable<String> driveId,
            JsonNullable<String> folderId) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        Utils.checkNotNull(driveId, "driveId");
        Utils.checkNotNull(folderId, "folderId");
        this.updatedAfter = updatedAfter;
        this.driveId = driveId;
        this.folderId = folderId;
    }
    
    public DocumentsListFoldersQueryParamFilter() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAfter() {
        return updatedAfter;
    }

    /**
     * Use to only include Folders within the specified Drive
     */
    @JsonIgnore
    public JsonNullable<String> driveId() {
        return driveId;
    }

    /**
     * Use to only include Folders within the specified Folder. Required when requesting nested items
     */
    @JsonIgnore
    public JsonNullable<String> folderId() {
        return folderId;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Use a string with a date to only select results updated after that given date
     */
    public DocumentsListFoldersQueryParamFilter withUpdatedAfter(OffsetDateTime updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = JsonNullable.of(updatedAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    public DocumentsListFoldersQueryParamFilter withUpdatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = updatedAfter;
        return this;
    }

    /**
     * Use to only include Folders within the specified Drive
     */
    public DocumentsListFoldersQueryParamFilter withDriveId(String driveId) {
        Utils.checkNotNull(driveId, "driveId");
        this.driveId = JsonNullable.of(driveId);
        return this;
    }

    /**
     * Use to only include Folders within the specified Drive
     */
    public DocumentsListFoldersQueryParamFilter withDriveId(JsonNullable<String> driveId) {
        Utils.checkNotNull(driveId, "driveId");
        this.driveId = driveId;
        return this;
    }

    /**
     * Use to only include Folders within the specified Folder. Required when requesting nested items
     */
    public DocumentsListFoldersQueryParamFilter withFolderId(String folderId) {
        Utils.checkNotNull(folderId, "folderId");
        this.folderId = JsonNullable.of(folderId);
        return this;
    }

    /**
     * Use to only include Folders within the specified Folder. Required when requesting nested items
     */
    public DocumentsListFoldersQueryParamFilter withFolderId(JsonNullable<String> folderId) {
        Utils.checkNotNull(folderId, "folderId");
        this.folderId = folderId;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DocumentsListFoldersQueryParamFilter other = (DocumentsListFoldersQueryParamFilter) o;
        return 
            Utils.enhancedDeepEquals(this.updatedAfter, other.updatedAfter) &&
            Utils.enhancedDeepEquals(this.driveId, other.driveId) &&
            Utils.enhancedDeepEquals(this.folderId, other.folderId);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            updatedAfter, driveId, folderId);
    }
    
    @Override
    public String toString() {
        return Utils.toString(DocumentsListFoldersQueryParamFilter.class,
                "updatedAfter", updatedAfter,
                "driveId", driveId,
                "folderId", folderId);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<OffsetDateTime> updatedAfter = JsonNullable.undefined();

        private JsonNullable<String> driveId = JsonNullable.undefined();

        private JsonNullable<String> folderId = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(OffsetDateTime updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = JsonNullable.of(updatedAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = updatedAfter;
            return this;
        }


        /**
         * Use to only include Folders within the specified Drive
         */
        public Builder driveId(String driveId) {
            Utils.checkNotNull(driveId, "driveId");
            this.driveId = JsonNullable.of(driveId);
            return this;
        }

        /**
         * Use to only include Folders within the specified Drive
         */
        public Builder driveId(JsonNullable<String> driveId) {
            Utils.checkNotNull(driveId, "driveId");
            this.driveId = driveId;
            return this;
        }


        /**
         * Use to only include Folders within the specified Folder. Required when requesting nested items
         */
        public Builder folderId(String folderId) {
            Utils.checkNotNull(folderId, "folderId");
            this.folderId = JsonNullable.of(folderId);
            return this;
        }

        /**
         * Use to only include Folders within the specified Folder. Required when requesting nested items
         */
        public Builder folderId(JsonNullable<String> folderId) {
            Utils.checkNotNull(folderId, "folderId");
            this.folderId = folderId;
            return this;
        }

        public DocumentsListFoldersQueryParamFilter build() {

            return new DocumentsListFoldersQueryParamFilter(
                updatedAfter, driveId, folderId);
        }

    }
}
