/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.SkillsPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;


public class LmsListSkillsResponse implements AsyncResponse {
    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<Blob> rawResponse;

    /**
     * The list of skills was retrieved.
     */
    private Optional<? extends SkillsPaginated> skillsPaginated;


    private Map<String, List<String>> headers;

    @JsonCreator
    public LmsListSkillsResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Optional<? extends SkillsPaginated> skillsPaginated,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(skillsPaginated, "skillsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.skillsPaginated = skillsPaginated;
        this.headers = headers;
    }
    
    public LmsListSkillsResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse,
            Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return rawResponse;
    }

    /**
     * The list of skills was retrieved.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<SkillsPaginated> skillsPaginated() {
        return (Optional<SkillsPaginated>) skillsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTTP response content type for this operation
     */
    public LmsListSkillsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public LmsListSkillsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public LmsListSkillsResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The list of skills was retrieved.
     */
    public LmsListSkillsResponse withSkillsPaginated(SkillsPaginated skillsPaginated) {
        Utils.checkNotNull(skillsPaginated, "skillsPaginated");
        this.skillsPaginated = Optional.ofNullable(skillsPaginated);
        return this;
    }


    /**
     * The list of skills was retrieved.
     */
    public LmsListSkillsResponse withSkillsPaginated(Optional<? extends SkillsPaginated> skillsPaginated) {
        Utils.checkNotNull(skillsPaginated, "skillsPaginated");
        this.skillsPaginated = skillsPaginated;
        return this;
    }

    public LmsListSkillsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LmsListSkillsResponse other = (LmsListSkillsResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.skillsPaginated, other.skillsPaginated) &&
            Utils.enhancedDeepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType, statusCode, rawResponse,
            skillsPaginated, headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LmsListSkillsResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "skillsPaginated", skillsPaginated,
                "headers", headers);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String contentType;

        private Integer statusCode;

        private HttpResponse<Blob> rawResponse;

        private Optional<? extends SkillsPaginated> skillsPaginated = Optional.empty();

        private Map<String, List<String>> headers;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }


        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }


        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }


        /**
         * The list of skills was retrieved.
         */
        public Builder skillsPaginated(SkillsPaginated skillsPaginated) {
            Utils.checkNotNull(skillsPaginated, "skillsPaginated");
            this.skillsPaginated = Optional.ofNullable(skillsPaginated);
            return this;
        }

        /**
         * The list of skills was retrieved.
         */
        public Builder skillsPaginated(Optional<? extends SkillsPaginated> skillsPaginated) {
            Utils.checkNotNull(skillsPaginated, "skillsPaginated");
            this.skillsPaginated = skillsPaginated;
            return this;
        }


        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public LmsListSkillsResponse build() {

            return new LmsListSkillsResponse(
                contentType, statusCode, rawResponse,
                skillsPaginated, headers);
        }

    }
}
