/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.MarketingListContentBlocksRequest;
import com.stackone.stackone_client_java.models.operations.MarketingListContentBlocksResponse;
import com.stackone.stackone_client_java.operations.MarketingListContentBlocks;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class MarketingListContentBlocksRequestBuilder {
    private MarketingListContentBlocksRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public MarketingListContentBlocksRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public MarketingListContentBlocksRequestBuilder request(MarketingListContentBlocksRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public MarketingListContentBlocksRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public MarketingListContentBlocksRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public MarketingListContentBlocksResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        MarketingListContentBlocks.Sync operation = new MarketingListContentBlocks.Sync(this.sdkConfiguration, options, this._headers);
        return (MarketingListContentBlocksResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<MarketingListContentBlocksResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        MarketingListContentBlocks.Sync operation = new MarketingListContentBlocks.Sync(this.sdkConfiguration, options, this._headers);
        Paginator<MarketingListContentBlocksRequest, String> iterator = new Paginator<MarketingListContentBlocksRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), MarketingListContentBlocksRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<MarketingListContentBlocksResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

