/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils;

import com.stackone.stackone_client_java.utils.EventStreamMessage;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StreamingParser<T> {
    private final StreamContentProcessor<T> processor;
    private ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
    private boolean first = true;

    StreamingParser(StreamContentProcessor<T> processor) {
        this.processor = processor;
    }

    public Optional<T> add(ByteBuffer inputBuffer) {
        if (inputBuffer == null || !inputBuffer.hasRemaining()) {
            return this.extractNextFromBytes();
        }
        if (this.byteBuffer.remaining() < inputBuffer.remaining()) {
            this.byteBuffer = this.expandByteBuffer(this.byteBuffer.position() + inputBuffer.remaining());
        }
        this.byteBuffer.put(inputBuffer.slice());
        return this.extractNextFromBytes();
    }

    public Optional<T> finish() {
        if (this.byteBuffer.position() > 0) {
            byte[] remainingBytes = new byte[this.byteBuffer.position()];
            this.byteBuffer.flip();
            this.byteBuffer.get(remainingBytes);
            this.byteBuffer.clear();
            String content = this.processor.sanitizeContent(new String(remainingBytes, StandardCharsets.UTF_8), this.first);
            return this.processor.processContent(content);
        }
        return Optional.empty();
    }

    public Optional<T> next() {
        return this.extractNextFromBytes();
    }

    public boolean hasBufferedData() {
        return this.byteBuffer.position() > 0;
    }

    private Optional<T> extractNextFromBytes() {
        Optional<T> result;
        if (this.byteBuffer.position() == 0) {
            return Optional.empty();
        }
        BoundaryInfo boundary = this.processor.findBoundary(this.byteBuffer.array(), this.byteBuffer.position());
        if (boundary.position == -1) {
            return Optional.empty();
        }
        byte[] contentBytes = new byte[boundary.position];
        this.byteBuffer.flip();
        this.byteBuffer.get(contentBytes, 0, boundary.position);
        this.byteBuffer.position(boundary.position + boundary.delimiterLength);
        this.byteBuffer.compact();
        String content = this.processor.sanitizeContent(new String(contentBytes, StandardCharsets.UTF_8), this.first);
        if (this.first) {
            this.first = false;
        }
        if ((result = this.processor.processContent(content)).isPresent()) {
            return result;
        }
        return this.extractNextFromBytes();
    }

    private ByteBuffer expandByteBuffer(int newCapacity) {
        ByteBuffer newBuffer = ByteBuffer.allocate(Math.max(newCapacity, this.byteBuffer.capacity() * 2));
        this.byteBuffer.flip();
        newBuffer.put(this.byteBuffer);
        return newBuffer;
    }

    public static boolean matchesPattern(byte[] data, int pos, int limit, byte ... pattern) {
        if (pos + pattern.length > limit) {
            return false;
        }
        for (int i = 0; i < pattern.length; ++i) {
            if (data[pos + i] == pattern[i]) continue;
            return false;
        }
        return true;
    }

    public static StreamingParser<String> forJsonLines() {
        return new StreamingParser<String>(new JsonLContentProcessor());
    }

    public static StreamingParser<EventStreamMessage> forSSE() {
        return new StreamingParser<EventStreamMessage>(new SSEContentProcessor());
    }

    private static class SSEContentProcessor
    implements StreamContentProcessor<EventStreamMessage> {
        private static final String BYTE_ORDER_MARK = "\ufeff";
        private static final Pattern LINE_PATTERN = Pattern.compile("^([a-zA-Z]+): ?(.*)$");
        private static final char LINEFEED = '\n';
        private static final byte CR = 13;
        private static final byte LF = 10;
        private static final byte[] CRLF_CRLF = new byte[]{13, 10, 13, 10};
        private static final byte[] CRLF_LF = new byte[]{13, 10, 10};
        private static final byte[] LF_CRLF = new byte[]{10, 13, 10};
        private static final byte[] LF_LF = new byte[]{10, 10};

        private SSEContentProcessor() {
        }

        @Override
        public BoundaryInfo findBoundary(byte[] data, int limit) {
            for (int i = 0; i < limit; ++i) {
                if (i + 1 >= limit) continue;
                if (StreamingParser.matchesPattern(data, i, limit, CRLF_CRLF)) {
                    return new BoundaryInfo(i, CRLF_CRLF.length);
                }
                if (StreamingParser.matchesPattern(data, i, limit, CRLF_LF)) {
                    return new BoundaryInfo(i, CRLF_LF.length);
                }
                if (StreamingParser.matchesPattern(data, i, limit, LF_CRLF)) {
                    return new BoundaryInfo(i, LF_CRLF.length);
                }
                if (!StreamingParser.matchesPattern(data, i, limit, LF_LF)) continue;
                return new BoundaryInfo(i, LF_LF.length);
            }
            return new BoundaryInfo(-1, 0);
        }

        @Override
        public Optional<EventStreamMessage> processContent(String content) {
            if (content.trim().isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(this.parseMessage(content));
        }

        @Override
        public String sanitizeContent(String rawContent, boolean isFirst) {
            String sanitized = rawContent.replace("\r\n", "\n").replace("\r", "\n");
            if (isFirst && sanitized.startsWith(BYTE_ORDER_MARK)) {
                sanitized = sanitized.substring(BYTE_ORDER_MARK.length());
            }
            return sanitized;
        }

        private EventStreamMessage parseMessage(String text) {
            String[] lines = text.split("\n");
            Optional<String> event = Optional.empty();
            Optional<String> id = Optional.empty();
            Optional<Integer> retryMs = Optional.empty();
            StringBuilder data = new StringBuilder();
            boolean firstData = true;
            block14: for (String line : lines) {
                Matcher m;
                if (line.startsWith(":") || !(m = LINE_PATTERN.matcher(line)).find()) continue;
                String key = m.group(1).toLowerCase();
                String value = m.group(2);
                switch (key) {
                    case "event": {
                        event = Optional.of(value);
                        continue block14;
                    }
                    case "id": {
                        id = Optional.of(value);
                        continue block14;
                    }
                    case "retry": {
                        try {
                            retryMs = Optional.of(Integer.parseInt(value));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue block14;
                    }
                    case "data": {
                        if (!firstData) {
                            data.append('\n');
                        }
                        firstData = false;
                        data.append(value);
                    }
                }
            }
            return new EventStreamMessage(event, id, retryMs, data.toString());
        }
    }

    private static class JsonLContentProcessor
    implements StreamContentProcessor<String> {
        private static final byte CR = 13;
        private static final byte LF = 10;
        private static final byte[] CRLF = new byte[]{13, 10};
        private static final byte[] LF_ONLY = new byte[]{10};

        private JsonLContentProcessor() {
        }

        @Override
        public BoundaryInfo findBoundary(byte[] data, int limit) {
            for (int i = 0; i < limit; ++i) {
                if (StreamingParser.matchesPattern(data, i, limit, CRLF)) {
                    return new BoundaryInfo(i, CRLF.length);
                }
                if (!StreamingParser.matchesPattern(data, i, limit, LF_ONLY)) continue;
                return new BoundaryInfo(i, LF_ONLY.length);
            }
            return new BoundaryInfo(-1, 0);
        }

        @Override
        public Optional<String> processContent(String content) {
            String trimmed = content.trim();
            return trimmed.isEmpty() ? Optional.empty() : Optional.of(trimmed);
        }
    }

    static interface StreamContentProcessor<T> {
        public BoundaryInfo findBoundary(byte[] var1, int var2);

        public Optional<T> processContent(String var1);

        default public String sanitizeContent(String rawContent, boolean isFirst) {
            return rawContent.replace("\r\n", "\n").replace("\r", "\n");
        }
    }

    static class BoundaryInfo {
        public final int position;
        public final int delimiterLength;

        public BoundaryInfo(int position, int delimiterLength) {
            this.position = position;
            this.delimiterLength = delimiterLength;
        }
    }
}

