/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;

import com.stackone.stackone_client_java.models.components.ConnectSessionAuthenticate;
import com.stackone.stackone_client_java.models.components.ConnectSessionCreate;
import com.stackone.stackone_client_java.models.operations.StackoneAuthenticateConnectSessionRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneAuthenticateConnectSessionResponse;
import com.stackone.stackone_client_java.models.operations.StackoneCreateConnectSessionRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneCreateConnectSessionResponse;
import com.stackone.stackone_client_java.operations.StackoneAuthenticateConnectSession;
import com.stackone.stackone_client_java.operations.StackoneCreateConnectSession;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.util.Optional;

/**
 * Generate connection session tokens or auth URLs to allow your customers to connect their accounts.
 */
public class ConnectSessions {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncConnectSessions asyncSDK;

    ConnectSessions(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.asyncSDK = new AsyncConnectSessions(this, sdkConfiguration);
    }

    /**
     * Switches to the async SDK.
     * 
     * @return The async SDK
     */
    public AsyncConnectSessions async() {
        return asyncSDK;
    }

    /**
     * Create Connect Session
     * 
     * @return The call builder
     */
    public StackoneCreateConnectSessionRequestBuilder createConnectSession() {
        return new StackoneCreateConnectSessionRequestBuilder(sdkConfiguration);
    }

    /**
     * Create Connect Session
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneCreateConnectSessionResponse createConnectSession(ConnectSessionCreate request) {
        return createConnectSession(request, Optional.empty());
    }

    /**
     * Create Connect Session
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneCreateConnectSessionResponse createConnectSession(ConnectSessionCreate request, Optional<Options> options) {
        RequestOperation<ConnectSessionCreate, StackoneCreateConnectSessionResponse> operation
              = new StackoneCreateConnectSession.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Authenticate Connect Session
     * 
     * @return The call builder
     */
    public StackoneAuthenticateConnectSessionRequestBuilder authenticateConnectSession() {
        return new StackoneAuthenticateConnectSessionRequestBuilder(sdkConfiguration);
    }

    /**
     * Authenticate Connect Session
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneAuthenticateConnectSessionResponse authenticateConnectSession(ConnectSessionAuthenticate request) {
        return authenticateConnectSession(request, Optional.empty());
    }

    /**
     * Authenticate Connect Session
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneAuthenticateConnectSessionResponse authenticateConnectSession(ConnectSessionAuthenticate request, Optional<Options> options) {
        RequestOperation<ConnectSessionAuthenticate, StackoneAuthenticateConnectSessionResponse> operation
              = new StackoneAuthenticateConnectSession.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

}
