/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;


public class TaskResultData {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * The employee ID associated with this task
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("employee_id")
    private JsonNullable<String> employeeId;

    /**
     * The name of the task
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * The description of the task
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("description")
    private JsonNullable<String> description;

    /**
     * The type of the task
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    private JsonNullable<? extends TaskResultType> type;

    /**
     * The status of the task
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status")
    private JsonNullable<? extends TaskResultStatus> status;

    /**
     * The due date of the task
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("due_date")
    private JsonNullable<OffsetDateTime> dueDate;

    /**
     * The completion date of the task
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("completion_date")
    private JsonNullable<OffsetDateTime> completionDate;

    /**
     * The ID of the employee who assigned this task
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("assigned_by_employee_id")
    private JsonNullable<String> assignedByEmployeeId;

    /**
     * The name of the employee who assigned this task
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("assigned_by_employee_name")
    private JsonNullable<String> assignedByEmployeeName;

    /**
     * Link to the task in the provider system
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("link_to_task")
    private JsonNullable<String> linkToTask;

    /**
     * List of extracted links from the task
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("extracted_links")
    private JsonNullable<? extends List<String>> extractedLinks;

    /**
     * ID of the next task in sequence
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("next_task_id")
    private JsonNullable<String> nextTaskId;

    /**
     * Name of the parent process of this task
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("parent_process_name")
    private JsonNullable<String> parentProcessName;

    /**
     * The comments associated with this task
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("comments")
    private JsonNullable<? extends List<TaskCommentApiModel>> comments;

    /**
     * The documents attached to this task
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("attachments")
    private JsonNullable<? extends List<File>> attachments;

    /**
     * The creation date of this task
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * The last updated date of this task
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    @JsonCreator
    public TaskResultData(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("employee_id") JsonNullable<String> employeeId,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("description") JsonNullable<String> description,
            @JsonProperty("type") JsonNullable<? extends TaskResultType> type,
            @JsonProperty("status") JsonNullable<? extends TaskResultStatus> status,
            @JsonProperty("due_date") JsonNullable<OffsetDateTime> dueDate,
            @JsonProperty("completion_date") JsonNullable<OffsetDateTime> completionDate,
            @JsonProperty("assigned_by_employee_id") JsonNullable<String> assignedByEmployeeId,
            @JsonProperty("assigned_by_employee_name") JsonNullable<String> assignedByEmployeeName,
            @JsonProperty("link_to_task") JsonNullable<String> linkToTask,
            @JsonProperty("extracted_links") JsonNullable<? extends List<String>> extractedLinks,
            @JsonProperty("next_task_id") JsonNullable<String> nextTaskId,
            @JsonProperty("parent_process_name") JsonNullable<String> parentProcessName,
            @JsonProperty("comments") JsonNullable<? extends List<TaskCommentApiModel>> comments,
            @JsonProperty("attachments") JsonNullable<? extends List<File>> attachments,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(employeeId, "employeeId");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(dueDate, "dueDate");
        Utils.checkNotNull(completionDate, "completionDate");
        Utils.checkNotNull(assignedByEmployeeId, "assignedByEmployeeId");
        Utils.checkNotNull(assignedByEmployeeName, "assignedByEmployeeName");
        Utils.checkNotNull(linkToTask, "linkToTask");
        Utils.checkNotNull(extractedLinks, "extractedLinks");
        Utils.checkNotNull(nextTaskId, "nextTaskId");
        Utils.checkNotNull(parentProcessName, "parentProcessName");
        Utils.checkNotNull(comments, "comments");
        Utils.checkNotNull(attachments, "attachments");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.remoteId = remoteId;
        this.employeeId = employeeId;
        this.name = name;
        this.description = description;
        this.type = type;
        this.status = status;
        this.dueDate = dueDate;
        this.completionDate = completionDate;
        this.assignedByEmployeeId = assignedByEmployeeId;
        this.assignedByEmployeeName = assignedByEmployeeName;
        this.linkToTask = linkToTask;
        this.extractedLinks = extractedLinks;
        this.nextTaskId = nextTaskId;
        this.parentProcessName = parentProcessName;
        this.comments = comments;
        this.attachments = attachments;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }
    
    public TaskResultData() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * The employee ID associated with this task
     */
    @JsonIgnore
    public JsonNullable<String> employeeId() {
        return employeeId;
    }

    /**
     * The name of the task
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * The description of the task
     */
    @JsonIgnore
    public JsonNullable<String> description() {
        return description;
    }

    /**
     * The type of the task
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TaskResultType> type() {
        return (JsonNullable<TaskResultType>) type;
    }

    /**
     * The status of the task
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TaskResultStatus> status() {
        return (JsonNullable<TaskResultStatus>) status;
    }

    /**
     * The due date of the task
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> dueDate() {
        return dueDate;
    }

    /**
     * The completion date of the task
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> completionDate() {
        return completionDate;
    }

    /**
     * The ID of the employee who assigned this task
     */
    @JsonIgnore
    public JsonNullable<String> assignedByEmployeeId() {
        return assignedByEmployeeId;
    }

    /**
     * The name of the employee who assigned this task
     */
    @JsonIgnore
    public JsonNullable<String> assignedByEmployeeName() {
        return assignedByEmployeeName;
    }

    /**
     * Link to the task in the provider system
     */
    @JsonIgnore
    public JsonNullable<String> linkToTask() {
        return linkToTask;
    }

    /**
     * List of extracted links from the task
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> extractedLinks() {
        return (JsonNullable<List<String>>) extractedLinks;
    }

    /**
     * ID of the next task in sequence
     */
    @JsonIgnore
    public JsonNullable<String> nextTaskId() {
        return nextTaskId;
    }

    /**
     * Name of the parent process of this task
     */
    @JsonIgnore
    public JsonNullable<String> parentProcessName() {
        return parentProcessName;
    }

    /**
     * The comments associated with this task
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<TaskCommentApiModel>> comments() {
        return (JsonNullable<List<TaskCommentApiModel>>) comments;
    }

    /**
     * The documents attached to this task
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<File>> attachments() {
        return (JsonNullable<List<File>>) attachments;
    }

    /**
     * The creation date of this task
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * The last updated date of this task
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public TaskResultData withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public TaskResultData withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public TaskResultData withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public TaskResultData withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * The employee ID associated with this task
     */
    public TaskResultData withEmployeeId(String employeeId) {
        Utils.checkNotNull(employeeId, "employeeId");
        this.employeeId = JsonNullable.of(employeeId);
        return this;
    }

    /**
     * The employee ID associated with this task
     */
    public TaskResultData withEmployeeId(JsonNullable<String> employeeId) {
        Utils.checkNotNull(employeeId, "employeeId");
        this.employeeId = employeeId;
        return this;
    }

    /**
     * The name of the task
     */
    public TaskResultData withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * The name of the task
     */
    public TaskResultData withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * The description of the task
     */
    public TaskResultData withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = JsonNullable.of(description);
        return this;
    }

    /**
     * The description of the task
     */
    public TaskResultData withDescription(JsonNullable<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    /**
     * The type of the task
     */
    public TaskResultData withType(TaskResultType type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of(type);
        return this;
    }

    /**
     * The type of the task
     */
    public TaskResultData withType(JsonNullable<? extends TaskResultType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    /**
     * The status of the task
     */
    public TaskResultData withStatus(TaskResultStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = JsonNullable.of(status);
        return this;
    }

    /**
     * The status of the task
     */
    public TaskResultData withStatus(JsonNullable<? extends TaskResultStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * The due date of the task
     */
    public TaskResultData withDueDate(OffsetDateTime dueDate) {
        Utils.checkNotNull(dueDate, "dueDate");
        this.dueDate = JsonNullable.of(dueDate);
        return this;
    }

    /**
     * The due date of the task
     */
    public TaskResultData withDueDate(JsonNullable<OffsetDateTime> dueDate) {
        Utils.checkNotNull(dueDate, "dueDate");
        this.dueDate = dueDate;
        return this;
    }

    /**
     * The completion date of the task
     */
    public TaskResultData withCompletionDate(OffsetDateTime completionDate) {
        Utils.checkNotNull(completionDate, "completionDate");
        this.completionDate = JsonNullable.of(completionDate);
        return this;
    }

    /**
     * The completion date of the task
     */
    public TaskResultData withCompletionDate(JsonNullable<OffsetDateTime> completionDate) {
        Utils.checkNotNull(completionDate, "completionDate");
        this.completionDate = completionDate;
        return this;
    }

    /**
     * The ID of the employee who assigned this task
     */
    public TaskResultData withAssignedByEmployeeId(String assignedByEmployeeId) {
        Utils.checkNotNull(assignedByEmployeeId, "assignedByEmployeeId");
        this.assignedByEmployeeId = JsonNullable.of(assignedByEmployeeId);
        return this;
    }

    /**
     * The ID of the employee who assigned this task
     */
    public TaskResultData withAssignedByEmployeeId(JsonNullable<String> assignedByEmployeeId) {
        Utils.checkNotNull(assignedByEmployeeId, "assignedByEmployeeId");
        this.assignedByEmployeeId = assignedByEmployeeId;
        return this;
    }

    /**
     * The name of the employee who assigned this task
     */
    public TaskResultData withAssignedByEmployeeName(String assignedByEmployeeName) {
        Utils.checkNotNull(assignedByEmployeeName, "assignedByEmployeeName");
        this.assignedByEmployeeName = JsonNullable.of(assignedByEmployeeName);
        return this;
    }

    /**
     * The name of the employee who assigned this task
     */
    public TaskResultData withAssignedByEmployeeName(JsonNullable<String> assignedByEmployeeName) {
        Utils.checkNotNull(assignedByEmployeeName, "assignedByEmployeeName");
        this.assignedByEmployeeName = assignedByEmployeeName;
        return this;
    }

    /**
     * Link to the task in the provider system
     */
    public TaskResultData withLinkToTask(String linkToTask) {
        Utils.checkNotNull(linkToTask, "linkToTask");
        this.linkToTask = JsonNullable.of(linkToTask);
        return this;
    }

    /**
     * Link to the task in the provider system
     */
    public TaskResultData withLinkToTask(JsonNullable<String> linkToTask) {
        Utils.checkNotNull(linkToTask, "linkToTask");
        this.linkToTask = linkToTask;
        return this;
    }

    /**
     * List of extracted links from the task
     */
    public TaskResultData withExtractedLinks(List<String> extractedLinks) {
        Utils.checkNotNull(extractedLinks, "extractedLinks");
        this.extractedLinks = JsonNullable.of(extractedLinks);
        return this;
    }

    /**
     * List of extracted links from the task
     */
    public TaskResultData withExtractedLinks(JsonNullable<? extends List<String>> extractedLinks) {
        Utils.checkNotNull(extractedLinks, "extractedLinks");
        this.extractedLinks = extractedLinks;
        return this;
    }

    /**
     * ID of the next task in sequence
     */
    public TaskResultData withNextTaskId(String nextTaskId) {
        Utils.checkNotNull(nextTaskId, "nextTaskId");
        this.nextTaskId = JsonNullable.of(nextTaskId);
        return this;
    }

    /**
     * ID of the next task in sequence
     */
    public TaskResultData withNextTaskId(JsonNullable<String> nextTaskId) {
        Utils.checkNotNull(nextTaskId, "nextTaskId");
        this.nextTaskId = nextTaskId;
        return this;
    }

    /**
     * Name of the parent process of this task
     */
    public TaskResultData withParentProcessName(String parentProcessName) {
        Utils.checkNotNull(parentProcessName, "parentProcessName");
        this.parentProcessName = JsonNullable.of(parentProcessName);
        return this;
    }

    /**
     * Name of the parent process of this task
     */
    public TaskResultData withParentProcessName(JsonNullable<String> parentProcessName) {
        Utils.checkNotNull(parentProcessName, "parentProcessName");
        this.parentProcessName = parentProcessName;
        return this;
    }

    /**
     * The comments associated with this task
     */
    public TaskResultData withComments(List<TaskCommentApiModel> comments) {
        Utils.checkNotNull(comments, "comments");
        this.comments = JsonNullable.of(comments);
        return this;
    }

    /**
     * The comments associated with this task
     */
    public TaskResultData withComments(JsonNullable<? extends List<TaskCommentApiModel>> comments) {
        Utils.checkNotNull(comments, "comments");
        this.comments = comments;
        return this;
    }

    /**
     * The documents attached to this task
     */
    public TaskResultData withAttachments(List<File> attachments) {
        Utils.checkNotNull(attachments, "attachments");
        this.attachments = JsonNullable.of(attachments);
        return this;
    }

    /**
     * The documents attached to this task
     */
    public TaskResultData withAttachments(JsonNullable<? extends List<File>> attachments) {
        Utils.checkNotNull(attachments, "attachments");
        this.attachments = attachments;
        return this;
    }

    /**
     * The creation date of this task
     */
    public TaskResultData withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The creation date of this task
     */
    public TaskResultData withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * The last updated date of this task
     */
    public TaskResultData withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * The last updated date of this task
     */
    public TaskResultData withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TaskResultData other = (TaskResultData) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.employeeId, other.employeeId) &&
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.description, other.description) &&
            Utils.enhancedDeepEquals(this.type, other.type) &&
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.dueDate, other.dueDate) &&
            Utils.enhancedDeepEquals(this.completionDate, other.completionDate) &&
            Utils.enhancedDeepEquals(this.assignedByEmployeeId, other.assignedByEmployeeId) &&
            Utils.enhancedDeepEquals(this.assignedByEmployeeName, other.assignedByEmployeeName) &&
            Utils.enhancedDeepEquals(this.linkToTask, other.linkToTask) &&
            Utils.enhancedDeepEquals(this.extractedLinks, other.extractedLinks) &&
            Utils.enhancedDeepEquals(this.nextTaskId, other.nextTaskId) &&
            Utils.enhancedDeepEquals(this.parentProcessName, other.parentProcessName) &&
            Utils.enhancedDeepEquals(this.comments, other.comments) &&
            Utils.enhancedDeepEquals(this.attachments, other.attachments) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, employeeId,
            name, description, type,
            status, dueDate, completionDate,
            assignedByEmployeeId, assignedByEmployeeName, linkToTask,
            extractedLinks, nextTaskId, parentProcessName,
            comments, attachments, createdAt,
            updatedAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TaskResultData.class,
                "id", id,
                "remoteId", remoteId,
                "employeeId", employeeId,
                "name", name,
                "description", description,
                "type", type,
                "status", status,
                "dueDate", dueDate,
                "completionDate", completionDate,
                "assignedByEmployeeId", assignedByEmployeeId,
                "assignedByEmployeeName", assignedByEmployeeName,
                "linkToTask", linkToTask,
                "extractedLinks", extractedLinks,
                "nextTaskId", nextTaskId,
                "parentProcessName", parentProcessName,
                "comments", comments,
                "attachments", attachments,
                "createdAt", createdAt,
                "updatedAt", updatedAt);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<String> employeeId = JsonNullable.undefined();

        private JsonNullable<String> name = JsonNullable.undefined();

        private JsonNullable<String> description = JsonNullable.undefined();

        private JsonNullable<? extends TaskResultType> type = JsonNullable.undefined();

        private JsonNullable<? extends TaskResultStatus> status = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> dueDate = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> completionDate = JsonNullable.undefined();

        private JsonNullable<String> assignedByEmployeeId = JsonNullable.undefined();

        private JsonNullable<String> assignedByEmployeeName = JsonNullable.undefined();

        private JsonNullable<String> linkToTask = JsonNullable.undefined();

        private JsonNullable<? extends List<String>> extractedLinks = JsonNullable.undefined();

        private JsonNullable<String> nextTaskId = JsonNullable.undefined();

        private JsonNullable<String> parentProcessName = JsonNullable.undefined();

        private JsonNullable<? extends List<TaskCommentApiModel>> comments = JsonNullable.undefined();

        private JsonNullable<? extends List<File>> attachments = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * The employee ID associated with this task
         */
        public Builder employeeId(String employeeId) {
            Utils.checkNotNull(employeeId, "employeeId");
            this.employeeId = JsonNullable.of(employeeId);
            return this;
        }

        /**
         * The employee ID associated with this task
         */
        public Builder employeeId(JsonNullable<String> employeeId) {
            Utils.checkNotNull(employeeId, "employeeId");
            this.employeeId = employeeId;
            return this;
        }


        /**
         * The name of the task
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * The name of the task
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }


        /**
         * The description of the task
         */
        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = JsonNullable.of(description);
            return this;
        }

        /**
         * The description of the task
         */
        public Builder description(JsonNullable<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }


        /**
         * The type of the task
         */
        public Builder type(TaskResultType type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of(type);
            return this;
        }

        /**
         * The type of the task
         */
        public Builder type(JsonNullable<? extends TaskResultType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }


        /**
         * The status of the task
         */
        public Builder status(TaskResultStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = JsonNullable.of(status);
            return this;
        }

        /**
         * The status of the task
         */
        public Builder status(JsonNullable<? extends TaskResultStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        /**
         * The due date of the task
         */
        public Builder dueDate(OffsetDateTime dueDate) {
            Utils.checkNotNull(dueDate, "dueDate");
            this.dueDate = JsonNullable.of(dueDate);
            return this;
        }

        /**
         * The due date of the task
         */
        public Builder dueDate(JsonNullable<OffsetDateTime> dueDate) {
            Utils.checkNotNull(dueDate, "dueDate");
            this.dueDate = dueDate;
            return this;
        }


        /**
         * The completion date of the task
         */
        public Builder completionDate(OffsetDateTime completionDate) {
            Utils.checkNotNull(completionDate, "completionDate");
            this.completionDate = JsonNullable.of(completionDate);
            return this;
        }

        /**
         * The completion date of the task
         */
        public Builder completionDate(JsonNullable<OffsetDateTime> completionDate) {
            Utils.checkNotNull(completionDate, "completionDate");
            this.completionDate = completionDate;
            return this;
        }


        /**
         * The ID of the employee who assigned this task
         */
        public Builder assignedByEmployeeId(String assignedByEmployeeId) {
            Utils.checkNotNull(assignedByEmployeeId, "assignedByEmployeeId");
            this.assignedByEmployeeId = JsonNullable.of(assignedByEmployeeId);
            return this;
        }

        /**
         * The ID of the employee who assigned this task
         */
        public Builder assignedByEmployeeId(JsonNullable<String> assignedByEmployeeId) {
            Utils.checkNotNull(assignedByEmployeeId, "assignedByEmployeeId");
            this.assignedByEmployeeId = assignedByEmployeeId;
            return this;
        }


        /**
         * The name of the employee who assigned this task
         */
        public Builder assignedByEmployeeName(String assignedByEmployeeName) {
            Utils.checkNotNull(assignedByEmployeeName, "assignedByEmployeeName");
            this.assignedByEmployeeName = JsonNullable.of(assignedByEmployeeName);
            return this;
        }

        /**
         * The name of the employee who assigned this task
         */
        public Builder assignedByEmployeeName(JsonNullable<String> assignedByEmployeeName) {
            Utils.checkNotNull(assignedByEmployeeName, "assignedByEmployeeName");
            this.assignedByEmployeeName = assignedByEmployeeName;
            return this;
        }


        /**
         * Link to the task in the provider system
         */
        public Builder linkToTask(String linkToTask) {
            Utils.checkNotNull(linkToTask, "linkToTask");
            this.linkToTask = JsonNullable.of(linkToTask);
            return this;
        }

        /**
         * Link to the task in the provider system
         */
        public Builder linkToTask(JsonNullable<String> linkToTask) {
            Utils.checkNotNull(linkToTask, "linkToTask");
            this.linkToTask = linkToTask;
            return this;
        }


        /**
         * List of extracted links from the task
         */
        public Builder extractedLinks(List<String> extractedLinks) {
            Utils.checkNotNull(extractedLinks, "extractedLinks");
            this.extractedLinks = JsonNullable.of(extractedLinks);
            return this;
        }

        /**
         * List of extracted links from the task
         */
        public Builder extractedLinks(JsonNullable<? extends List<String>> extractedLinks) {
            Utils.checkNotNull(extractedLinks, "extractedLinks");
            this.extractedLinks = extractedLinks;
            return this;
        }


        /**
         * ID of the next task in sequence
         */
        public Builder nextTaskId(String nextTaskId) {
            Utils.checkNotNull(nextTaskId, "nextTaskId");
            this.nextTaskId = JsonNullable.of(nextTaskId);
            return this;
        }

        /**
         * ID of the next task in sequence
         */
        public Builder nextTaskId(JsonNullable<String> nextTaskId) {
            Utils.checkNotNull(nextTaskId, "nextTaskId");
            this.nextTaskId = nextTaskId;
            return this;
        }


        /**
         * Name of the parent process of this task
         */
        public Builder parentProcessName(String parentProcessName) {
            Utils.checkNotNull(parentProcessName, "parentProcessName");
            this.parentProcessName = JsonNullable.of(parentProcessName);
            return this;
        }

        /**
         * Name of the parent process of this task
         */
        public Builder parentProcessName(JsonNullable<String> parentProcessName) {
            Utils.checkNotNull(parentProcessName, "parentProcessName");
            this.parentProcessName = parentProcessName;
            return this;
        }


        /**
         * The comments associated with this task
         */
        public Builder comments(List<TaskCommentApiModel> comments) {
            Utils.checkNotNull(comments, "comments");
            this.comments = JsonNullable.of(comments);
            return this;
        }

        /**
         * The comments associated with this task
         */
        public Builder comments(JsonNullable<? extends List<TaskCommentApiModel>> comments) {
            Utils.checkNotNull(comments, "comments");
            this.comments = comments;
            return this;
        }


        /**
         * The documents attached to this task
         */
        public Builder attachments(List<File> attachments) {
            Utils.checkNotNull(attachments, "attachments");
            this.attachments = JsonNullable.of(attachments);
            return this;
        }

        /**
         * The documents attached to this task
         */
        public Builder attachments(JsonNullable<? extends List<File>> attachments) {
            Utils.checkNotNull(attachments, "attachments");
            this.attachments = attachments;
            return this;
        }


        /**
         * The creation date of this task
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The creation date of this task
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }


        /**
         * The last updated date of this task
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * The last updated date of this task
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public TaskResultData build() {

            return new TaskResultData(
                id, remoteId, employeeId,
                name, description, type,
                status, dueDate, completionDate,
                assignedByEmployeeId, assignedByEmployeeName, linkToTask,
                extractedLinks, nextTaskId, parentProcessName,
                comments, attachments, createdAt,
                updatedAt);
        }

    }
}
