/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HrisDocumentsPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;


public class HrisListEmployeeDocumentsResponse implements AsyncResponse {
    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<Blob> rawResponse;

    /**
     * The documents related to the employee with the given identifier were retrieved.
     */
    private Optional<? extends HrisDocumentsPaginated> hrisDocumentsPaginated;


    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisListEmployeeDocumentsResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Optional<? extends HrisDocumentsPaginated> hrisDocumentsPaginated,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(hrisDocumentsPaginated, "hrisDocumentsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.hrisDocumentsPaginated = hrisDocumentsPaginated;
        this.headers = headers;
    }
    
    public HrisListEmployeeDocumentsResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse,
            Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return rawResponse;
    }

    /**
     * The documents related to the employee with the given identifier were retrieved.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<HrisDocumentsPaginated> hrisDocumentsPaginated() {
        return (Optional<HrisDocumentsPaginated>) hrisDocumentsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTTP response content type for this operation
     */
    public HrisListEmployeeDocumentsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public HrisListEmployeeDocumentsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public HrisListEmployeeDocumentsResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The documents related to the employee with the given identifier were retrieved.
     */
    public HrisListEmployeeDocumentsResponse withHrisDocumentsPaginated(HrisDocumentsPaginated hrisDocumentsPaginated) {
        Utils.checkNotNull(hrisDocumentsPaginated, "hrisDocumentsPaginated");
        this.hrisDocumentsPaginated = Optional.ofNullable(hrisDocumentsPaginated);
        return this;
    }


    /**
     * The documents related to the employee with the given identifier were retrieved.
     */
    public HrisListEmployeeDocumentsResponse withHrisDocumentsPaginated(Optional<? extends HrisDocumentsPaginated> hrisDocumentsPaginated) {
        Utils.checkNotNull(hrisDocumentsPaginated, "hrisDocumentsPaginated");
        this.hrisDocumentsPaginated = hrisDocumentsPaginated;
        return this;
    }

    public HrisListEmployeeDocumentsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisListEmployeeDocumentsResponse other = (HrisListEmployeeDocumentsResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.hrisDocumentsPaginated, other.hrisDocumentsPaginated) &&
            Utils.enhancedDeepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType, statusCode, rawResponse,
            hrisDocumentsPaginated, headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisListEmployeeDocumentsResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "hrisDocumentsPaginated", hrisDocumentsPaginated,
                "headers", headers);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String contentType;

        private Integer statusCode;

        private HttpResponse<Blob> rawResponse;

        private Optional<? extends HrisDocumentsPaginated> hrisDocumentsPaginated = Optional.empty();

        private Map<String, List<String>> headers;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }


        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }


        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }


        /**
         * The documents related to the employee with the given identifier were retrieved.
         */
        public Builder hrisDocumentsPaginated(HrisDocumentsPaginated hrisDocumentsPaginated) {
            Utils.checkNotNull(hrisDocumentsPaginated, "hrisDocumentsPaginated");
            this.hrisDocumentsPaginated = Optional.ofNullable(hrisDocumentsPaginated);
            return this;
        }

        /**
         * The documents related to the employee with the given identifier were retrieved.
         */
        public Builder hrisDocumentsPaginated(Optional<? extends HrisDocumentsPaginated> hrisDocumentsPaginated) {
            Utils.checkNotNull(hrisDocumentsPaginated, "hrisDocumentsPaginated");
            this.hrisDocumentsPaginated = hrisDocumentsPaginated;
            return this;
        }


        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisListEmployeeDocumentsResponse build() {

            return new HrisListEmployeeDocumentsResponse(
                contentType, statusCode, rawResponse,
                hrisDocumentsPaginated, headers);
        }

    }
}
