/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java;

import com.stackone.stackone_client_java.Accounts;
import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.PatchAccountExternalDto;
import com.stackone.stackone_client_java.models.operations.StackoneDeleteAccountRequest;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountMetaInfoRequest;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountRequest;
import com.stackone.stackone_client_java.models.operations.StackoneListLinkedAccountsRequest;
import com.stackone.stackone_client_java.models.operations.StackoneUpdateAccountRequest;
import com.stackone.stackone_client_java.models.operations.async.StackoneDeleteAccountRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneDeleteAccountResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneGetAccountMetaInfoRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneGetAccountMetaInfoResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneGetAccountRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneGetAccountResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneListLinkedAccountsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneListLinkedAccountsResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneUpdateAccountRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneUpdateAccountResponse;
import com.stackone.stackone_client_java.operations.StackoneDeleteAccount;
import com.stackone.stackone_client_java.operations.StackoneGetAccount;
import com.stackone.stackone_client_java.operations.StackoneGetAccountMetaInfo;
import com.stackone.stackone_client_java.operations.StackoneListLinkedAccounts;
import com.stackone.stackone_client_java.operations.StackoneUpdateAccount;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncAccounts {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final Accounts syncSDK;

    AsyncAccounts(Accounts syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    public Accounts sync() {
        return this.syncSDK;
    }

    public StackoneListLinkedAccountsRequestBuilder listLinkedAccounts() {
        return new StackoneListLinkedAccountsRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<StackoneListLinkedAccountsResponse> listLinkedAccounts(StackoneListLinkedAccountsRequest request) {
        return this.listLinkedAccounts(request, Optional.empty());
    }

    public CompletableFuture<StackoneListLinkedAccountsResponse> listLinkedAccounts(StackoneListLinkedAccountsRequest request, Optional<Options> options) {
        StackoneListLinkedAccounts.Async operation = new StackoneListLinkedAccounts.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }

    public StackoneGetAccountRequestBuilder getAccount() {
        return new StackoneGetAccountRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<StackoneGetAccountResponse> getAccount(String id) {
        return this.getAccount(id, Optional.empty());
    }

    public CompletableFuture<StackoneGetAccountResponse> getAccount(String id, Optional<Options> options) {
        StackoneGetAccountRequest request = StackoneGetAccountRequest.builder().id(id).build();
        StackoneGetAccount.Async operation = new StackoneGetAccount.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }

    public StackoneDeleteAccountRequestBuilder deleteAccount() {
        return new StackoneDeleteAccountRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<StackoneDeleteAccountResponse> deleteAccount(String id) {
        return this.deleteAccount(id, Optional.empty());
    }

    public CompletableFuture<StackoneDeleteAccountResponse> deleteAccount(String id, Optional<Options> options) {
        StackoneDeleteAccountRequest request = StackoneDeleteAccountRequest.builder().id(id).build();
        StackoneDeleteAccount.Async operation = new StackoneDeleteAccount.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }

    public StackoneUpdateAccountRequestBuilder updateAccount() {
        return new StackoneUpdateAccountRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<StackoneUpdateAccountResponse> updateAccount(String id, PatchAccountExternalDto patchAccountExternalDto) {
        return this.updateAccount(id, patchAccountExternalDto, Optional.empty());
    }

    public CompletableFuture<StackoneUpdateAccountResponse> updateAccount(String id, PatchAccountExternalDto patchAccountExternalDto, Optional<Options> options) {
        StackoneUpdateAccountRequest request = StackoneUpdateAccountRequest.builder().id(id).patchAccountExternalDto(patchAccountExternalDto).build();
        StackoneUpdateAccount.Async operation = new StackoneUpdateAccount.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }

    public StackoneGetAccountMetaInfoRequestBuilder getAccountMetaInfo() {
        return new StackoneGetAccountMetaInfoRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<StackoneGetAccountMetaInfoResponse> getAccountMetaInfo(String id) {
        return this.getAccountMetaInfo(id, Optional.empty());
    }

    public CompletableFuture<StackoneGetAccountMetaInfoResponse> getAccountMetaInfo(String id, Optional<Options> options) {
        StackoneGetAccountMetaInfoRequest request = StackoneGetAccountMetaInfoRequest.builder().id(id).build();
        StackoneGetAccountMetaInfo.Async operation = new StackoneGetAccountMetaInfo.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

