/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class Method {
    public static final Method GET = new Method("get");
    public static final Method POST = new Method("post");
    public static final Method PUT = new Method("put");
    public static final Method DELETE = new Method("delete");
    public static final Method PATCH = new Method("patch");
    private static final Map<String, Method> values = Method.createValuesMap();
    private static final Map<String, MethodEnum> enums = Method.createEnumsMap();
    private final String value;

    private Method(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method of(String value) {
        Class<Method> clazz = Method.class;
        synchronized (Method.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new Method((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<MethodEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Method other = (Method)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "Method [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method[] values() {
        Class<Method> clazz = Method.class;
        synchronized (Method.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new Method[0]);
        }
    }

    private static final Map<String, Method> createValuesMap() {
        LinkedHashMap<String, Method> map = new LinkedHashMap<String, Method>();
        map.put("get", GET);
        map.put("post", POST);
        map.put("put", PUT);
        map.put("delete", DELETE);
        map.put("patch", PATCH);
        return map;
    }

    private static final Map<String, MethodEnum> createEnumsMap() {
        HashMap<String, MethodEnum> map = new HashMap<String, MethodEnum>();
        map.put("get", MethodEnum.GET);
        map.put("post", MethodEnum.POST);
        map.put("put", MethodEnum.PUT);
        map.put("delete", MethodEnum.DELETE);
        map.put("patch", MethodEnum.PATCH);
        return map;
    }

    public static enum MethodEnum {
        GET("get"),
        POST("post"),
        PUT("put"),
        DELETE("delete"),
        PATCH("patch");

        private final String value;

        private MethodEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<Method> {
        protected _Deserializer() {
            super(Method.class);
        }

        public Method deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return Method.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<Method> {
        protected _Serializer() {
            super(Method.class);
        }

        public void serialize(Method value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

