/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.PositionSourceValue;
import com.stackone.stackone_client_java.models.components.PositionValue;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class PositionStatus {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends PositionValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends PositionSourceValue> sourceValue;

    @JsonCreator
    public PositionStatus(@JsonProperty(value="value") JsonNullable<? extends PositionValue> value, @JsonProperty(value="source_value") JsonNullable<? extends PositionSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public PositionStatus() {
        this((JsonNullable<? extends PositionValue>)JsonNullable.undefined(), (JsonNullable<? extends PositionSourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<PositionValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<PositionSourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public PositionStatus withValue(PositionValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public PositionStatus withValue(JsonNullable<? extends PositionValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public PositionStatus withSourceValue(PositionSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public PositionStatus withSourceValue(JsonNullable<? extends PositionSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PositionStatus other = (PositionStatus)o;
        return Utils.enhancedDeepEquals(this.value, other.value) && Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(PositionStatus.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends PositionValue> value = JsonNullable.undefined();
        private JsonNullable<? extends PositionSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(PositionValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends PositionValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(PositionSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends PositionSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public PositionStatus build() {
            return new PositionStatus(this.value, this.sourceValue);
        }
    }
}

