/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AccountingJournalResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AccountingGetCompanyJournalResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends AccountingJournalResult> accountingJournalResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AccountingGetCompanyJournalResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends AccountingJournalResult> accountingJournalResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(accountingJournalResult, "accountingJournalResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.accountingJournalResult = accountingJournalResult;
        this.headers = headers;
    }

    public AccountingGetCompanyJournalResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AccountingJournalResult> accountingJournalResult() {
        return this.accountingJournalResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AccountingGetCompanyJournalResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AccountingGetCompanyJournalResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AccountingGetCompanyJournalResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AccountingGetCompanyJournalResponse withAccountingJournalResult(AccountingJournalResult accountingJournalResult) {
        Utils.checkNotNull(accountingJournalResult, "accountingJournalResult");
        this.accountingJournalResult = Optional.ofNullable(accountingJournalResult);
        return this;
    }

    public AccountingGetCompanyJournalResponse withAccountingJournalResult(Optional<? extends AccountingJournalResult> accountingJournalResult) {
        Utils.checkNotNull(accountingJournalResult, "accountingJournalResult");
        this.accountingJournalResult = accountingJournalResult;
        return this;
    }

    public AccountingGetCompanyJournalResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountingGetCompanyJournalResponse other = (AccountingGetCompanyJournalResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.accountingJournalResult, other.accountingJournalResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.accountingJournalResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AccountingGetCompanyJournalResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "accountingJournalResult", this.accountingJournalResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends AccountingJournalResult> accountingJournalResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder accountingJournalResult(AccountingJournalResult accountingJournalResult) {
            Utils.checkNotNull(accountingJournalResult, "accountingJournalResult");
            this.accountingJournalResult = Optional.ofNullable(accountingJournalResult);
            return this;
        }

        public Builder accountingJournalResult(Optional<? extends AccountingJournalResult> accountingJournalResult) {
            Utils.checkNotNull(accountingJournalResult, "accountingJournalResult");
            this.accountingJournalResult = accountingJournalResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AccountingGetCompanyJournalResponse build() {
            return new AccountingGetCompanyJournalResponse(this.contentType, this.statusCode, this.rawResponse, this.accountingJournalResult, this.headers);
        }
    }
}

