/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.HrisListTasksRequest;
import com.stackone.stackone_client_java.models.operations.HrisListTasksResponse;
import com.stackone.stackone_client_java.operations.HrisListTasks;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class HrisListTasksRequestBuilder {
    private HrisListTasksRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public HrisListTasksRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public HrisListTasksRequestBuilder request(HrisListTasksRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public HrisListTasksRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public HrisListTasksRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public HrisListTasksResponse call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        HrisListTasks.Sync operation = new HrisListTasks.Sync(this.sdkConfiguration, options, this._headers);
        return (HrisListTasksResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<HrisListTasksResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        HrisListTasks.Sync operation = new HrisListTasks.Sync(this.sdkConfiguration, options, this._headers);
        Paginator<HrisListTasksRequest, String> iterator = new Paginator<HrisListTasksRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), HrisListTasksRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<HrisListTasksResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

