/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.PlatformLogsPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StackoneListPlatformLogsResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends PlatformLogsPaginated> platformLogsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public StackoneListPlatformLogsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends PlatformLogsPaginated> platformLogsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(platformLogsPaginated, "platformLogsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.platformLogsPaginated = platformLogsPaginated;
        this.headers = headers;
    }

    public StackoneListPlatformLogsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<PlatformLogsPaginated> platformLogsPaginated() {
        return this.platformLogsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public StackoneListPlatformLogsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public StackoneListPlatformLogsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public StackoneListPlatformLogsResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public StackoneListPlatformLogsResponse withPlatformLogsPaginated(PlatformLogsPaginated platformLogsPaginated) {
        Utils.checkNotNull(platformLogsPaginated, "platformLogsPaginated");
        this.platformLogsPaginated = Optional.ofNullable(platformLogsPaginated);
        return this;
    }

    public StackoneListPlatformLogsResponse withPlatformLogsPaginated(Optional<? extends PlatformLogsPaginated> platformLogsPaginated) {
        Utils.checkNotNull(platformLogsPaginated, "platformLogsPaginated");
        this.platformLogsPaginated = platformLogsPaginated;
        return this;
    }

    public StackoneListPlatformLogsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackoneListPlatformLogsResponse other = (StackoneListPlatformLogsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.platformLogsPaginated, other.platformLogsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.platformLogsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(StackoneListPlatformLogsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "platformLogsPaginated", this.platformLogsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends PlatformLogsPaginated> platformLogsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder platformLogsPaginated(PlatformLogsPaginated platformLogsPaginated) {
            Utils.checkNotNull(platformLogsPaginated, "platformLogsPaginated");
            this.platformLogsPaginated = Optional.ofNullable(platformLogsPaginated);
            return this;
        }

        public Builder platformLogsPaginated(Optional<? extends PlatformLogsPaginated> platformLogsPaginated) {
            Utils.checkNotNull(platformLogsPaginated, "platformLogsPaginated");
            this.platformLogsPaginated = platformLogsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public StackoneListPlatformLogsResponse build() {
            return new StackoneListPlatformLogsResponse(this.contentType, this.statusCode, this.rawResponse, this.platformLogsPaginated, this.headers);
        }
    }
}

