/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.models.components.LmsBatchUpsertContentRequestDto;
import com.stackone.stackone_client_java.models.components.LmsCreateAssignmentRequestDto;
import com.stackone.stackone_client_java.models.components.LmsCreateCompletionRequestDto;
import com.stackone.stackone_client_java.models.components.LmsCreateContentRequestDto;
import com.stackone.stackone_client_java.models.components.LmsUpsertContentRequestDto;
import com.stackone.stackone_client_java.models.operations.LmsBatchUpsertContentRequest;
import com.stackone.stackone_client_java.models.operations.LmsCreateUserAssignmentRequest;
import com.stackone.stackone_client_java.models.operations.LmsCreateUserCompletionRequest;
import com.stackone.stackone_client_java.models.operations.LmsDeleteUserCompletionRequest;
import com.stackone.stackone_client_java.models.operations.LmsGetAssignmentRequest;
import com.stackone.stackone_client_java.models.operations.LmsGetCategoryRequest;
import com.stackone.stackone_client_java.models.operations.LmsGetCompletionRequest;
import com.stackone.stackone_client_java.models.operations.LmsGetContentRequest;
import com.stackone.stackone_client_java.models.operations.LmsGetCourseRequest;
import com.stackone.stackone_client_java.models.operations.LmsGetSkillRequest;
import com.stackone.stackone_client_java.models.operations.LmsGetUserAssignmentRequest;
import com.stackone.stackone_client_java.models.operations.LmsGetUserCompletionRequest;
import com.stackone.stackone_client_java.models.operations.LmsGetUserRequest;
import com.stackone.stackone_client_java.models.operations.LmsListAssignmentsRequest;
import com.stackone.stackone_client_java.models.operations.LmsListCategoriesRequest;
import com.stackone.stackone_client_java.models.operations.LmsListCompletionsRequest;
import com.stackone.stackone_client_java.models.operations.LmsListContentRequest;
import com.stackone.stackone_client_java.models.operations.LmsListCoursesRequest;
import com.stackone.stackone_client_java.models.operations.LmsListSkillsRequest;
import com.stackone.stackone_client_java.models.operations.LmsListUserAssignmentsRequest;
import com.stackone.stackone_client_java.models.operations.LmsListUserCompletionsRequest;
import com.stackone.stackone_client_java.models.operations.LmsListUsersRequest;
import com.stackone.stackone_client_java.models.operations.LmsUpdateContentRequest;
import com.stackone.stackone_client_java.models.operations.LmsUpsertContentRequest;
import com.stackone.stackone_client_java.models.operations.async.LmsBatchUpsertContentRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsBatchUpsertContentResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsCreateUserAssignmentRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsCreateUserAssignmentResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsCreateUserCompletionRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsCreateUserCompletionResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsDeleteUserCompletionRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsDeleteUserCompletionResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsGetAssignmentRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsGetAssignmentResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsGetCategoryRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsGetCategoryResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsGetCompletionRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsGetCompletionResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsGetContentRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsGetContentResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsGetCourseRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsGetCourseResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsGetSkillRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsGetSkillResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsGetUserAssignmentRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsGetUserAssignmentResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsGetUserCompletionRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsGetUserCompletionResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsGetUserRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsGetUserResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsListAssignmentsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsListAssignmentsResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsListCategoriesRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsListCategoriesResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsListCompletionsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsListCompletionsResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsListContentRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsListContentResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsListCoursesRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsListCoursesResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsListSkillsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsListSkillsResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsListUserAssignmentsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsListUserAssignmentsResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsListUserCompletionsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsListUserCompletionsResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsListUsersRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsListUsersResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsUpdateContentRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsUpdateContentResponse;
import com.stackone.stackone_client_java.models.operations.async.LmsUpsertContentRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.LmsUpsertContentResponse;
import com.stackone.stackone_client_java.operations.LmsBatchUpsertContent;
import com.stackone.stackone_client_java.operations.LmsCreateUserAssignment;
import com.stackone.stackone_client_java.operations.LmsCreateUserCompletion;
import com.stackone.stackone_client_java.operations.LmsDeleteUserCompletion;
import com.stackone.stackone_client_java.operations.LmsGetAssignment;
import com.stackone.stackone_client_java.operations.LmsGetCategory;
import com.stackone.stackone_client_java.operations.LmsGetCompletion;
import com.stackone.stackone_client_java.operations.LmsGetContent;
import com.stackone.stackone_client_java.operations.LmsGetCourse;
import com.stackone.stackone_client_java.operations.LmsGetSkill;
import com.stackone.stackone_client_java.operations.LmsGetUser;
import com.stackone.stackone_client_java.operations.LmsGetUserAssignment;
import com.stackone.stackone_client_java.operations.LmsGetUserCompletion;
import com.stackone.stackone_client_java.operations.LmsListAssignments;
import com.stackone.stackone_client_java.operations.LmsListCategories;
import com.stackone.stackone_client_java.operations.LmsListCompletions;
import com.stackone.stackone_client_java.operations.LmsListContent;
import com.stackone.stackone_client_java.operations.LmsListCourses;
import com.stackone.stackone_client_java.operations.LmsListSkills;
import com.stackone.stackone_client_java.operations.LmsListUserAssignments;
import com.stackone.stackone_client_java.operations.LmsListUserCompletions;
import com.stackone.stackone_client_java.operations.LmsListUsers;
import com.stackone.stackone_client_java.operations.LmsUpdateContent;
import com.stackone.stackone_client_java.operations.LmsUpsertContent;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;


public class AsyncLms {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final Lms syncSDK;

    AsyncLms(Lms syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    /**
     * Switches to the sync SDK.
     * 
     * @return The sync SDK
     */
    public Lms sync() {
        return syncSDK;
    }


    /**
     * List Courses
     * 
     * <p>Retrieve a list of course type learning objects.
     * 
     * <p>These are collections of content type learning objects that are grouped together for a specific
     * learning purpose.
     * 
     * @return The async call builder
     */
    public LmsListCoursesRequestBuilder listCourses() {
        return new LmsListCoursesRequestBuilder(sdkConfiguration);
    }

    /**
     * List Courses
     * 
     * <p>Retrieve a list of course type learning objects.
     * 
     * <p>These are collections of content type learning objects that are grouped together for a specific
     * learning purpose.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<LmsListCoursesResponse>} - The async response
     */
    public CompletableFuture<LmsListCoursesResponse> listCourses(LmsListCoursesRequest request) {
        return listCourses(request, Optional.empty());
    }

    /**
     * List Courses
     * 
     * <p>Retrieve a list of course type learning objects.
     * 
     * <p>These are collections of content type learning objects that are grouped together for a specific
     * learning purpose.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<LmsListCoursesResponse>} - The async response
     */
    public CompletableFuture<LmsListCoursesResponse> listCourses(LmsListCoursesRequest request, Optional<Options> options) {
        AsyncRequestOperation<LmsListCoursesRequest, LmsListCoursesResponse> operation
              = new LmsListCourses.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Course
     * 
     * <p>Retrieve a course type learning object by its identifier.
     * 
     * <p>These are collections of content type learning objects that are grouped together for a specific
     * learning purpose.
     * 
     * @return The async call builder
     */
    public LmsGetCourseRequestBuilder getCourse() {
        return new LmsGetCourseRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Course
     * 
     * <p>Retrieve a course type learning object by its identifier.
     * 
     * <p>These are collections of content type learning objects that are grouped together for a specific
     * learning purpose.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<LmsGetCourseResponse>} - The async response
     */
    public CompletableFuture<LmsGetCourseResponse> getCourse(LmsGetCourseRequest request) {
        return getCourse(request, Optional.empty());
    }

    /**
     * Get Course
     * 
     * <p>Retrieve a course type learning object by its identifier.
     * 
     * <p>These are collections of content type learning objects that are grouped together for a specific
     * learning purpose.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<LmsGetCourseResponse>} - The async response
     */
    public CompletableFuture<LmsGetCourseResponse> getCourse(LmsGetCourseRequest request, Optional<Options> options) {
        AsyncRequestOperation<LmsGetCourseRequest, LmsGetCourseResponse> operation
              = new LmsGetCourse.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List User Assignments
     * 
     * <p>Retrieve a list of assignment type learning records for a user.
     * 
     * <p>These are the records linking a user to learning objects.
     * 
     * <p>They can be pending, in progress, or completed.
     * 
     * @return The async call builder
     */
    public LmsListUserAssignmentsRequestBuilder listUserAssignments() {
        return new LmsListUserAssignmentsRequestBuilder(sdkConfiguration);
    }

    /**
     * List User Assignments
     * 
     * <p>Retrieve a list of assignment type learning records for a user.
     * 
     * <p>These are the records linking a user to learning objects.
     * 
     * <p>They can be pending, in progress, or completed.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<LmsListUserAssignmentsResponse>} - The async response
     */
    public CompletableFuture<LmsListUserAssignmentsResponse> listUserAssignments(LmsListUserAssignmentsRequest request) {
        return listUserAssignments(request, Optional.empty());
    }

    /**
     * List User Assignments
     * 
     * <p>Retrieve a list of assignment type learning records for a user.
     * 
     * <p>These are the records linking a user to learning objects.
     * 
     * <p>They can be pending, in progress, or completed.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<LmsListUserAssignmentsResponse>} - The async response
     */
    public CompletableFuture<LmsListUserAssignmentsResponse> listUserAssignments(LmsListUserAssignmentsRequest request, Optional<Options> options) {
        AsyncRequestOperation<LmsListUserAssignmentsRequest, LmsListUserAssignmentsResponse> operation
              = new LmsListUserAssignments.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Create User Assignment
     * 
     * <p>Create an assignment type learning record for a user.
     * 
     * <p>This is the record linking a user to a learning object.
     * 
     * <p>It can be pending or in progress.
     * 
     * @return The async call builder
     */
    public LmsCreateUserAssignmentRequestBuilder createUserAssignment() {
        return new LmsCreateUserAssignmentRequestBuilder(sdkConfiguration);
    }

    /**
     * Create User Assignment
     * 
     * <p>Create an assignment type learning record for a user.
     * 
     * <p>This is the record linking a user to a learning object.
     * 
     * <p>It can be pending or in progress.
     * 
     * @param xAccountId The account identifier
     * @param id 
     * @param lmsCreateAssignmentRequestDto 
     * @return {@code CompletableFuture<LmsCreateUserAssignmentResponse>} - The async response
     */
    public CompletableFuture<LmsCreateUserAssignmentResponse> createUserAssignment(
            String xAccountId, String id,
            LmsCreateAssignmentRequestDto lmsCreateAssignmentRequestDto) {
        return createUserAssignment(
                xAccountId, id, lmsCreateAssignmentRequestDto,
                Optional.empty());
    }

    /**
     * Create User Assignment
     * 
     * <p>Create an assignment type learning record for a user.
     * 
     * <p>This is the record linking a user to a learning object.
     * 
     * <p>It can be pending or in progress.
     * 
     * @param xAccountId The account identifier
     * @param id 
     * @param lmsCreateAssignmentRequestDto 
     * @param options additional options
     * @return {@code CompletableFuture<LmsCreateUserAssignmentResponse>} - The async response
     */
    public CompletableFuture<LmsCreateUserAssignmentResponse> createUserAssignment(
            String xAccountId, String id,
            LmsCreateAssignmentRequestDto lmsCreateAssignmentRequestDto, Optional<Options> options) {
        LmsCreateUserAssignmentRequest request =
            LmsCreateUserAssignmentRequest
                .builder()
                .xAccountId(xAccountId)
                .id(id)
                .lmsCreateAssignmentRequestDto(lmsCreateAssignmentRequestDto)
                .build();
        AsyncRequestOperation<LmsCreateUserAssignmentRequest, LmsCreateUserAssignmentResponse> operation
              = new LmsCreateUserAssignment.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get User Assignment
     * 
     * <p>Retrieve an assignment type learning record for a user by its identifier.
     * 
     * <p>This is the record linking a user to a learning object.
     * 
     * <p>It can be pending, in progress, or completed.
     * 
     * @return The async call builder
     */
    public LmsGetUserAssignmentRequestBuilder getUserAssignment() {
        return new LmsGetUserAssignmentRequestBuilder(sdkConfiguration);
    }

    /**
     * Get User Assignment
     * 
     * <p>Retrieve an assignment type learning record for a user by its identifier.
     * 
     * <p>This is the record linking a user to a learning object.
     * 
     * <p>It can be pending, in progress, or completed.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<LmsGetUserAssignmentResponse>} - The async response
     */
    public CompletableFuture<LmsGetUserAssignmentResponse> getUserAssignment(LmsGetUserAssignmentRequest request) {
        return getUserAssignment(request, Optional.empty());
    }

    /**
     * Get User Assignment
     * 
     * <p>Retrieve an assignment type learning record for a user by its identifier.
     * 
     * <p>This is the record linking a user to a learning object.
     * 
     * <p>It can be pending, in progress, or completed.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<LmsGetUserAssignmentResponse>} - The async response
     */
    public CompletableFuture<LmsGetUserAssignmentResponse> getUserAssignment(LmsGetUserAssignmentRequest request, Optional<Options> options) {
        AsyncRequestOperation<LmsGetUserAssignmentRequest, LmsGetUserAssignmentResponse> operation
              = new LmsGetUserAssignment.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Batch Upsert External Linking Learning Objects
     * 
     * <p>Batch upsert multiple external linking learning objects that redirect users to a provider platform
     * for consumption and progress tracking.
     * 
     * <p>See [here](https://docs.stackone.com/integration-guides/lms/external-content-providers/introduction)
     * for more information about external linking learning objects.
     * 
     * @return The async call builder
     */
    public LmsBatchUpsertContentRequestBuilder batchUpsertContent() {
        return new LmsBatchUpsertContentRequestBuilder(sdkConfiguration);
    }

    /**
     * Batch Upsert External Linking Learning Objects
     * 
     * <p>Batch upsert multiple external linking learning objects that redirect users to a provider platform
     * for consumption and progress tracking.
     * 
     * <p>See [here](https://docs.stackone.com/integration-guides/lms/external-content-providers/introduction)
     * for more information about external linking learning objects.
     * 
     * @param xAccountId The account identifier
     * @param lmsBatchUpsertContentRequestDto 
     * @return {@code CompletableFuture<LmsBatchUpsertContentResponse>} - The async response
     */
    public CompletableFuture<LmsBatchUpsertContentResponse> batchUpsertContent(String xAccountId, LmsBatchUpsertContentRequestDto lmsBatchUpsertContentRequestDto) {
        return batchUpsertContent(xAccountId, lmsBatchUpsertContentRequestDto, Optional.empty());
    }

    /**
     * Batch Upsert External Linking Learning Objects
     * 
     * <p>Batch upsert multiple external linking learning objects that redirect users to a provider platform
     * for consumption and progress tracking.
     * 
     * <p>See [here](https://docs.stackone.com/integration-guides/lms/external-content-providers/introduction)
     * for more information about external linking learning objects.
     * 
     * @param xAccountId The account identifier
     * @param lmsBatchUpsertContentRequestDto 
     * @param options additional options
     * @return {@code CompletableFuture<LmsBatchUpsertContentResponse>} - The async response
     */
    public CompletableFuture<LmsBatchUpsertContentResponse> batchUpsertContent(
            String xAccountId, LmsBatchUpsertContentRequestDto lmsBatchUpsertContentRequestDto,
            Optional<Options> options) {
        LmsBatchUpsertContentRequest request =
            LmsBatchUpsertContentRequest
                .builder()
                .xAccountId(xAccountId)
                .lmsBatchUpsertContentRequestDto(lmsBatchUpsertContentRequestDto)
                .build();
        AsyncRequestOperation<LmsBatchUpsertContentRequest, LmsBatchUpsertContentResponse> operation
              = new LmsBatchUpsertContent.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Content
     * 
     * <p>Retrieve a list of content type learning objects.
     * 
     * <p>These are the most granular learning objects (e.g. video, document, podcast) on a platform.
     * 
     * <p>Only content objects for which the platform supports progress and completion tracking are returned.
     * 
     * @return The async call builder
     */
    public LmsListContentRequestBuilder listContent() {
        return new LmsListContentRequestBuilder(sdkConfiguration);
    }

    /**
     * List Content
     * 
     * <p>Retrieve a list of content type learning objects.
     * 
     * <p>These are the most granular learning objects (e.g. video, document, podcast) on a platform.
     * 
     * <p>Only content objects for which the platform supports progress and completion tracking are returned.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<LmsListContentResponse>} - The async response
     */
    public CompletableFuture<LmsListContentResponse> listContent(LmsListContentRequest request) {
        return listContent(request, Optional.empty());
    }

    /**
     * List Content
     * 
     * <p>Retrieve a list of content type learning objects.
     * 
     * <p>These are the most granular learning objects (e.g. video, document, podcast) on a platform.
     * 
     * <p>Only content objects for which the platform supports progress and completion tracking are returned.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<LmsListContentResponse>} - The async response
     */
    public CompletableFuture<LmsListContentResponse> listContent(LmsListContentRequest request, Optional<Options> options) {
        AsyncRequestOperation<LmsListContentRequest, LmsListContentResponse> operation
              = new LmsListContent.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Upsert External Linking Learning Objects
     * 
     * <p>Create or update an external linking learning object that redirects users to a provider platform for
     * consumption and progress tracking.
     * 
     * <p>See [here](https://docs.stackone.com/integration-guides/lms/external-content-providers/introduction)
     * for more information about external linking learning objects.
     * 
     * @return The async call builder
     */
    public LmsUpsertContentRequestBuilder upsertContent() {
        return new LmsUpsertContentRequestBuilder(sdkConfiguration);
    }

    /**
     * Upsert External Linking Learning Objects
     * 
     * <p>Create or update an external linking learning object that redirects users to a provider platform for
     * consumption and progress tracking.
     * 
     * <p>See [here](https://docs.stackone.com/integration-guides/lms/external-content-providers/introduction)
     * for more information about external linking learning objects.
     * 
     * @param xAccountId The account identifier
     * @param lmsUpsertContentRequestDto 
     * @return {@code CompletableFuture<LmsUpsertContentResponse>} - The async response
     */
    public CompletableFuture<LmsUpsertContentResponse> upsertContent(String xAccountId, LmsUpsertContentRequestDto lmsUpsertContentRequestDto) {
        return upsertContent(xAccountId, lmsUpsertContentRequestDto, Optional.empty());
    }

    /**
     * Upsert External Linking Learning Objects
     * 
     * <p>Create or update an external linking learning object that redirects users to a provider platform for
     * consumption and progress tracking.
     * 
     * <p>See [here](https://docs.stackone.com/integration-guides/lms/external-content-providers/introduction)
     * for more information about external linking learning objects.
     * 
     * @param xAccountId The account identifier
     * @param lmsUpsertContentRequestDto 
     * @param options additional options
     * @return {@code CompletableFuture<LmsUpsertContentResponse>} - The async response
     */
    public CompletableFuture<LmsUpsertContentResponse> upsertContent(
            String xAccountId, LmsUpsertContentRequestDto lmsUpsertContentRequestDto,
            Optional<Options> options) {
        LmsUpsertContentRequest request =
            LmsUpsertContentRequest
                .builder()
                .xAccountId(xAccountId)
                .lmsUpsertContentRequestDto(lmsUpsertContentRequestDto)
                .build();
        AsyncRequestOperation<LmsUpsertContentRequest, LmsUpsertContentResponse> operation
              = new LmsUpsertContent.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Content
     * 
     * <p>Retrieve a content type learning object by its identifier.
     * 
     * <p>These are the most granular learning objects (e.g. video, document, podcast) on a platform.
     * 
     * <p>Only content objects for which the platform supports progress and completion tracking are returned.
     * 
     * @return The async call builder
     */
    public LmsGetContentRequestBuilder getContent() {
        return new LmsGetContentRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Content
     * 
     * <p>Retrieve a content type learning object by its identifier.
     * 
     * <p>These are the most granular learning objects (e.g. video, document, podcast) on a platform.
     * 
     * <p>Only content objects for which the platform supports progress and completion tracking are returned.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<LmsGetContentResponse>} - The async response
     */
    public CompletableFuture<LmsGetContentResponse> getContent(LmsGetContentRequest request) {
        return getContent(request, Optional.empty());
    }

    /**
     * Get Content
     * 
     * <p>Retrieve a content type learning object by its identifier.
     * 
     * <p>These are the most granular learning objects (e.g. video, document, podcast) on a platform.
     * 
     * <p>Only content objects for which the platform supports progress and completion tracking are returned.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<LmsGetContentResponse>} - The async response
     */
    public CompletableFuture<LmsGetContentResponse> getContent(LmsGetContentRequest request, Optional<Options> options) {
        AsyncRequestOperation<LmsGetContentRequest, LmsGetContentResponse> operation
              = new LmsGetContent.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Update External Linking Learning Objects
     * 
     * <p>Update an external linking learning object that redirects users to a provider platform for
     * consumption and progress tracking.
     * 
     * <p>See [here](https://docs.stackone.com/integration-guides/lms/external-content-providers/introduction)
     * for more information about external linking learning objects.
     * 
     * @return The async call builder
     */
    public LmsUpdateContentRequestBuilder updateContent() {
        return new LmsUpdateContentRequestBuilder(sdkConfiguration);
    }

    /**
     * Update External Linking Learning Objects
     * 
     * <p>Update an external linking learning object that redirects users to a provider platform for
     * consumption and progress tracking.
     * 
     * <p>See [here](https://docs.stackone.com/integration-guides/lms/external-content-providers/introduction)
     * for more information about external linking learning objects.
     * 
     * @param xAccountId The account identifier
     * @param id 
     * @param lmsCreateContentRequestDto 
     * @return {@code CompletableFuture<LmsUpdateContentResponse>} - The async response
     */
    public CompletableFuture<LmsUpdateContentResponse> updateContent(
            String xAccountId, String id,
            LmsCreateContentRequestDto lmsCreateContentRequestDto) {
        return updateContent(
                xAccountId, id, lmsCreateContentRequestDto,
                Optional.empty());
    }

    /**
     * Update External Linking Learning Objects
     * 
     * <p>Update an external linking learning object that redirects users to a provider platform for
     * consumption and progress tracking.
     * 
     * <p>See [here](https://docs.stackone.com/integration-guides/lms/external-content-providers/introduction)
     * for more information about external linking learning objects.
     * 
     * @param xAccountId The account identifier
     * @param id 
     * @param lmsCreateContentRequestDto 
     * @param options additional options
     * @return {@code CompletableFuture<LmsUpdateContentResponse>} - The async response
     */
    public CompletableFuture<LmsUpdateContentResponse> updateContent(
            String xAccountId, String id,
            LmsCreateContentRequestDto lmsCreateContentRequestDto, Optional<Options> options) {
        LmsUpdateContentRequest request =
            LmsUpdateContentRequest
                .builder()
                .xAccountId(xAccountId)
                .id(id)
                .lmsCreateContentRequestDto(lmsCreateContentRequestDto)
                .build();
        AsyncRequestOperation<LmsUpdateContentRequest, LmsUpdateContentResponse> operation
              = new LmsUpdateContent.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List User Completions
     * 
     * <p>Retrieve a list of completed learning records for a user.
     * 
     * <p>These are the records of a user completing learning objects.
     * 
     * @return The async call builder
     */
    public LmsListUserCompletionsRequestBuilder listUserCompletions() {
        return new LmsListUserCompletionsRequestBuilder(sdkConfiguration);
    }

    /**
     * List User Completions
     * 
     * <p>Retrieve a list of completed learning records for a user.
     * 
     * <p>These are the records of a user completing learning objects.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<LmsListUserCompletionsResponse>} - The async response
     */
    public CompletableFuture<LmsListUserCompletionsResponse> listUserCompletions(LmsListUserCompletionsRequest request) {
        return listUserCompletions(request, Optional.empty());
    }

    /**
     * List User Completions
     * 
     * <p>Retrieve a list of completed learning records for a user.
     * 
     * <p>These are the records of a user completing learning objects.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<LmsListUserCompletionsResponse>} - The async response
     */
    public CompletableFuture<LmsListUserCompletionsResponse> listUserCompletions(LmsListUserCompletionsRequest request, Optional<Options> options) {
        AsyncRequestOperation<LmsListUserCompletionsRequest, LmsListUserCompletionsResponse> operation
              = new LmsListUserCompletions.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Create User Completion
     * 
     * <p>Create a completed learning record for a user.
     * 
     * <p>This is the record of a user completing a learning object.
     * 
     * @return The async call builder
     */
    public LmsCreateUserCompletionRequestBuilder createUserCompletion() {
        return new LmsCreateUserCompletionRequestBuilder(sdkConfiguration);
    }

    /**
     * Create User Completion
     * 
     * <p>Create a completed learning record for a user.
     * 
     * <p>This is the record of a user completing a learning object.
     * 
     * @param xAccountId The account identifier
     * @param id 
     * @param lmsCreateCompletionRequestDto 
     * @return {@code CompletableFuture<LmsCreateUserCompletionResponse>} - The async response
     */
    public CompletableFuture<LmsCreateUserCompletionResponse> createUserCompletion(
            String xAccountId, String id,
            LmsCreateCompletionRequestDto lmsCreateCompletionRequestDto) {
        return createUserCompletion(
                xAccountId, id, lmsCreateCompletionRequestDto,
                Optional.empty());
    }

    /**
     * Create User Completion
     * 
     * <p>Create a completed learning record for a user.
     * 
     * <p>This is the record of a user completing a learning object.
     * 
     * @param xAccountId The account identifier
     * @param id 
     * @param lmsCreateCompletionRequestDto 
     * @param options additional options
     * @return {@code CompletableFuture<LmsCreateUserCompletionResponse>} - The async response
     */
    public CompletableFuture<LmsCreateUserCompletionResponse> createUserCompletion(
            String xAccountId, String id,
            LmsCreateCompletionRequestDto lmsCreateCompletionRequestDto, Optional<Options> options) {
        LmsCreateUserCompletionRequest request =
            LmsCreateUserCompletionRequest
                .builder()
                .xAccountId(xAccountId)
                .id(id)
                .lmsCreateCompletionRequestDto(lmsCreateCompletionRequestDto)
                .build();
        AsyncRequestOperation<LmsCreateUserCompletionRequest, LmsCreateUserCompletionResponse> operation
              = new LmsCreateUserCompletion.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get User Completion
     * 
     * <p>Retrieve a completed learning record for a user by its identifier.
     * 
     * <p>This is the record of a user completing a learning object.
     * 
     * @return The async call builder
     */
    public LmsGetUserCompletionRequestBuilder getUserCompletion() {
        return new LmsGetUserCompletionRequestBuilder(sdkConfiguration);
    }

    /**
     * Get User Completion
     * 
     * <p>Retrieve a completed learning record for a user by its identifier.
     * 
     * <p>This is the record of a user completing a learning object.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<LmsGetUserCompletionResponse>} - The async response
     */
    public CompletableFuture<LmsGetUserCompletionResponse> getUserCompletion(LmsGetUserCompletionRequest request) {
        return getUserCompletion(request, Optional.empty());
    }

    /**
     * Get User Completion
     * 
     * <p>Retrieve a completed learning record for a user by its identifier.
     * 
     * <p>This is the record of a user completing a learning object.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<LmsGetUserCompletionResponse>} - The async response
     */
    public CompletableFuture<LmsGetUserCompletionResponse> getUserCompletion(LmsGetUserCompletionRequest request, Optional<Options> options) {
        AsyncRequestOperation<LmsGetUserCompletionRequest, LmsGetUserCompletionResponse> operation
              = new LmsGetUserCompletion.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Delete User Completion
     * 
     * <p>Delete a completion type learning record for a user.
     * 
     * <p>This is a record of a user completing a learning object.
     * 
     * @return The async call builder
     */
    public LmsDeleteUserCompletionRequestBuilder deleteUserCompletion() {
        return new LmsDeleteUserCompletionRequestBuilder(sdkConfiguration);
    }

    /**
     * Delete User Completion
     * 
     * <p>Delete a completion type learning record for a user.
     * 
     * <p>This is a record of a user completing a learning object.
     * 
     * @param xAccountId The account identifier
     * @param id 
     * @param subResourceId 
     * @return {@code CompletableFuture<LmsDeleteUserCompletionResponse>} - The async response
     */
    public CompletableFuture<LmsDeleteUserCompletionResponse> deleteUserCompletion(
            String xAccountId, String id,
            String subResourceId) {
        return deleteUserCompletion(
                xAccountId, id, subResourceId,
                Optional.empty());
    }

    /**
     * Delete User Completion
     * 
     * <p>Delete a completion type learning record for a user.
     * 
     * <p>This is a record of a user completing a learning object.
     * 
     * @param xAccountId The account identifier
     * @param id 
     * @param subResourceId 
     * @param options additional options
     * @return {@code CompletableFuture<LmsDeleteUserCompletionResponse>} - The async response
     */
    public CompletableFuture<LmsDeleteUserCompletionResponse> deleteUserCompletion(
            String xAccountId, String id,
            String subResourceId, Optional<Options> options) {
        LmsDeleteUserCompletionRequest request =
            LmsDeleteUserCompletionRequest
                .builder()
                .xAccountId(xAccountId)
                .id(id)
                .subResourceId(subResourceId)
                .build();
        AsyncRequestOperation<LmsDeleteUserCompletionRequest, LmsDeleteUserCompletionResponse> operation
              = new LmsDeleteUserCompletion.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Completions
     * 
     * <p>Retrieve a list of completed learning records. These are the records of a user completing learning
     * objects.
     * 
     * @return The async call builder
     */
    public LmsListCompletionsRequestBuilder listCompletions() {
        return new LmsListCompletionsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Completions
     * 
     * <p>Retrieve a list of completed learning records. These are the records of a user completing learning
     * objects.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<LmsListCompletionsResponse>} - The async response
     */
    public CompletableFuture<LmsListCompletionsResponse> listCompletions(LmsListCompletionsRequest request) {
        return listCompletions(request, Optional.empty());
    }

    /**
     * List Completions
     * 
     * <p>Retrieve a list of completed learning records. These are the records of a user completing learning
     * objects.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<LmsListCompletionsResponse>} - The async response
     */
    public CompletableFuture<LmsListCompletionsResponse> listCompletions(LmsListCompletionsRequest request, Optional<Options> options) {
        AsyncRequestOperation<LmsListCompletionsRequest, LmsListCompletionsResponse> operation
              = new LmsListCompletions.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Completion
     * 
     * <p>Retrieve a completed learning record by its identifier. This is the record of a user completing a
     * learning object.
     * 
     * @return The async call builder
     */
    public LmsGetCompletionRequestBuilder getCompletion() {
        return new LmsGetCompletionRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Completion
     * 
     * <p>Retrieve a completed learning record by its identifier. This is the record of a user completing a
     * learning object.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<LmsGetCompletionResponse>} - The async response
     */
    public CompletableFuture<LmsGetCompletionResponse> getCompletion(LmsGetCompletionRequest request) {
        return getCompletion(request, Optional.empty());
    }

    /**
     * Get Completion
     * 
     * <p>Retrieve a completed learning record by its identifier. This is the record of a user completing a
     * learning object.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<LmsGetCompletionResponse>} - The async response
     */
    public CompletableFuture<LmsGetCompletionResponse> getCompletion(LmsGetCompletionRequest request, Optional<Options> options) {
        AsyncRequestOperation<LmsGetCompletionRequest, LmsGetCompletionResponse> operation
              = new LmsGetCompletion.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Category
     * 
     * @return The async call builder
     */
    public LmsGetCategoryRequestBuilder getCategory() {
        return new LmsGetCategoryRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Category
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<LmsGetCategoryResponse>} - The async response
     */
    public CompletableFuture<LmsGetCategoryResponse> getCategory(LmsGetCategoryRequest request) {
        return getCategory(request, Optional.empty());
    }

    /**
     * Get Category
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<LmsGetCategoryResponse>} - The async response
     */
    public CompletableFuture<LmsGetCategoryResponse> getCategory(LmsGetCategoryRequest request, Optional<Options> options) {
        AsyncRequestOperation<LmsGetCategoryRequest, LmsGetCategoryResponse> operation
              = new LmsGetCategory.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Categories
     * 
     * @return The async call builder
     */
    public LmsListCategoriesRequestBuilder listCategories() {
        return new LmsListCategoriesRequestBuilder(sdkConfiguration);
    }

    /**
     * List Categories
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<LmsListCategoriesResponse>} - The async response
     */
    public CompletableFuture<LmsListCategoriesResponse> listCategories(LmsListCategoriesRequest request) {
        return listCategories(request, Optional.empty());
    }

    /**
     * List Categories
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<LmsListCategoriesResponse>} - The async response
     */
    public CompletableFuture<LmsListCategoriesResponse> listCategories(LmsListCategoriesRequest request, Optional<Options> options) {
        AsyncRequestOperation<LmsListCategoriesRequest, LmsListCategoriesResponse> operation
              = new LmsListCategories.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Users
     * 
     * @return The async call builder
     */
    public LmsListUsersRequestBuilder listUsers() {
        return new LmsListUsersRequestBuilder(sdkConfiguration);
    }

    /**
     * List Users
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<LmsListUsersResponse>} - The async response
     */
    public CompletableFuture<LmsListUsersResponse> listUsers(LmsListUsersRequest request) {
        return listUsers(request, Optional.empty());
    }

    /**
     * List Users
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<LmsListUsersResponse>} - The async response
     */
    public CompletableFuture<LmsListUsersResponse> listUsers(LmsListUsersRequest request, Optional<Options> options) {
        AsyncRequestOperation<LmsListUsersRequest, LmsListUsersResponse> operation
              = new LmsListUsers.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get User
     * 
     * @return The async call builder
     */
    public LmsGetUserRequestBuilder getUser() {
        return new LmsGetUserRequestBuilder(sdkConfiguration);
    }

    /**
     * Get User
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<LmsGetUserResponse>} - The async response
     */
    public CompletableFuture<LmsGetUserResponse> getUser(LmsGetUserRequest request) {
        return getUser(request, Optional.empty());
    }

    /**
     * Get User
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<LmsGetUserResponse>} - The async response
     */
    public CompletableFuture<LmsGetUserResponse> getUser(LmsGetUserRequest request, Optional<Options> options) {
        AsyncRequestOperation<LmsGetUserRequest, LmsGetUserResponse> operation
              = new LmsGetUser.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Skill
     * 
     * @return The async call builder
     */
    public LmsGetSkillRequestBuilder getSkill() {
        return new LmsGetSkillRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Skill
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<LmsGetSkillResponse>} - The async response
     */
    public CompletableFuture<LmsGetSkillResponse> getSkill(LmsGetSkillRequest request) {
        return getSkill(request, Optional.empty());
    }

    /**
     * Get Skill
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<LmsGetSkillResponse>} - The async response
     */
    public CompletableFuture<LmsGetSkillResponse> getSkill(LmsGetSkillRequest request, Optional<Options> options) {
        AsyncRequestOperation<LmsGetSkillRequest, LmsGetSkillResponse> operation
              = new LmsGetSkill.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Skills
     * 
     * @return The async call builder
     */
    public LmsListSkillsRequestBuilder listSkills() {
        return new LmsListSkillsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Skills
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<LmsListSkillsResponse>} - The async response
     */
    public CompletableFuture<LmsListSkillsResponse> listSkills(LmsListSkillsRequest request) {
        return listSkills(request, Optional.empty());
    }

    /**
     * List Skills
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<LmsListSkillsResponse>} - The async response
     */
    public CompletableFuture<LmsListSkillsResponse> listSkills(LmsListSkillsRequest request, Optional<Options> options) {
        AsyncRequestOperation<LmsListSkillsRequest, LmsListSkillsResponse> operation
              = new LmsListSkills.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Assignments
     * 
     * <p>Retrieve a list of assignment type learning records.
     * 
     * <p>These are the records linking a user to a learning object.
     * 
     * <p>They can be pending, in progress, or completed.
     * 
     * @return The async call builder
     */
    public LmsListAssignmentsRequestBuilder listAssignments() {
        return new LmsListAssignmentsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Assignments
     * 
     * <p>Retrieve a list of assignment type learning records.
     * 
     * <p>These are the records linking a user to a learning object.
     * 
     * <p>They can be pending, in progress, or completed.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<LmsListAssignmentsResponse>} - The async response
     */
    public CompletableFuture<LmsListAssignmentsResponse> listAssignments(LmsListAssignmentsRequest request) {
        return listAssignments(request, Optional.empty());
    }

    /**
     * List Assignments
     * 
     * <p>Retrieve a list of assignment type learning records.
     * 
     * <p>These are the records linking a user to a learning object.
     * 
     * <p>They can be pending, in progress, or completed.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<LmsListAssignmentsResponse>} - The async response
     */
    public CompletableFuture<LmsListAssignmentsResponse> listAssignments(LmsListAssignmentsRequest request, Optional<Options> options) {
        AsyncRequestOperation<LmsListAssignmentsRequest, LmsListAssignmentsResponse> operation
              = new LmsListAssignments.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Assignment
     * 
     * <p>Retrieve an assignment type learning record by its identifier.
     * 
     * <p>This is the record linking a user to a learning object.
     * 
     * <p>It can be pending, in progress, or completed.
     * 
     * @return The async call builder
     */
    public LmsGetAssignmentRequestBuilder getAssignment() {
        return new LmsGetAssignmentRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Assignment
     * 
     * <p>Retrieve an assignment type learning record by its identifier.
     * 
     * <p>This is the record linking a user to a learning object.
     * 
     * <p>It can be pending, in progress, or completed.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<LmsGetAssignmentResponse>} - The async response
     */
    public CompletableFuture<LmsGetAssignmentResponse> getAssignment(LmsGetAssignmentRequest request) {
        return getAssignment(request, Optional.empty());
    }

    /**
     * Get Assignment
     * 
     * <p>Retrieve an assignment type learning record by its identifier.
     * 
     * <p>This is the record linking a user to a learning object.
     * 
     * <p>It can be pending, in progress, or completed.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<LmsGetAssignmentResponse>} - The async response
     */
    public CompletableFuture<LmsGetAssignmentResponse> getAssignment(LmsGetAssignmentRequest request, Optional<Options> options) {
        AsyncRequestOperation<LmsGetAssignmentRequest, LmsGetAssignmentResponse> operation
              = new LmsGetAssignment.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

}
