/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.StackoneListStepLogsRequest;
import com.stackone.stackone_client_java.operations.StackoneListStepLogs;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class StackoneListStepLogsRequestBuilder {

    private StackoneListStepLogsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public StackoneListStepLogsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public StackoneListStepLogsRequestBuilder request(StackoneListStepLogsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }
                
    public StackoneListStepLogsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneListStepLogsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CompletableFuture<StackoneListStepLogsResponse> call() {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<StackoneListStepLogsRequest, StackoneListStepLogsResponse> operation
              = new StackoneListStepLogs.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);

        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }
}
