/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * AssignmentValue
 * 
 * <p>The StackOne unified assignment status.
 */
@JsonDeserialize(using = AssignmentValue._Deserializer.class)
@JsonSerialize(using = AssignmentValue._Serializer.class)
public class AssignmentValue {

    public static final AssignmentValue PENDING = new AssignmentValue("pending");
    public static final AssignmentValue IN_PROGRESS = new AssignmentValue("in_progress");
    public static final AssignmentValue COMPLETED = new AssignmentValue("completed");
    public static final AssignmentValue UNMAPPED_VALUE = new AssignmentValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, AssignmentValue> values = createValuesMap();
    private static final Map<String, AssignmentValueEnum> enums = createEnumsMap();

    private final String value;

    private AssignmentValue(String value) {
        this.value = value;
    }

    /**
     * Returns a AssignmentValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as AssignmentValue
     */ 
    public static AssignmentValue of(String value) {
        synchronized (AssignmentValue.class) {
            return values.computeIfAbsent(value, v -> new AssignmentValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<AssignmentValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AssignmentValue other = (AssignmentValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "AssignmentValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static AssignmentValue[] values() {
        synchronized (AssignmentValue.class) {
            return values.values().toArray(new AssignmentValue[] {});
        }
    }

    private static final Map<String, AssignmentValue> createValuesMap() {
        Map<String, AssignmentValue> map = new LinkedHashMap<>();
        map.put("pending", PENDING);
        map.put("in_progress", IN_PROGRESS);
        map.put("completed", COMPLETED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AssignmentValueEnum> createEnumsMap() {
        Map<String, AssignmentValueEnum> map = new HashMap<>();
        map.put("pending", AssignmentValueEnum.PENDING);
        map.put("in_progress", AssignmentValueEnum.IN_PROGRESS);
        map.put("completed", AssignmentValueEnum.COMPLETED);
        map.put("unmapped_value", AssignmentValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<AssignmentValue> {

        protected _Serializer() {
            super(AssignmentValue.class);
        }

        @Override
        public void serialize(AssignmentValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<AssignmentValue> {

        protected _Deserializer() {
            super(AssignmentValue.class);
        }

        @Override
        public AssignmentValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return AssignmentValue.of(v);
        }
    }
    
    public enum AssignmentValueEnum {

        PENDING("pending"),
        IN_PROGRESS("in_progress"),
        COMPLETED("completed"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private AssignmentValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

