/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
@JsonDeserialize(using = EmploymentDivisionValue._Deserializer.class)
@JsonSerialize(using = EmploymentDivisionValue._Serializer.class)
public class EmploymentDivisionValue {

    public static final EmploymentDivisionValue WORKSPACE = new EmploymentDivisionValue("workspace");
    public static final EmploymentDivisionValue TEAM = new EmploymentDivisionValue("team");
    public static final EmploymentDivisionValue DEPARTMENT = new EmploymentDivisionValue("department");
    public static final EmploymentDivisionValue GROUP = new EmploymentDivisionValue("group");
    public static final EmploymentDivisionValue ORGANIZATION = new EmploymentDivisionValue("organization");
    public static final EmploymentDivisionValue UNMAPPED_VALUE = new EmploymentDivisionValue("unmapped_value");
    public static final EmploymentDivisionValue COST_CENTER = new EmploymentDivisionValue("cost_center");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, EmploymentDivisionValue> values = createValuesMap();
    private static final Map<String, EmploymentDivisionValueEnum> enums = createEnumsMap();

    private final String value;

    private EmploymentDivisionValue(String value) {
        this.value = value;
    }

    /**
     * Returns a EmploymentDivisionValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as EmploymentDivisionValue
     */ 
    public static EmploymentDivisionValue of(String value) {
        synchronized (EmploymentDivisionValue.class) {
            return values.computeIfAbsent(value, v -> new EmploymentDivisionValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<EmploymentDivisionValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        EmploymentDivisionValue other = (EmploymentDivisionValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "EmploymentDivisionValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static EmploymentDivisionValue[] values() {
        synchronized (EmploymentDivisionValue.class) {
            return values.values().toArray(new EmploymentDivisionValue[] {});
        }
    }

    private static final Map<String, EmploymentDivisionValue> createValuesMap() {
        Map<String, EmploymentDivisionValue> map = new LinkedHashMap<>();
        map.put("workspace", WORKSPACE);
        map.put("team", TEAM);
        map.put("department", DEPARTMENT);
        map.put("group", GROUP);
        map.put("organization", ORGANIZATION);
        map.put("unmapped_value", UNMAPPED_VALUE);
        map.put("cost_center", COST_CENTER);
        return map;
    }

    private static final Map<String, EmploymentDivisionValueEnum> createEnumsMap() {
        Map<String, EmploymentDivisionValueEnum> map = new HashMap<>();
        map.put("workspace", EmploymentDivisionValueEnum.WORKSPACE);
        map.put("team", EmploymentDivisionValueEnum.TEAM);
        map.put("department", EmploymentDivisionValueEnum.DEPARTMENT);
        map.put("group", EmploymentDivisionValueEnum.GROUP);
        map.put("organization", EmploymentDivisionValueEnum.ORGANIZATION);
        map.put("unmapped_value", EmploymentDivisionValueEnum.UNMAPPED_VALUE);
        map.put("cost_center", EmploymentDivisionValueEnum.COST_CENTER);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<EmploymentDivisionValue> {

        protected _Serializer() {
            super(EmploymentDivisionValue.class);
        }

        @Override
        public void serialize(EmploymentDivisionValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<EmploymentDivisionValue> {

        protected _Deserializer() {
            super(EmploymentDivisionValue.class);
        }

        @Override
        public EmploymentDivisionValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return EmploymentDivisionValue.of(v);
        }
    }
    
    public enum EmploymentDivisionValueEnum {

        WORKSPACE("workspace"),
        TEAM("team"),
        DEPARTMENT("department"),
        GROUP("group"),
        ORGANIZATION("organization"),
        UNMAPPED_VALUE("unmapped_value"),
        COST_CENTER("cost_center"),;

        private final String value;

        private EmploymentDivisionValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

